/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH32_state_t")
public class XXH32State
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN_32;
    public static final int LARGE_LEN;
    public static final int V1;
    public static final int V2;
    public static final int V3;
    public static final int V4;
    public static final int MEM32;
    public static final int MEMSIZE;
    public static final int RESERVED;

    XXH32State(long address, ByteBuffer container) {
        super(address, container);
    }

    public XXH32State(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), XXH32State.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int total_len_32() {
        return XXH32State.ntotal_len_32(this.address());
    }

    @NativeType(value="unsigned")
    public int large_len() {
        return XXH32State.nlarge_len(this.address());
    }

    @NativeType(value="unsigned")
    public int v1() {
        return XXH32State.nv1(this.address());
    }

    @NativeType(value="unsigned")
    public int v2() {
        return XXH32State.nv2(this.address());
    }

    @NativeType(value="unsigned")
    public int v3() {
        return XXH32State.nv3(this.address());
    }

    @NativeType(value="unsigned")
    public int v4() {
        return XXH32State.nv4(this.address());
    }

    @NativeType(value="unsigned[4]")
    public IntBuffer mem32() {
        return XXH32State.nmem32(this.address());
    }

    @NativeType(value="unsigned")
    public int mem32(int index) {
        return XXH32State.nmem32(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int memsize() {
        return XXH32State.nmemsize(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved() {
        return XXH32State.nreserved(this.address());
    }

    public XXH32State total_len_32(@NativeType(value="unsigned") int value) {
        XXH32State.ntotal_len_32(this.address(), value);
        return this;
    }

    public XXH32State large_len(@NativeType(value="unsigned") int value) {
        XXH32State.nlarge_len(this.address(), value);
        return this;
    }

    public XXH32State v1(@NativeType(value="unsigned") int value) {
        XXH32State.nv1(this.address(), value);
        return this;
    }

    public XXH32State v2(@NativeType(value="unsigned") int value) {
        XXH32State.nv2(this.address(), value);
        return this;
    }

    public XXH32State v3(@NativeType(value="unsigned") int value) {
        XXH32State.nv3(this.address(), value);
        return this;
    }

    public XXH32State v4(@NativeType(value="unsigned") int value) {
        XXH32State.nv4(this.address(), value);
        return this;
    }

    public XXH32State mem32(@NativeType(value="unsigned[4]") IntBuffer value) {
        XXH32State.nmem32(this.address(), value);
        return this;
    }

    public XXH32State mem32(int index, @NativeType(value="unsigned") int value) {
        XXH32State.nmem32(this.address(), index, value);
        return this;
    }

    public XXH32State memsize(@NativeType(value="unsigned") int value) {
        XXH32State.nmemsize(this.address(), value);
        return this;
    }

    public XXH32State reserved(@NativeType(value="unsigned") int value) {
        XXH32State.nreserved(this.address(), value);
        return this;
    }

    public XXH32State set(int total_len_32, int large_len, int v1, int v2, int v3, int v4, IntBuffer mem32, int memsize, int reserved) {
        this.total_len_32(total_len_32);
        this.large_len(large_len);
        this.v1(v1);
        this.v2(v2);
        this.v3(v3);
        this.v4(v4);
        this.mem32(mem32);
        this.memsize(memsize);
        this.reserved(reserved);
        return this;
    }

    public XXH32State set(XXH32State src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XXH32State malloc() {
        return XXH32State.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static XXH32State calloc() {
        return XXH32State.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static XXH32State create() {
        return new XXH32State(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static XXH32State create(long address) {
        return address == 0L ? null : new XXH32State(address, null);
    }

    public static Buffer malloc(int capacity) {
        return XXH32State.create(XXH32State.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH32State.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(XXH32State.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static XXH32State mallocStack() {
        return XXH32State.mallocStack(MemoryStack.stackGet());
    }

    public static XXH32State callocStack() {
        return XXH32State.callocStack(MemoryStack.stackGet());
    }

    public static XXH32State mallocStack(MemoryStack stack) {
        return XXH32State.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH32State callocStack(MemoryStack stack) {
        return XXH32State.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH32State.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH32State.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH32State.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH32State.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntotal_len_32(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TOTAL_LEN_32));
    }

    public static int nlarge_len(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LARGE_LEN));
    }

    public static int nv1(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)V1));
    }

    public static int nv2(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)V2));
    }

    public static int nv3(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)V3));
    }

    public static int nv4(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)V4));
    }

    public static IntBuffer nmem32(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)MEM32), (int)4);
    }

    public static int nmem32(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)4);
        }
        return MemoryUtil.memGetInt((long)(struct + (long)MEM32 + (long)(index * 4)));
    }

    public static int nmemsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MEMSIZE));
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED));
    }

    public static void ntotal_len_32(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TOTAL_LEN_32), (int)value);
    }

    public static void nlarge_len(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LARGE_LEN), (int)value);
    }

    public static void nv1(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)V1), (int)value);
    }

    public static void nv2(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)V2), (int)value);
    }

    public static void nv3(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)V3), (int)value);
    }

    public static void nv4(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)V4), (int)value);
    }

    public static void nmem32(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)MEM32), (long)(value.remaining() * 4));
    }

    public static void nmem32(long struct, int index, int value) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)4);
        }
        MemoryUtil.memPutInt((long)(struct + (long)MEM32 + (long)(index * 4)), (int)value);
    }

    public static void nmemsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MEMSIZE), (int)value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED), (int)value);
    }

    static {
        Struct.Layout layout = XXH32State.__struct((Struct.Member[])new Struct.Member[]{XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__member((int)4), XXH32State.__array((int)4, (int)4), XXH32State.__member((int)4), XXH32State.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN_32 = layout.offsetof(0);
        LARGE_LEN = layout.offsetof(1);
        V1 = layout.offsetof(2);
        V2 = layout.offsetof(3);
        V3 = layout.offsetof(4);
        V4 = layout.offsetof(5);
        MEM32 = layout.offsetof(6);
        MEMSIZE = layout.offsetof(7);
        RESERVED = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<XXH32State, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected XXH32State newInstance(long address) {
            return new XXH32State(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned")
        public int total_len_32() {
            return XXH32State.ntotal_len_32(this.address());
        }

        @NativeType(value="unsigned")
        public int large_len() {
            return XXH32State.nlarge_len(this.address());
        }

        @NativeType(value="unsigned")
        public int v1() {
            return XXH32State.nv1(this.address());
        }

        @NativeType(value="unsigned")
        public int v2() {
            return XXH32State.nv2(this.address());
        }

        @NativeType(value="unsigned")
        public int v3() {
            return XXH32State.nv3(this.address());
        }

        @NativeType(value="unsigned")
        public int v4() {
            return XXH32State.nv4(this.address());
        }

        @NativeType(value="unsigned[4]")
        public IntBuffer mem32() {
            return XXH32State.nmem32(this.address());
        }

        @NativeType(value="unsigned")
        public int mem32(int index) {
            return XXH32State.nmem32(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int memsize() {
            return XXH32State.nmemsize(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved() {
            return XXH32State.nreserved(this.address());
        }

        public Buffer total_len_32(@NativeType(value="unsigned") int value) {
            XXH32State.ntotal_len_32(this.address(), value);
            return this;
        }

        public Buffer large_len(@NativeType(value="unsigned") int value) {
            XXH32State.nlarge_len(this.address(), value);
            return this;
        }

        public Buffer v1(@NativeType(value="unsigned") int value) {
            XXH32State.nv1(this.address(), value);
            return this;
        }

        public Buffer v2(@NativeType(value="unsigned") int value) {
            XXH32State.nv2(this.address(), value);
            return this;
        }

        public Buffer v3(@NativeType(value="unsigned") int value) {
            XXH32State.nv3(this.address(), value);
            return this;
        }

        public Buffer v4(@NativeType(value="unsigned") int value) {
            XXH32State.nv4(this.address(), value);
            return this;
        }

        public Buffer mem32(@NativeType(value="unsigned[4]") IntBuffer value) {
            XXH32State.nmem32(this.address(), value);
            return this;
        }

        public Buffer mem32(int index, @NativeType(value="unsigned") int value) {
            XXH32State.nmem32(this.address(), index, value);
            return this;
        }

        public Buffer memsize(@NativeType(value="unsigned") int value) {
            XXH32State.nmemsize(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned") int value) {
            XXH32State.nreserved(this.address(), value);
            return this;
        }
    }
}

