/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH32_canonical_t")
public class XXH32Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    XXH32Canonical(long address, ByteBuffer container) {
        super(address, container);
    }

    public XXH32Canonical(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), XXH32Canonical.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[4]")
    public ByteBuffer digest() {
        return XXH32Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH32Canonical.ndigest(this.address(), index);
    }

    public static XXH32Canonical malloc() {
        return XXH32Canonical.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static XXH32Canonical calloc() {
        return XXH32Canonical.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static XXH32Canonical create() {
        return new XXH32Canonical(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static XXH32Canonical create(long address) {
        return address == 0L ? null : new XXH32Canonical(address, null);
    }

    public static Buffer malloc(int capacity) {
        return XXH32Canonical.create(XXH32Canonical.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH32Canonical.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(XXH32Canonical.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static XXH32Canonical mallocStack() {
        return XXH32Canonical.mallocStack(MemoryStack.stackGet());
    }

    public static XXH32Canonical callocStack() {
        return XXH32Canonical.callocStack(MemoryStack.stackGet());
    }

    public static XXH32Canonical mallocStack(MemoryStack stack) {
        return XXH32Canonical.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH32Canonical callocStack(MemoryStack stack) {
        return XXH32Canonical.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH32Canonical.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH32Canonical.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH32Canonical.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DIGEST), (int)4);
    }

    public static byte ndigest(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)4);
        }
        return MemoryUtil.memGetByte((long)(struct + (long)DIGEST + (long)(index * 1)));
    }

    static {
        Struct.Layout layout = XXH32Canonical.__struct((Struct.Member[])new Struct.Member[]{XXH32Canonical.__array((int)1, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH32Canonical, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected XXH32Canonical newInstance(long address) {
            return new XXH32Canonical(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned char[4]")
        public ByteBuffer digest() {
            return XXH32Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH32Canonical.ndigest(this.address(), index);
        }
    }
}

