/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoDecodeAV1ReferenceInfoFlags;

public class StdVideoDecodeAV1ReferenceInfo
extends Struct<StdVideoDecodeAV1ReferenceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FRAME_TYPE;
    public static final int REFFRAMESIGNBIAS;
    public static final int ORDERHINT;
    public static final int SAVEDORDERHINTS;

    protected StdVideoDecodeAV1ReferenceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoDecodeAV1ReferenceInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoDecodeAV1ReferenceInfo(address, container);
    }

    public StdVideoDecodeAV1ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoDecodeAV1ReferenceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoDecodeAV1ReferenceInfoFlags flags() {
        return StdVideoDecodeAV1ReferenceInfo.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte frame_type() {
        return StdVideoDecodeAV1ReferenceInfo.nframe_type(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefFrameSignBias() {
        return StdVideoDecodeAV1ReferenceInfo.nRefFrameSignBias(this.address());
    }

    @NativeType(value="uint8_t")
    public byte OrderHint() {
        return StdVideoDecodeAV1ReferenceInfo.nOrderHint(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
    public ByteBuffer SavedOrderHints() {
        return StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address());
    }

    @NativeType(value="uint8_t")
    public byte SavedOrderHints(int index) {
        return StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address(), index);
    }

    public StdVideoDecodeAV1ReferenceInfo flags(StdVideoDecodeAV1ReferenceInfoFlags value) {
        StdVideoDecodeAV1ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo flags(Consumer<StdVideoDecodeAV1ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo frame_type(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1ReferenceInfo.nframe_type(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo RefFrameSignBias(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1ReferenceInfo.nRefFrameSignBias(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo OrderHint(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1ReferenceInfo.nOrderHint(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo SavedOrderHints(@NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") ByteBuffer value) {
        StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo SavedOrderHints(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo set(StdVideoDecodeAV1ReferenceInfoFlags flags, byte frame_type, byte RefFrameSignBias, byte OrderHint, ByteBuffer SavedOrderHints) {
        this.flags(flags);
        this.frame_type(frame_type);
        this.RefFrameSignBias(RefFrameSignBias);
        this.OrderHint(OrderHint);
        this.SavedOrderHints(SavedOrderHints);
        return this;
    }

    public StdVideoDecodeAV1ReferenceInfo set(StdVideoDecodeAV1ReferenceInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoDecodeAV1ReferenceInfo malloc() {
        return new StdVideoDecodeAV1ReferenceInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoDecodeAV1ReferenceInfo calloc() {
        return new StdVideoDecodeAV1ReferenceInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoDecodeAV1ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoDecodeAV1ReferenceInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoDecodeAV1ReferenceInfo create(long address) {
        return new StdVideoDecodeAV1ReferenceInfo(address, null);
    }

    @Nullable
    public static StdVideoDecodeAV1ReferenceInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoDecodeAV1ReferenceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoDecodeAV1ReferenceInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeAV1ReferenceInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoDecodeAV1ReferenceInfo malloc(MemoryStack stack) {
        return new StdVideoDecodeAV1ReferenceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoDecodeAV1ReferenceInfo calloc(MemoryStack stack) {
        return new StdVideoDecodeAV1ReferenceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoDecodeAV1ReferenceInfoFlags nflags(long struct) {
        return StdVideoDecodeAV1ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static byte nframe_type(long struct) {
        return UNSAFE.getByte(null, struct + (long)FRAME_TYPE);
    }

    public static byte nRefFrameSignBias(long struct) {
        return UNSAFE.getByte(null, struct + (long)REFFRAMESIGNBIAS);
    }

    public static byte nOrderHint(long struct) {
        return UNSAFE.getByte(null, struct + (long)ORDERHINT);
    }

    public static ByteBuffer nSavedOrderHints(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)SAVEDORDERHINTS), (int)8);
    }

    public static byte nSavedOrderHints(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SAVEDORDERHINTS + Checks.check((int)index, (int)8) * 1L);
    }

    public static void nflags(long struct, StdVideoDecodeAV1ReferenceInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoDecodeAV1ReferenceInfoFlags.SIZEOF);
    }

    public static void nframe_type(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)FRAME_TYPE, value);
    }

    public static void nRefFrameSignBias(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)REFFRAMESIGNBIAS, value);
    }

    public static void nOrderHint(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)ORDERHINT, value);
    }

    public static void nSavedOrderHints(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)SAVEDORDERHINTS), (long)(value.remaining() * 1));
    }

    public static void nSavedOrderHints(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SAVEDORDERHINTS + Checks.check((int)index, (int)8) * 1L, value);
    }

    static {
        Struct.Layout layout = StdVideoDecodeAV1ReferenceInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoDecodeAV1ReferenceInfo.__member((int)StdVideoDecodeAV1ReferenceInfoFlags.SIZEOF, (int)StdVideoDecodeAV1ReferenceInfoFlags.ALIGNOF), StdVideoDecodeAV1ReferenceInfo.__member((int)1), StdVideoDecodeAV1ReferenceInfo.__member((int)1), StdVideoDecodeAV1ReferenceInfo.__member((int)1), StdVideoDecodeAV1ReferenceInfo.__array((int)1, (int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FRAME_TYPE = layout.offsetof(1);
        REFFRAMESIGNBIAS = layout.offsetof(2);
        ORDERHINT = layout.offsetof(3);
        SAVEDORDERHINTS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeAV1ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeAV1ReferenceInfo ELEMENT_FACTORY = StdVideoDecodeAV1ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected StdVideoDecodeAV1ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoDecodeAV1ReferenceInfoFlags flags() {
            return StdVideoDecodeAV1ReferenceInfo.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte frame_type() {
            return StdVideoDecodeAV1ReferenceInfo.nframe_type(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefFrameSignBias() {
            return StdVideoDecodeAV1ReferenceInfo.nRefFrameSignBias(this.address());
        }

        @NativeType(value="uint8_t")
        public byte OrderHint() {
            return StdVideoDecodeAV1ReferenceInfo.nOrderHint(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
        public ByteBuffer SavedOrderHints() {
            return StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address());
        }

        @NativeType(value="uint8_t")
        public byte SavedOrderHints(int index) {
            return StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address(), index);
        }

        public Buffer flags(StdVideoDecodeAV1ReferenceInfoFlags value) {
            StdVideoDecodeAV1ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeAV1ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer frame_type(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1ReferenceInfo.nframe_type(this.address(), value);
            return this;
        }

        public Buffer RefFrameSignBias(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1ReferenceInfo.nRefFrameSignBias(this.address(), value);
            return this;
        }

        public Buffer OrderHint(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1ReferenceInfo.nOrderHint(this.address(), value);
            return this;
        }

        public Buffer SavedOrderHints(@NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") ByteBuffer value) {
            StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address(), value);
            return this;
        }

        public Buffer SavedOrderHints(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1ReferenceInfo.nSavedOrderHints(this.address(), index, value);
            return this;
        }
    }
}

