/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineColorBlendAdvancedStateCreateInfoEXT;
import org.lwjgl.vulkan.VkPipelineColorBlendAttachmentState;
import org.lwjgl.vulkan.VkPipelineColorWriteCreateInfoEXT;

public class VkPipelineColorBlendStateCreateInfo
extends Struct<VkPipelineColorBlendStateCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int LOGICOPENABLE;
    public static final int LOGICOP;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int BLENDCONSTANTS;

    protected VkPipelineColorBlendStateCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPipelineColorBlendStateCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineColorBlendStateCreateInfo(address, container);
    }

    public VkPipelineColorBlendStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPipelineColorBlendStateCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineColorBlendStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineColorBlendStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineColorBlendStateCreateFlags")
    public int flags() {
        return VkPipelineColorBlendStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean logicOpEnable() {
        return VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address()) != 0;
    }

    @NativeType(value="VkLogicOp")
    public int logicOp() {
        return VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkPipelineColorBlendStateCreateInfo.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPipelineColorBlendAttachmentState const *")
    public VkPipelineColorBlendAttachmentState.Buffer pAttachments() {
        return VkPipelineColorBlendStateCreateInfo.npAttachments(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer blendConstants() {
        return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address());
    }

    public float blendConstants(int index) {
        return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index);
    }

    public VkPipelineColorBlendStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineColorBlendStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo sType$Default() {
        return this.sType(26);
    }

    public VkPipelineColorBlendStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineColorBlendStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo pNext(VkPipelineColorBlendAdvancedStateCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineColorBlendStateCreateInfo pNext(VkPipelineColorWriteCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPipelineColorBlendStateCreateInfo flags(@NativeType(value="VkPipelineColorBlendStateCreateFlags") int value) {
        VkPipelineColorBlendStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo logicOpEnable(@NativeType(value="VkBool32") boolean value) {
        VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo logicOp(@NativeType(value="VkLogicOp") int value) {
        VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo attachmentCount(@NativeType(value="uint32_t") int value) {
        VkPipelineColorBlendStateCreateInfo.nattachmentCount(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo pAttachments(@Nullable @NativeType(value="VkPipelineColorBlendAttachmentState const *") VkPipelineColorBlendAttachmentState.Buffer value) {
        VkPipelineColorBlendStateCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo blendConstants(@NativeType(value="float[4]") FloatBuffer value) {
        VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo blendConstants(int index, float value) {
        VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index, value);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo set(int sType, long pNext, int flags, boolean logicOpEnable, int logicOp, int attachmentCount, @Nullable VkPipelineColorBlendAttachmentState.Buffer pAttachments, FloatBuffer blendConstants) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.logicOpEnable(logicOpEnable);
        this.logicOp(logicOp);
        this.attachmentCount(attachmentCount);
        this.pAttachments(pAttachments);
        this.blendConstants(blendConstants);
        return this;
    }

    public VkPipelineColorBlendStateCreateInfo set(VkPipelineColorBlendStateCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPipelineColorBlendStateCreateInfo malloc() {
        return new VkPipelineColorBlendStateCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPipelineColorBlendStateCreateInfo calloc() {
        return new VkPipelineColorBlendStateCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPipelineColorBlendStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPipelineColorBlendStateCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPipelineColorBlendStateCreateInfo create(long address) {
        return new VkPipelineColorBlendStateCreateInfo(address, null);
    }

    @Nullable
    public static VkPipelineColorBlendStateCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPipelineColorBlendStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPipelineColorBlendStateCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineColorBlendStateCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineColorBlendStateCreateInfo mallocStack() {
        return VkPipelineColorBlendStateCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineColorBlendStateCreateInfo callocStack() {
        return VkPipelineColorBlendStateCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineColorBlendStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkPipelineColorBlendStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineColorBlendStateCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineColorBlendStateCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineColorBlendStateCreateInfo.calloc(capacity, stack);
    }

    public static VkPipelineColorBlendStateCreateInfo malloc(MemoryStack stack) {
        return new VkPipelineColorBlendStateCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineColorBlendStateCreateInfo calloc(MemoryStack stack) {
        return new VkPipelineColorBlendStateCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nlogicOpEnable(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOGICOPENABLE);
    }

    public static int nlogicOp(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOGICOP);
    }

    public static int nattachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static VkPipelineColorBlendAttachmentState.Buffer npAttachments(long struct) {
        return VkPipelineColorBlendAttachmentState.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)), VkPipelineColorBlendStateCreateInfo.nattachmentCount(struct));
    }

    public static FloatBuffer nblendConstants(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)BLENDCONSTANTS), (int)4);
    }

    public static float nblendConstants(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)BLENDCONSTANTS + Checks.check((int)index, (int)4) * 4L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nlogicOpEnable(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOGICOPENABLE, value);
    }

    public static void nlogicOp(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOGICOP, value);
    }

    public static void nattachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable VkPipelineColorBlendAttachmentState.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkPipelineColorBlendStateCreateInfo.nattachmentCount(struct, value.remaining());
        }
    }

    public static void nblendConstants(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)BLENDCONSTANTS), (long)(value.remaining() * 4));
    }

    public static void nblendConstants(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)BLENDCONSTANTS + Checks.check((int)index, (int)4) * 4L, value);
    }

    static {
        Struct.Layout layout = VkPipelineColorBlendStateCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkPipelineColorBlendStateCreateInfo.__member((int)4), VkPipelineColorBlendStateCreateInfo.__member((int)POINTER_SIZE), VkPipelineColorBlendStateCreateInfo.__member((int)4), VkPipelineColorBlendStateCreateInfo.__member((int)4), VkPipelineColorBlendStateCreateInfo.__member((int)4), VkPipelineColorBlendStateCreateInfo.__member((int)4), VkPipelineColorBlendStateCreateInfo.__member((int)POINTER_SIZE), VkPipelineColorBlendStateCreateInfo.__array((int)4, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        LOGICOPENABLE = layout.offsetof(3);
        LOGICOP = layout.offsetof(4);
        ATTACHMENTCOUNT = layout.offsetof(5);
        PATTACHMENTS = layout.offsetof(6);
        BLENDCONSTANTS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineColorBlendStateCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineColorBlendStateCreateInfo ELEMENT_FACTORY = VkPipelineColorBlendStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPipelineColorBlendStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineColorBlendStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineColorBlendStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineColorBlendStateCreateFlags")
        public int flags() {
            return VkPipelineColorBlendStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean logicOpEnable() {
            return VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address()) != 0;
        }

        @NativeType(value="VkLogicOp")
        public int logicOp() {
            return VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkPipelineColorBlendStateCreateInfo.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPipelineColorBlendAttachmentState const *")
        public VkPipelineColorBlendAttachmentState.Buffer pAttachments() {
            return VkPipelineColorBlendStateCreateInfo.npAttachments(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer blendConstants() {
            return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address());
        }

        public float blendConstants(int index) {
            return VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineColorBlendStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(26);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineColorBlendStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineColorBlendAdvancedStateCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkPipelineColorWriteCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkPipelineColorBlendStateCreateFlags") int value) {
            VkPipelineColorBlendStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer logicOpEnable(@NativeType(value="VkBool32") boolean value) {
            VkPipelineColorBlendStateCreateInfo.nlogicOpEnable(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer logicOp(@NativeType(value="VkLogicOp") int value) {
            VkPipelineColorBlendStateCreateInfo.nlogicOp(this.address(), value);
            return this;
        }

        public Buffer attachmentCount(@NativeType(value="uint32_t") int value) {
            VkPipelineColorBlendStateCreateInfo.nattachmentCount(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkPipelineColorBlendAttachmentState const *") VkPipelineColorBlendAttachmentState.Buffer value) {
            VkPipelineColorBlendStateCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer blendConstants(@NativeType(value="float[4]") FloatBuffer value) {
            VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), value);
            return this;
        }

        public Buffer blendConstants(int index, float value) {
            VkPipelineColorBlendStateCreateInfo.nblendConstants(this.address(), index, value);
            return this;
        }
    }
}

