/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPhysicalDeviceVariablePointersFeatures;

public class VkPhysicalDeviceVariablePointerFeatures
extends VkPhysicalDeviceVariablePointersFeatures {
    protected VkPhysicalDeviceVariablePointerFeatures(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceVariablePointerFeatures create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceVariablePointerFeatures(address, container);
    }

    public VkPhysicalDeviceVariablePointerFeatures(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceVariablePointerFeatures.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures sType$Default() {
        return this.sType(1000120000);
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceVariablePointerFeatures.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures variablePointersStorageBuffer(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVariablePointerFeatures.nvariablePointersStorageBuffer(this.address(), value ? 1 : 0);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures variablePointers(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVariablePointerFeatures.nvariablePointers(this.address(), value ? 1 : 0);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures set(int sType, long pNext, boolean variablePointersStorageBuffer, boolean variablePointers) {
        this.sType(sType);
        this.pNext(pNext);
        this.variablePointersStorageBuffer(variablePointersStorageBuffer);
        this.variablePointers(variablePointers);
        return this;
    }

    public VkPhysicalDeviceVariablePointerFeatures set(VkPhysicalDeviceVariablePointerFeatures src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceVariablePointerFeatures malloc() {
        return new VkPhysicalDeviceVariablePointerFeatures(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPhysicalDeviceVariablePointerFeatures calloc() {
        return new VkPhysicalDeviceVariablePointerFeatures(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPhysicalDeviceVariablePointerFeatures create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPhysicalDeviceVariablePointerFeatures(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPhysicalDeviceVariablePointerFeatures create(long address) {
        return new VkPhysicalDeviceVariablePointerFeatures(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceVariablePointerFeatures createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceVariablePointerFeatures(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceVariablePointerFeatures.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceVariablePointerFeatures.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures mallocStack() {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures callocStack() {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceVariablePointerFeatures callocStack(MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceVariablePointerFeatures.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceVariablePointerFeatures malloc(MemoryStack stack) {
        return new VkPhysicalDeviceVariablePointerFeatures(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceVariablePointerFeatures calloc(MemoryStack stack) {
        return new VkPhysicalDeviceVariablePointerFeatures(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPhysicalDeviceVariablePointersFeatures.Buffer {
        private static final VkPhysicalDeviceVariablePointerFeatures ELEMENT_FACTORY = VkPhysicalDeviceVariablePointerFeatures.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceVariablePointerFeatures getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceVariablePointerFeatures.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000120000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceVariablePointerFeatures.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer variablePointersStorageBuffer(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVariablePointerFeatures.nvariablePointersStorageBuffer(this.address(), value ? 1 : 0);
            return this;
        }

        @Override
        public Buffer variablePointers(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVariablePointerFeatures.nvariablePointers(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

