/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryHeap;
import org.lwjgl.vulkan.VkMemoryType;

public class VkPhysicalDeviceMemoryProperties
extends Struct<VkPhysicalDeviceMemoryProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORYTYPECOUNT;
    public static final int MEMORYTYPES;
    public static final int MEMORYHEAPCOUNT;
    public static final int MEMORYHEAPS;

    protected VkPhysicalDeviceMemoryProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkPhysicalDeviceMemoryProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceMemoryProperties(address, container);
    }

    public VkPhysicalDeviceMemoryProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceMemoryProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int memoryTypeCount() {
        return VkPhysicalDeviceMemoryProperties.nmemoryTypeCount(this.address());
    }

    @NativeType(value="VkMemoryType[VK_MAX_MEMORY_TYPES]")
    public VkMemoryType.Buffer memoryTypes() {
        return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address());
    }

    public VkMemoryType memoryTypes(int index) {
        return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address(), index);
    }

    @NativeType(value="uint32_t")
    public int memoryHeapCount() {
        return VkPhysicalDeviceMemoryProperties.nmemoryHeapCount(this.address());
    }

    @NativeType(value="VkMemoryHeap[VK_MAX_MEMORY_HEAPS]")
    public VkMemoryHeap.Buffer memoryHeaps() {
        return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address());
    }

    public VkMemoryHeap memoryHeaps(int index) {
        return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address(), index);
    }

    public static VkPhysicalDeviceMemoryProperties malloc() {
        return new VkPhysicalDeviceMemoryProperties(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryProperties calloc() {
        return new VkPhysicalDeviceMemoryProperties(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkPhysicalDeviceMemoryProperties(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkPhysicalDeviceMemoryProperties create(long address) {
        return new VkPhysicalDeviceMemoryProperties(address, null);
    }

    @Nullable
    public static VkPhysicalDeviceMemoryProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceMemoryProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceMemoryProperties.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceMemoryProperties.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties mallocStack() {
        return VkPhysicalDeviceMemoryProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties callocStack() {
        return VkPhysicalDeviceMemoryProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryProperties.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceMemoryProperties malloc(MemoryStack stack) {
        return new VkPhysicalDeviceMemoryProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceMemoryProperties calloc(MemoryStack stack) {
        return new VkPhysicalDeviceMemoryProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmemoryTypeCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYTYPECOUNT);
    }

    public static VkMemoryType.Buffer nmemoryTypes(long struct) {
        return VkMemoryType.create(struct + (long)MEMORYTYPES, VkPhysicalDeviceMemoryProperties.nmemoryTypeCount(struct));
    }

    public static VkMemoryType nmemoryTypes(long struct, int index) {
        return VkMemoryType.create(struct + (long)MEMORYTYPES + Checks.check((int)index, (int)VkPhysicalDeviceMemoryProperties.nmemoryTypeCount(struct)) * (long)VkMemoryType.SIZEOF);
    }

    public static int nmemoryHeapCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYHEAPCOUNT);
    }

    public static VkMemoryHeap.Buffer nmemoryHeaps(long struct) {
        return VkMemoryHeap.create(struct + (long)MEMORYHEAPS, VkPhysicalDeviceMemoryProperties.nmemoryHeapCount(struct));
    }

    public static VkMemoryHeap nmemoryHeaps(long struct, int index) {
        return VkMemoryHeap.create(struct + (long)MEMORYHEAPS + Checks.check((int)index, (int)VkPhysicalDeviceMemoryProperties.nmemoryHeapCount(struct)) * (long)VkMemoryHeap.SIZEOF);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceMemoryProperties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceMemoryProperties.__member((int)4), VkPhysicalDeviceMemoryProperties.__array((int)VkMemoryType.SIZEOF, (int)VkMemoryType.ALIGNOF, (int)32), VkPhysicalDeviceMemoryProperties.__member((int)4), VkPhysicalDeviceMemoryProperties.__array((int)VkMemoryHeap.SIZEOF, (int)VkMemoryHeap.ALIGNOF, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORYTYPECOUNT = layout.offsetof(0);
        MEMORYTYPES = layout.offsetof(1);
        MEMORYHEAPCOUNT = layout.offsetof(2);
        MEMORYHEAPS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceMemoryProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceMemoryProperties ELEMENT_FACTORY = VkPhysicalDeviceMemoryProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceMemoryProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int memoryTypeCount() {
            return VkPhysicalDeviceMemoryProperties.nmemoryTypeCount(this.address());
        }

        @NativeType(value="VkMemoryType[VK_MAX_MEMORY_TYPES]")
        public VkMemoryType.Buffer memoryTypes() {
            return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address());
        }

        public VkMemoryType memoryTypes(int index) {
            return VkPhysicalDeviceMemoryProperties.nmemoryTypes(this.address(), index);
        }

        @NativeType(value="uint32_t")
        public int memoryHeapCount() {
            return VkPhysicalDeviceMemoryProperties.nmemoryHeapCount(this.address());
        }

        @NativeType(value="VkMemoryHeap[VK_MAX_MEMORY_HEAPS]")
        public VkMemoryHeap.Buffer memoryHeaps() {
            return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address());
        }

        public VkMemoryHeap memoryHeaps(int index) {
            return VkPhysicalDeviceMemoryProperties.nmemoryHeaps(this.address(), index);
        }
    }
}

