/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryDedicatedAllocateInfo;

public class VkMemoryDedicatedAllocateInfoKHR
extends VkMemoryDedicatedAllocateInfo {
    protected VkMemoryDedicatedAllocateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryDedicatedAllocateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryDedicatedAllocateInfoKHR(address, container);
    }

    public VkMemoryDedicatedAllocateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedAllocateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR sType$Default() {
        return this.sType(1000127001);
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryDedicatedAllocateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR image(@NativeType(value="VkImage") long value) {
        VkMemoryDedicatedAllocateInfoKHR.nimage(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR buffer(@NativeType(value="VkBuffer") long value) {
        VkMemoryDedicatedAllocateInfoKHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryDedicatedAllocateInfoKHR set(int sType, long pNext, long image, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.buffer(buffer);
        return this;
    }

    public VkMemoryDedicatedAllocateInfoKHR set(VkMemoryDedicatedAllocateInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedAllocateInfoKHR malloc() {
        return new VkMemoryDedicatedAllocateInfoKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryDedicatedAllocateInfoKHR calloc() {
        return new VkMemoryDedicatedAllocateInfoKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryDedicatedAllocateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryDedicatedAllocateInfoKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryDedicatedAllocateInfoKHR create(long address) {
        return new VkMemoryDedicatedAllocateInfoKHR(address, null);
    }

    @Nullable
    public static VkMemoryDedicatedAllocateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryDedicatedAllocateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryDedicatedAllocateInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryDedicatedAllocateInfoKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR mallocStack() {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR callocStack() {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR mallocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkMemoryDedicatedAllocateInfoKHR callocStack(MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedAllocateInfoKHR.calloc(capacity, stack);
    }

    public static VkMemoryDedicatedAllocateInfoKHR malloc(MemoryStack stack) {
        return new VkMemoryDedicatedAllocateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryDedicatedAllocateInfoKHR calloc(MemoryStack stack) {
        return new VkMemoryDedicatedAllocateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryDedicatedAllocateInfo.Buffer {
        private static final VkMemoryDedicatedAllocateInfoKHR ELEMENT_FACTORY = VkMemoryDedicatedAllocateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryDedicatedAllocateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedAllocateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000127001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryDedicatedAllocateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer image(@NativeType(value="VkImage") long value) {
            VkMemoryDedicatedAllocateInfoKHR.nimage(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkMemoryDedicatedAllocateInfoKHR.nbuffer(this.address(), value);
            return this;
        }
    }
}

