/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkFramebufferAttachmentImageInfo;

public class VkFramebufferAttachmentsCreateInfo
extends Struct<VkFramebufferAttachmentsCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ATTACHMENTIMAGEINFOCOUNT;
    public static final int PATTACHMENTIMAGEINFOS;

    protected VkFramebufferAttachmentsCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkFramebufferAttachmentsCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkFramebufferAttachmentsCreateInfo(address, container);
    }

    public VkFramebufferAttachmentsCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkFramebufferAttachmentsCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFramebufferAttachmentsCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFramebufferAttachmentsCreateInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentImageInfoCount() {
        return VkFramebufferAttachmentsCreateInfo.nattachmentImageInfoCount(this.address());
    }

    @Nullable
    @NativeType(value="VkFramebufferAttachmentImageInfo const *")
    public VkFramebufferAttachmentImageInfo.Buffer pAttachmentImageInfos() {
        return VkFramebufferAttachmentsCreateInfo.npAttachmentImageInfos(this.address());
    }

    public VkFramebufferAttachmentsCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkFramebufferAttachmentsCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentsCreateInfo sType$Default() {
        return this.sType(1000108001);
    }

    public VkFramebufferAttachmentsCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkFramebufferAttachmentsCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentsCreateInfo pAttachmentImageInfos(@Nullable @NativeType(value="VkFramebufferAttachmentImageInfo const *") VkFramebufferAttachmentImageInfo.Buffer value) {
        VkFramebufferAttachmentsCreateInfo.npAttachmentImageInfos(this.address(), value);
        return this;
    }

    public VkFramebufferAttachmentsCreateInfo set(int sType, long pNext, @Nullable VkFramebufferAttachmentImageInfo.Buffer pAttachmentImageInfos) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAttachmentImageInfos(pAttachmentImageInfos);
        return this;
    }

    public VkFramebufferAttachmentsCreateInfo set(VkFramebufferAttachmentsCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkFramebufferAttachmentsCreateInfo malloc() {
        return new VkFramebufferAttachmentsCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkFramebufferAttachmentsCreateInfo calloc() {
        return new VkFramebufferAttachmentsCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkFramebufferAttachmentsCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkFramebufferAttachmentsCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkFramebufferAttachmentsCreateInfo create(long address) {
        return new VkFramebufferAttachmentsCreateInfo(address, null);
    }

    @Nullable
    public static VkFramebufferAttachmentsCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkFramebufferAttachmentsCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkFramebufferAttachmentsCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFramebufferAttachmentsCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkFramebufferAttachmentsCreateInfo malloc(MemoryStack stack) {
        return new VkFramebufferAttachmentsCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkFramebufferAttachmentsCreateInfo calloc(MemoryStack stack) {
        return new VkFramebufferAttachmentsCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nattachmentImageInfoCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTIMAGEINFOCOUNT);
    }

    @Nullable
    public static VkFramebufferAttachmentImageInfo.Buffer npAttachmentImageInfos(long struct) {
        return VkFramebufferAttachmentImageInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTIMAGEINFOS)), VkFramebufferAttachmentsCreateInfo.nattachmentImageInfoCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nattachmentImageInfoCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTIMAGEINFOCOUNT, value);
    }

    public static void npAttachmentImageInfos(long struct, @Nullable VkFramebufferAttachmentImageInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTIMAGEINFOS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkFramebufferAttachmentsCreateInfo.nattachmentImageInfoCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int attachmentImageInfoCount = VkFramebufferAttachmentsCreateInfo.nattachmentImageInfoCount(struct);
        if (attachmentImageInfoCount != 0) {
            long pAttachmentImageInfos = MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTIMAGEINFOS));
            Checks.check((long)pAttachmentImageInfos);
            VkFramebufferAttachmentsCreateInfo.validate((long)pAttachmentImageInfos, (int)attachmentImageInfoCount, (int)VkFramebufferAttachmentImageInfo.SIZEOF, VkFramebufferAttachmentImageInfo::validate);
        }
    }

    static {
        Struct.Layout layout = VkFramebufferAttachmentsCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkFramebufferAttachmentsCreateInfo.__member((int)4), VkFramebufferAttachmentsCreateInfo.__member((int)POINTER_SIZE), VkFramebufferAttachmentsCreateInfo.__member((int)4), VkFramebufferAttachmentsCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ATTACHMENTIMAGEINFOCOUNT = layout.offsetof(2);
        PATTACHMENTIMAGEINFOS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkFramebufferAttachmentsCreateInfo, Buffer>
    implements NativeResource {
        private static final VkFramebufferAttachmentsCreateInfo ELEMENT_FACTORY = VkFramebufferAttachmentsCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkFramebufferAttachmentsCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFramebufferAttachmentsCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFramebufferAttachmentsCreateInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentImageInfoCount() {
            return VkFramebufferAttachmentsCreateInfo.nattachmentImageInfoCount(this.address());
        }

        @Nullable
        @NativeType(value="VkFramebufferAttachmentImageInfo const *")
        public VkFramebufferAttachmentImageInfo.Buffer pAttachmentImageInfos() {
            return VkFramebufferAttachmentsCreateInfo.npAttachmentImageInfos(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFramebufferAttachmentsCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000108001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFramebufferAttachmentsCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pAttachmentImageInfos(@Nullable @NativeType(value="VkFramebufferAttachmentImageInfo const *") VkFramebufferAttachmentImageInfo.Buffer value) {
            VkFramebufferAttachmentsCreateInfo.npAttachmentImageInfos(this.address(), value);
            return this;
        }
    }
}

