/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryProperties
extends Struct<VkExternalMemoryProperties> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTERNALMEMORYFEATURES;
    public static final int EXPORTFROMIMPORTEDHANDLETYPES;
    public static final int COMPATIBLEHANDLETYPES;

    protected VkExternalMemoryProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkExternalMemoryProperties create(long address, @Nullable ByteBuffer container) {
        return new VkExternalMemoryProperties(address, container);
    }

    public VkExternalMemoryProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExternalMemoryProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkExternalMemoryFeatureFlags")
    public int externalMemoryFeatures() {
        return VkExternalMemoryProperties.nexternalMemoryFeatures(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int exportFromImportedHandleTypes() {
        return VkExternalMemoryProperties.nexportFromImportedHandleTypes(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int compatibleHandleTypes() {
        return VkExternalMemoryProperties.ncompatibleHandleTypes(this.address());
    }

    public static VkExternalMemoryProperties create(long address) {
        return new VkExternalMemoryProperties(address, null);
    }

    @Nullable
    public static VkExternalMemoryProperties createSafe(long address) {
        return address == 0L ? null : new VkExternalMemoryProperties(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nexternalMemoryFeatures(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXTERNALMEMORYFEATURES);
    }

    public static int nexportFromImportedHandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXPORTFROMIMPORTEDHANDLETYPES);
    }

    public static int ncompatibleHandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPATIBLEHANDLETYPES);
    }

    static {
        Struct.Layout layout = VkExternalMemoryProperties.__struct((Struct.Member[])new Struct.Member[]{VkExternalMemoryProperties.__member((int)4), VkExternalMemoryProperties.__member((int)4), VkExternalMemoryProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTERNALMEMORYFEATURES = layout.offsetof(0);
        EXPORTFROMIMPORTEDHANDLETYPES = layout.offsetof(1);
        COMPATIBLEHANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryProperties, Buffer> {
        private static final VkExternalMemoryProperties ELEMENT_FACTORY = VkExternalMemoryProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExternalMemoryProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkExternalMemoryFeatureFlags")
        public int externalMemoryFeatures() {
            return VkExternalMemoryProperties.nexternalMemoryFeatures(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int exportFromImportedHandleTypes() {
            return VkExternalMemoryProperties.nexportFromImportedHandleTypes(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int compatibleHandleTypes() {
            return VkExternalMemoryProperties.ncompatibleHandleTypes(this.address());
        }
    }
}

