/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBinding;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBindingFlagsCreateInfo;
import org.lwjgl.vulkan.VkDescriptorSetLayoutBindingFlagsCreateInfoEXT;
import org.lwjgl.vulkan.VkMutableDescriptorTypeCreateInfoEXT;
import org.lwjgl.vulkan.VkMutableDescriptorTypeCreateInfoVALVE;

public class VkDescriptorSetLayoutCreateInfo
extends Struct<VkDescriptorSetLayoutCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int BINDINGCOUNT;
    public static final int PBINDINGS;

    protected VkDescriptorSetLayoutCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDescriptorSetLayoutCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorSetLayoutCreateInfo(address, container);
    }

    public VkDescriptorSetLayoutCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorSetLayoutCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetLayoutCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDescriptorSetLayoutCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkDescriptorSetLayoutCreateFlags")
    public int flags() {
        return VkDescriptorSetLayoutCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindingCount() {
        return VkDescriptorSetLayoutCreateInfo.nbindingCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorSetLayoutBinding const *")
    public VkDescriptorSetLayoutBinding.Buffer pBindings() {
        return VkDescriptorSetLayoutCreateInfo.npBindings(this.address());
    }

    public VkDescriptorSetLayoutCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo sType$Default() {
        return this.sType(32);
    }

    public VkDescriptorSetLayoutCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkDescriptorSetLayoutCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo pNext(VkDescriptorSetLayoutBindingFlagsCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutCreateInfo pNext(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutCreateInfo pNext(VkMutableDescriptorTypeCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutCreateInfo pNext(VkMutableDescriptorTypeCreateInfoVALVE value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutCreateInfo flags(@NativeType(value="VkDescriptorSetLayoutCreateFlags") int value) {
        VkDescriptorSetLayoutCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo pBindings(@Nullable @NativeType(value="VkDescriptorSetLayoutBinding const *") VkDescriptorSetLayoutBinding.Buffer value) {
        VkDescriptorSetLayoutCreateInfo.npBindings(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo set(int sType, long pNext, int flags, @Nullable VkDescriptorSetLayoutBinding.Buffer pBindings) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pBindings(pBindings);
        return this;
    }

    public VkDescriptorSetLayoutCreateInfo set(VkDescriptorSetLayoutCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutCreateInfo malloc() {
        return new VkDescriptorSetLayoutCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDescriptorSetLayoutCreateInfo calloc() {
        return new VkDescriptorSetLayoutCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDescriptorSetLayoutCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDescriptorSetLayoutCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDescriptorSetLayoutCreateInfo create(long address) {
        return new VkDescriptorSetLayoutCreateInfo(address, null);
    }

    @Nullable
    public static VkDescriptorSetLayoutCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkDescriptorSetLayoutCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDescriptorSetLayoutCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorSetLayoutCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo mallocStack() {
        return VkDescriptorSetLayoutCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo callocStack() {
        return VkDescriptorSetLayoutCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorSetLayoutCreateInfo callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutCreateInfo.calloc(capacity, stack);
    }

    public static VkDescriptorSetLayoutCreateInfo malloc(MemoryStack stack) {
        return new VkDescriptorSetLayoutCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorSetLayoutCreateInfo calloc(MemoryStack stack) {
        return new VkDescriptorSetLayoutCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nbindingCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDINGCOUNT);
    }

    @Nullable
    public static VkDescriptorSetLayoutBinding.Buffer npBindings(long struct) {
        return VkDescriptorSetLayoutBinding.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PBINDINGS)), VkDescriptorSetLayoutCreateInfo.nbindingCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nbindingCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDINGCOUNT, value);
    }

    public static void npBindings(long struct, @Nullable VkDescriptorSetLayoutBinding.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBINDINGS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkDescriptorSetLayoutCreateInfo.nbindingCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkDescriptorSetLayoutCreateInfo.nbindingCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PBINDINGS)));
        }
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorSetLayoutCreateInfo.__member((int)4), VkDescriptorSetLayoutCreateInfo.__member((int)POINTER_SIZE), VkDescriptorSetLayoutCreateInfo.__member((int)4), VkDescriptorSetLayoutCreateInfo.__member((int)4), VkDescriptorSetLayoutCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        BINDINGCOUNT = layout.offsetof(3);
        PBINDINGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutCreateInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorSetLayoutCreateInfo ELEMENT_FACTORY = VkDescriptorSetLayoutCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorSetLayoutCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetLayoutCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDescriptorSetLayoutCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkDescriptorSetLayoutCreateFlags")
        public int flags() {
            return VkDescriptorSetLayoutCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindingCount() {
            return VkDescriptorSetLayoutCreateInfo.nbindingCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorSetLayoutBinding const *")
        public VkDescriptorSetLayoutBinding.Buffer pBindings() {
            return VkDescriptorSetLayoutCreateInfo.npBindings(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(32);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDescriptorSetLayoutCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDescriptorSetLayoutBindingFlagsCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDescriptorSetLayoutBindingFlagsCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMutableDescriptorTypeCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMutableDescriptorTypeCreateInfoVALVE value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkDescriptorSetLayoutCreateFlags") int value) {
            VkDescriptorSetLayoutCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pBindings(@Nullable @NativeType(value="VkDescriptorSetLayoutBinding const *") VkDescriptorSetLayoutBinding.Buffer value) {
            VkDescriptorSetLayoutCreateInfo.npBindings(this.address(), value);
            return this;
        }
    }
}

