/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorAddressInfoEXT
extends Struct<VkDescriptorAddressInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ADDRESS;
    public static final int RANGE;
    public static final int FORMAT;

    protected VkDescriptorAddressInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDescriptorAddressInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorAddressInfoEXT(address, container);
    }

    public VkDescriptorAddressInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorAddressInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorAddressInfoEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDescriptorAddressInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long address$() {
        return VkDescriptorAddressInfoEXT.naddress$(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long range() {
        return VkDescriptorAddressInfoEXT.nrange(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkDescriptorAddressInfoEXT.nformat(this.address());
    }

    public VkDescriptorAddressInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorAddressInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorAddressInfoEXT sType$Default() {
        return this.sType(1000316003);
    }

    public VkDescriptorAddressInfoEXT pNext(@NativeType(value="void *") long value) {
        VkDescriptorAddressInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorAddressInfoEXT address$(@NativeType(value="VkDeviceAddress") long value) {
        VkDescriptorAddressInfoEXT.naddress$(this.address(), value);
        return this;
    }

    public VkDescriptorAddressInfoEXT range(@NativeType(value="VkDeviceSize") long value) {
        VkDescriptorAddressInfoEXT.nrange(this.address(), value);
        return this;
    }

    public VkDescriptorAddressInfoEXT format(@NativeType(value="VkFormat") int value) {
        VkDescriptorAddressInfoEXT.nformat(this.address(), value);
        return this;
    }

    public VkDescriptorAddressInfoEXT set(int sType, long pNext, long address$, long range, int format) {
        this.sType(sType);
        this.pNext(pNext);
        this.address$(address$);
        this.range(range);
        this.format(format);
        return this;
    }

    public VkDescriptorAddressInfoEXT set(VkDescriptorAddressInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorAddressInfoEXT malloc() {
        return new VkDescriptorAddressInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDescriptorAddressInfoEXT calloc() {
        return new VkDescriptorAddressInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDescriptorAddressInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDescriptorAddressInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDescriptorAddressInfoEXT create(long address) {
        return new VkDescriptorAddressInfoEXT(address, null);
    }

    @Nullable
    public static VkDescriptorAddressInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkDescriptorAddressInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDescriptorAddressInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorAddressInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDescriptorAddressInfoEXT malloc(MemoryStack stack) {
        return new VkDescriptorAddressInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorAddressInfoEXT calloc(MemoryStack stack) {
        return new VkDescriptorAddressInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long naddress$(long struct) {
        return UNSAFE.getLong(null, struct + (long)ADDRESS);
    }

    public static long nrange(long struct) {
        return UNSAFE.getLong(null, struct + (long)RANGE);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void naddress$(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ADDRESS, value);
    }

    public static void nrange(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RANGE, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorAddressInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkDescriptorAddressInfoEXT.__member((int)4), VkDescriptorAddressInfoEXT.__member((int)POINTER_SIZE), VkDescriptorAddressInfoEXT.__member((int)8), VkDescriptorAddressInfoEXT.__member((int)8), VkDescriptorAddressInfoEXT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ADDRESS = layout.offsetof(2);
        RANGE = layout.offsetof(3);
        FORMAT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorAddressInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDescriptorAddressInfoEXT ELEMENT_FACTORY = VkDescriptorAddressInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorAddressInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorAddressInfoEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDescriptorAddressInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long address$() {
            return VkDescriptorAddressInfoEXT.naddress$(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long range() {
            return VkDescriptorAddressInfoEXT.nrange(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkDescriptorAddressInfoEXT.nformat(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorAddressInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000316003);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDescriptorAddressInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer address$(@NativeType(value="VkDeviceAddress") long value) {
            VkDescriptorAddressInfoEXT.naddress$(this.address(), value);
            return this;
        }

        public Buffer range(@NativeType(value="VkDeviceSize") long value) {
            VkDescriptorAddressInfoEXT.nrange(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkDescriptorAddressInfoEXT.nformat(this.address(), value);
            return this;
        }
    }
}

