/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCopy2;

public class VkCopyImageInfo2
extends Struct<VkCopyImageInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCIMAGE;
    public static final int SRCIMAGELAYOUT;
    public static final int DSTIMAGE;
    public static final int DSTIMAGELAYOUT;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyImageInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyImageInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkCopyImageInfo2(address, container);
    }

    public VkCopyImageInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyImageInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyImageInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyImageInfo2.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long srcImage() {
        return VkCopyImageInfo2.nsrcImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int srcImageLayout() {
        return VkCopyImageInfo2.nsrcImageLayout(this.address());
    }

    @NativeType(value="VkImage")
    public long dstImage() {
        return VkCopyImageInfo2.ndstImage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int dstImageLayout() {
        return VkCopyImageInfo2.ndstImageLayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyImageInfo2.nregionCount(this.address());
    }

    @NativeType(value="VkImageCopy2 const *")
    public VkImageCopy2.Buffer pRegions() {
        return VkCopyImageInfo2.npRegions(this.address());
    }

    public VkCopyImageInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageInfo2.nsType(this.address(), value);
        return this;
    }

    public VkCopyImageInfo2 sType$Default() {
        return this.sType(1000337001);
    }

    public VkCopyImageInfo2 pNext(@NativeType(value="void const *") long value) {
        VkCopyImageInfo2.npNext(this.address(), value);
        return this;
    }

    public VkCopyImageInfo2 srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageInfo2.nsrcImage(this.address(), value);
        return this;
    }

    public VkCopyImageInfo2 srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageInfo2.nsrcImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageInfo2 dstImage(@NativeType(value="VkImage") long value) {
        VkCopyImageInfo2.ndstImage(this.address(), value);
        return this;
    }

    public VkCopyImageInfo2 dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageInfo2.ndstImageLayout(this.address(), value);
        return this;
    }

    public VkCopyImageInfo2 pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
        VkCopyImageInfo2.npRegions(this.address(), value);
        return this;
    }

    public VkCopyImageInfo2 set(int sType, long pNext, long srcImage, int srcImageLayout, long dstImage, int dstImageLayout, VkImageCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageInfo2 set(VkCopyImageInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyImageInfo2 malloc() {
        return new VkCopyImageInfo2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyImageInfo2 calloc() {
        return new VkCopyImageInfo2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyImageInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyImageInfo2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyImageInfo2 create(long address) {
        return new VkCopyImageInfo2(address, null);
    }

    @Nullable
    public static VkCopyImageInfo2 createSafe(long address) {
        return address == 0L ? null : new VkCopyImageInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyImageInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageInfo2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyImageInfo2 malloc(MemoryStack stack) {
        return new VkCopyImageInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyImageInfo2 calloc(MemoryStack stack) {
        return new VkCopyImageInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCIMAGE);
    }

    public static int nsrcImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCIMAGELAYOUT);
    }

    public static long ndstImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTIMAGE);
    }

    public static int ndstImageLayout(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTIMAGELAYOUT);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkImageCopy2.Buffer npRegions(long struct) {
        return VkImageCopy2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyImageInfo2.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCIMAGE, value);
    }

    public static void nsrcImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCIMAGELAYOUT, value);
    }

    public static void ndstImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTIMAGE, value);
    }

    public static void ndstImageLayout(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTIMAGELAYOUT, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkImageCopy2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyImageInfo2.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkCopyImageInfo2.__struct((Struct.Member[])new Struct.Member[]{VkCopyImageInfo2.__member((int)4), VkCopyImageInfo2.__member((int)POINTER_SIZE), VkCopyImageInfo2.__member((int)8), VkCopyImageInfo2.__member((int)4), VkCopyImageInfo2.__member((int)8), VkCopyImageInfo2.__member((int)4), VkCopyImageInfo2.__member((int)4), VkCopyImageInfo2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCIMAGE = layout.offsetof(2);
        SRCIMAGELAYOUT = layout.offsetof(3);
        DSTIMAGE = layout.offsetof(4);
        DSTIMAGELAYOUT = layout.offsetof(5);
        REGIONCOUNT = layout.offsetof(6);
        PREGIONS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkCopyImageInfo2, Buffer>
    implements NativeResource {
        private static final VkCopyImageInfo2 ELEMENT_FACTORY = VkCopyImageInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCopyImageInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyImageInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyImageInfo2.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long srcImage() {
            return VkCopyImageInfo2.nsrcImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int srcImageLayout() {
            return VkCopyImageInfo2.nsrcImageLayout(this.address());
        }

        @NativeType(value="VkImage")
        public long dstImage() {
            return VkCopyImageInfo2.ndstImage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int dstImageLayout() {
            return VkCopyImageInfo2.ndstImageLayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyImageInfo2.nregionCount(this.address());
        }

        @NativeType(value="VkImageCopy2 const *")
        public VkImageCopy2.Buffer pRegions() {
            return VkCopyImageInfo2.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageInfo2.nsrcImage(this.address(), value);
            return this;
        }

        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageInfo2.nsrcImageLayout(this.address(), value);
            return this;
        }

        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyImageInfo2.ndstImage(this.address(), value);
            return this;
        }

        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageInfo2.ndstImageLayout(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
            VkCopyImageInfo2.npRegions(this.address(), value);
            return this;
        }
    }
}

