/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkBindPipelineIndirectCommandNV
extends Struct<VkBindPipelineIndirectCommandNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIPELINEADDRESS;

    protected VkBindPipelineIndirectCommandNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkBindPipelineIndirectCommandNV create(long address, @Nullable ByteBuffer container) {
        return new VkBindPipelineIndirectCommandNV(address, container);
    }

    public VkBindPipelineIndirectCommandNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkBindPipelineIndirectCommandNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long pipelineAddress() {
        return VkBindPipelineIndirectCommandNV.npipelineAddress(this.address());
    }

    public VkBindPipelineIndirectCommandNV pipelineAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkBindPipelineIndirectCommandNV.npipelineAddress(this.address(), value);
        return this;
    }

    public VkBindPipelineIndirectCommandNV set(VkBindPipelineIndirectCommandNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkBindPipelineIndirectCommandNV malloc() {
        return new VkBindPipelineIndirectCommandNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkBindPipelineIndirectCommandNV calloc() {
        return new VkBindPipelineIndirectCommandNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkBindPipelineIndirectCommandNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkBindPipelineIndirectCommandNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkBindPipelineIndirectCommandNV create(long address) {
        return new VkBindPipelineIndirectCommandNV(address, null);
    }

    @Nullable
    public static VkBindPipelineIndirectCommandNV createSafe(long address) {
        return address == 0L ? null : new VkBindPipelineIndirectCommandNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkBindPipelineIndirectCommandNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBindPipelineIndirectCommandNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBindPipelineIndirectCommandNV malloc(MemoryStack stack) {
        return new VkBindPipelineIndirectCommandNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBindPipelineIndirectCommandNV calloc(MemoryStack stack) {
        return new VkBindPipelineIndirectCommandNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long npipelineAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)PIPELINEADDRESS);
    }

    public static void npipelineAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PIPELINEADDRESS, value);
    }

    static {
        Struct.Layout layout = VkBindPipelineIndirectCommandNV.__struct((Struct.Member[])new Struct.Member[]{VkBindPipelineIndirectCommandNV.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIPELINEADDRESS = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VkBindPipelineIndirectCommandNV, Buffer>
    implements NativeResource {
        private static final VkBindPipelineIndirectCommandNV ELEMENT_FACTORY = VkBindPipelineIndirectCommandNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkBindPipelineIndirectCommandNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long pipelineAddress() {
            return VkBindPipelineIndirectCommandNV.npipelineAddress(this.address());
        }

        public Buffer pipelineAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkBindPipelineIndirectCommandNV.npipelineAddress(this.address(), value);
            return this;
        }
    }
}

