/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkRenderingInfo;
import org.lwjgl.vulkan.VkTilePropertiesQCOM;

public class QCOMTileProperties {
    public static final int VK_QCOM_TILE_PROPERTIES_SPEC_VERSION = 1;
    public static final String VK_QCOM_TILE_PROPERTIES_EXTENSION_NAME = "VK_QCOM_tile_properties";
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM = 1000484000;
    public static final int VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM = 1000484001;

    protected QCOMTileProperties() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetFramebufferTilePropertiesQCOM(VkDevice device, long framebuffer, long pPropertiesCount, long pProperties) {
        long __functionAddress = device.getCapabilities().vkGetFramebufferTilePropertiesQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)device.address(), (long)framebuffer, (long)pPropertiesCount, (long)pProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetFramebufferTilePropertiesQCOM(VkDevice device, @NativeType(value="VkFramebuffer") long framebuffer, @NativeType(value="uint32_t *") IntBuffer pPropertiesCount, @Nullable @NativeType(value="VkTilePropertiesQCOM *") VkTilePropertiesQCOM.Buffer pProperties) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPropertiesCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertiesCount.get(pPropertiesCount.position()));
        }
        return QCOMTileProperties.nvkGetFramebufferTilePropertiesQCOM(device, framebuffer, MemoryUtil.memAddress((IntBuffer)pPropertiesCount), MemoryUtil.memAddressSafe((Pointer)pProperties));
    }

    public static int nvkGetDynamicRenderingTilePropertiesQCOM(VkDevice device, long pRenderingInfo, long pProperties) {
        long __functionAddress = device.getCapabilities().vkGetDynamicRenderingTilePropertiesQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            VkRenderingInfo.validate(pRenderingInfo);
        }
        return JNI.callPPPI((long)device.address(), (long)pRenderingInfo, (long)pProperties, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetDynamicRenderingTilePropertiesQCOM(VkDevice device, @NativeType(value="VkRenderingInfo const *") VkRenderingInfo pRenderingInfo, @NativeType(value="VkTilePropertiesQCOM *") VkTilePropertiesQCOM pProperties) {
        return QCOMTileProperties.nvkGetDynamicRenderingTilePropertiesQCOM(device, pRenderingInfo.address(), pProperties.address());
    }

    @NativeType(value="VkResult")
    public static int vkGetFramebufferTilePropertiesQCOM(VkDevice device, @NativeType(value="VkFramebuffer") long framebuffer, @NativeType(value="uint32_t *") int[] pPropertiesCount, @Nullable @NativeType(value="VkTilePropertiesQCOM *") VkTilePropertiesQCOM.Buffer pProperties) {
        long __functionAddress = device.getCapabilities().vkGetFramebufferTilePropertiesQCOM;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pPropertiesCount, (int)1);
            Checks.checkSafe((CustomBuffer)pProperties, (int)pPropertiesCount[0]);
        }
        return JNI.callPJPPI((long)device.address(), (long)framebuffer, (int[])pPropertiesCount, (long)MemoryUtil.memAddressSafe((Pointer)pProperties), (long)__functionAddress);
    }
}

