/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDispatchGraphCountInfoAMDX;
import org.lwjgl.vulkan.VkExecutionGraphPipelineCreateInfoAMDX;
import org.lwjgl.vulkan.VkExecutionGraphPipelineScratchSizeAMDX;
import org.lwjgl.vulkan.VkPipelineShaderStageNodeCreateInfoAMDX;

public class AMDXShaderEnqueue {
    public static final int VK_AMDX_SHADER_ENQUEUE_SPEC_VERSION = 1;
    public static final String VK_AMDX_SHADER_ENQUEUE_EXTENSION_NAME = "VK_AMDX_shader_enqueue";
    public static final int VK_SHADER_INDEX_UNUSED_AMDX = -1;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_FEATURES_AMDX = 1000134000;
    public static final int VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ENQUEUE_PROPERTIES_AMDX = 1000134001;
    public static final int VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX = 1000134002;
    public static final int VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX = 1000134003;
    public static final int VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_NODE_CREATE_INFO_AMDX = 1000134004;
    public static final int VK_BUFFER_USAGE_EXECUTION_GRAPH_SCRATCH_BIT_AMDX = 0x2000000;
    public static final int VK_PIPELINE_BIND_POINT_EXECUTION_GRAPH_AMDX = 1000134000;
    public static final long VK_BUFFER_USAGE_2_EXECUTION_GRAPH_SCRATCH_BIT_AMDX = 0x2000000L;

    protected AMDXShaderEnqueue() {
        throw new UnsupportedOperationException();
    }

    public static int nvkCreateExecutionGraphPipelinesAMDX(VkDevice device, long pipelineCache, int createInfoCount, long pCreateInfos, long pAllocator, long pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateExecutionGraphPipelinesAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Struct.validate((long)pCreateInfos, (int)createInfoCount, (int)VkExecutionGraphPipelineCreateInfoAMDX.SIZEOF, VkExecutionGraphPipelineCreateInfoAMDX::validate);
        }
        return JNI.callPJPPPI((long)device.address(), (long)pipelineCache, (int)createInfoCount, (long)pCreateInfos, (long)pAllocator, (long)pPipelines, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateExecutionGraphPipelinesAMDX(VkDevice device, @NativeType(value="VkPipelineCache") long pipelineCache, @NativeType(value="VkExecutionGraphPipelineCreateInfoAMDX const *") VkExecutionGraphPipelineCreateInfoAMDX.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkPipeline *") LongBuffer pPipelines) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pPipelines, (int)pCreateInfos.remaining());
        }
        return AMDXShaderEnqueue.nvkCreateExecutionGraphPipelinesAMDX(device, pipelineCache, pCreateInfos.remaining(), pCreateInfos.address(), MemoryUtil.memAddressSafe((Pointer)pAllocator), MemoryUtil.memAddress((LongBuffer)pPipelines));
    }

    public static int nvkGetExecutionGraphPipelineScratchSizeAMDX(VkDevice device, long executionGraph, long pSizeInfo) {
        long __functionAddress = device.getCapabilities().vkGetExecutionGraphPipelineScratchSizeAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)device.address(), (long)executionGraph, (long)pSizeInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetExecutionGraphPipelineScratchSizeAMDX(VkDevice device, @NativeType(value="VkPipeline") long executionGraph, @NativeType(value="VkExecutionGraphPipelineScratchSizeAMDX *") VkExecutionGraphPipelineScratchSizeAMDX pSizeInfo) {
        return AMDXShaderEnqueue.nvkGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo.address());
    }

    public static int nvkGetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, long executionGraph, long pNodeInfo, long pNodeIndex) {
        long __functionAddress = device.getCapabilities().vkGetExecutionGraphPipelineNodeIndexAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPPI((long)device.address(), (long)executionGraph, (long)pNodeInfo, (long)pNodeIndex, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, @NativeType(value="VkPipeline") long executionGraph, @NativeType(value="VkPipelineShaderStageNodeCreateInfoAMDX const *") VkPipelineShaderStageNodeCreateInfoAMDX pNodeInfo, @NativeType(value="uint32_t *") IntBuffer pNodeIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pNodeIndex, (int)1);
        }
        return AMDXShaderEnqueue.nvkGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo.address(), MemoryUtil.memAddress((IntBuffer)pNodeIndex));
    }

    public static void vkCmdInitializeGraphScratchMemoryAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkDeviceAddress") long scratch) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdInitializeGraphScratchMemoryAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJV((long)commandBuffer.address(), (long)scratch, (long)__functionAddress);
    }

    public static void nvkCmdDispatchGraphAMDX(VkCommandBuffer commandBuffer, long scratch, long pCountInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchGraphAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)commandBuffer.address(), (long)scratch, (long)pCountInfo, (long)__functionAddress);
    }

    public static void vkCmdDispatchGraphAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkDeviceAddress") long scratch, @NativeType(value="VkDispatchGraphCountInfoAMDX const *") VkDispatchGraphCountInfoAMDX pCountInfo) {
        AMDXShaderEnqueue.nvkCmdDispatchGraphAMDX(commandBuffer, scratch, pCountInfo.address());
    }

    public static void nvkCmdDispatchGraphIndirectAMDX(VkCommandBuffer commandBuffer, long scratch, long pCountInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchGraphIndirectAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJPV((long)commandBuffer.address(), (long)scratch, (long)pCountInfo, (long)__functionAddress);
    }

    public static void vkCmdDispatchGraphIndirectAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkDeviceAddress") long scratch, @NativeType(value="VkDispatchGraphCountInfoAMDX const *") VkDispatchGraphCountInfoAMDX pCountInfo) {
        AMDXShaderEnqueue.nvkCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, pCountInfo.address());
    }

    public static void vkCmdDispatchGraphIndirectCountAMDX(VkCommandBuffer commandBuffer, @NativeType(value="VkDeviceAddress") long scratch, @NativeType(value="VkDeviceAddress") long countInfo) {
        long __functionAddress = commandBuffer.getCapabilities().vkCmdDispatchGraphIndirectCountAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPJJV((long)commandBuffer.address(), (long)scratch, (long)countInfo, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateExecutionGraphPipelinesAMDX(VkDevice device, @NativeType(value="VkPipelineCache") long pipelineCache, @NativeType(value="VkExecutionGraphPipelineCreateInfoAMDX const *") VkExecutionGraphPipelineCreateInfoAMDX.Buffer pCreateInfos, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkPipeline *") long[] pPipelines) {
        long __functionAddress = device.getCapabilities().vkCreateExecutionGraphPipelinesAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long[])pPipelines, (int)pCreateInfos.remaining());
            Struct.validate((long)pCreateInfos.address(), (int)pCreateInfos.remaining(), (int)VkExecutionGraphPipelineCreateInfoAMDX.SIZEOF, VkExecutionGraphPipelineCreateInfoAMDX::validate);
        }
        return JNI.callPJPPPI((long)device.address(), (long)pipelineCache, (int)pCreateInfos.remaining(), (long)pCreateInfos.address(), (long)MemoryUtil.memAddressSafe((Pointer)pAllocator), (long[])pPipelines, (long)__functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, @NativeType(value="VkPipeline") long executionGraph, @NativeType(value="VkPipelineShaderStageNodeCreateInfoAMDX const *") VkPipelineShaderStageNodeCreateInfoAMDX pNodeInfo, @NativeType(value="uint32_t *") int[] pNodeIndex) {
        long __functionAddress = device.getCapabilities().vkGetExecutionGraphPipelineNodeIndexAMDX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((int[])pNodeIndex, (int)1);
        }
        return JNI.callPJPPI((long)device.address(), (long)executionGraph, (long)pNodeInfo.address(), (int[])pNodeIndex, (long)__functionAddress);
    }
}

