/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationCallbacks;

public class VmaVirtualBlockCreateInfo
extends Struct<VmaVirtualBlockCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int PALLOCATIONCALLBACKS;

    protected VmaVirtualBlockCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaVirtualBlockCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VmaVirtualBlockCreateInfo(address, container);
    }

    public VmaVirtualBlockCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaVirtualBlockCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualBlockCreateInfo.nsize(this.address());
    }

    @NativeType(value="VmaVirtualBlockCreateFlagBits")
    public int flags() {
        return VmaVirtualBlockCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkAllocationCallbacks const *")
    public @Nullable VkAllocationCallbacks pAllocationCallbacks() {
        return VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address());
    }

    public VmaVirtualBlockCreateInfo size(@NativeType(value="VkDeviceSize") long value) {
        VmaVirtualBlockCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo flags(@NativeType(value="VmaVirtualBlockCreateFlagBits") int value) {
        VmaVirtualBlockCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo pAllocationCallbacks(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
        VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo set(long size, int flags, @Nullable VkAllocationCallbacks pAllocationCallbacks) {
        this.size(size);
        this.flags(flags);
        this.pAllocationCallbacks(pAllocationCallbacks);
        return this;
    }

    public VmaVirtualBlockCreateInfo set(VmaVirtualBlockCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaVirtualBlockCreateInfo malloc() {
        return new VmaVirtualBlockCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaVirtualBlockCreateInfo calloc() {
        return new VmaVirtualBlockCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaVirtualBlockCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaVirtualBlockCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaVirtualBlockCreateInfo create(long address) {
        return new VmaVirtualBlockCreateInfo(address, null);
    }

    public static @Nullable VmaVirtualBlockCreateInfo createSafe(long address) {
        return address == 0L ? null : new VmaVirtualBlockCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaVirtualBlockCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualBlockCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaVirtualBlockCreateInfo malloc(MemoryStack stack) {
        return new VmaVirtualBlockCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaVirtualBlockCreateInfo calloc(MemoryStack stack) {
        return new VmaVirtualBlockCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static @Nullable VkAllocationCallbacks npAllocationCallbacks(long struct) {
        return VkAllocationCallbacks.createSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PALLOCATIONCALLBACKS)));
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void npAllocationCallbacks(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PALLOCATIONCALLBACKS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = VmaVirtualBlockCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VmaVirtualBlockCreateInfo.__member((int)8), VmaVirtualBlockCreateInfo.__member((int)4), VmaVirtualBlockCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        PALLOCATIONCALLBACKS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualBlockCreateInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualBlockCreateInfo ELEMENT_FACTORY = VmaVirtualBlockCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VmaVirtualBlockCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualBlockCreateInfo.nsize(this.address());
        }

        @NativeType(value="VmaVirtualBlockCreateFlagBits")
        public int flags() {
            return VmaVirtualBlockCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkAllocationCallbacks const *")
        public @Nullable VkAllocationCallbacks pAllocationCallbacks() {
            return VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address());
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VmaVirtualBlockCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VmaVirtualBlockCreateFlagBits") int value) {
            VmaVirtualBlockCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pAllocationCallbacks(@NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks value) {
            VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address(), value);
            return this;
        }
    }
}

