/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationMove
extends Struct<VmaDefragmentationMove>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPERATION;
    public static final int SRCALLOCATION;
    public static final int DSTTMPALLOCATION;

    protected VmaDefragmentationMove(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VmaDefragmentationMove create(long address, @Nullable ByteBuffer container) {
        return new VmaDefragmentationMove(address, container);
    }

    public VmaDefragmentationMove(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaDefragmentationMove.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaDefragmentationMoveOperation")
    public int operation() {
        return VmaDefragmentationMove.noperation(this.address());
    }

    @NativeType(value="VmaAllocation")
    public long srcAllocation() {
        return VmaDefragmentationMove.nsrcAllocation(this.address());
    }

    @NativeType(value="VmaAllocation")
    public long dstTmpAllocation() {
        return VmaDefragmentationMove.ndstTmpAllocation(this.address());
    }

    public VmaDefragmentationMove operation(@NativeType(value="VmaDefragmentationMoveOperation") int value) {
        VmaDefragmentationMove.noperation(this.address(), value);
        return this;
    }

    public VmaDefragmentationMove srcAllocation(@NativeType(value="VmaAllocation") long value) {
        VmaDefragmentationMove.nsrcAllocation(this.address(), value);
        return this;
    }

    public VmaDefragmentationMove dstTmpAllocation(@NativeType(value="VmaAllocation") long value) {
        VmaDefragmentationMove.ndstTmpAllocation(this.address(), value);
        return this;
    }

    public VmaDefragmentationMove set(int operation, long srcAllocation, long dstTmpAllocation) {
        this.operation(operation);
        this.srcAllocation(srcAllocation);
        this.dstTmpAllocation(dstTmpAllocation);
        return this;
    }

    public VmaDefragmentationMove set(VmaDefragmentationMove src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaDefragmentationMove malloc() {
        return new VmaDefragmentationMove(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VmaDefragmentationMove calloc() {
        return new VmaDefragmentationMove(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VmaDefragmentationMove create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VmaDefragmentationMove(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VmaDefragmentationMove create(long address) {
        return new VmaDefragmentationMove(address, null);
    }

    public static @Nullable VmaDefragmentationMove createSafe(long address) {
        return address == 0L ? null : new VmaDefragmentationMove(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VmaDefragmentationMove.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationMove.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VmaDefragmentationMove malloc(MemoryStack stack) {
        return new VmaDefragmentationMove(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VmaDefragmentationMove calloc(MemoryStack stack) {
        return new VmaDefragmentationMove(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int noperation(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OPERATION));
    }

    public static long nsrcAllocation(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SRCALLOCATION));
    }

    public static long ndstTmpAllocation(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DSTTMPALLOCATION));
    }

    public static void noperation(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OPERATION), (int)value);
    }

    public static void nsrcAllocation(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SRCALLOCATION), (long)Checks.check((long)value));
    }

    public static void ndstTmpAllocation(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DSTTMPALLOCATION), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SRCALLOCATION)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DSTTMPALLOCATION)));
    }

    static {
        Struct.Layout layout = VmaDefragmentationMove.__struct((Struct.Member[])new Struct.Member[]{VmaDefragmentationMove.__member((int)4), VmaDefragmentationMove.__member((int)POINTER_SIZE), VmaDefragmentationMove.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPERATION = layout.offsetof(0);
        SRCALLOCATION = layout.offsetof(1);
        DSTTMPALLOCATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationMove, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationMove ELEMENT_FACTORY = VmaDefragmentationMove.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VmaDefragmentationMove getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaDefragmentationMoveOperation")
        public int operation() {
            return VmaDefragmentationMove.noperation(this.address());
        }

        @NativeType(value="VmaAllocation")
        public long srcAllocation() {
            return VmaDefragmentationMove.nsrcAllocation(this.address());
        }

        @NativeType(value="VmaAllocation")
        public long dstTmpAllocation() {
            return VmaDefragmentationMove.ndstTmpAllocation(this.address());
        }

        public Buffer operation(@NativeType(value="VmaDefragmentationMoveOperation") int value) {
            VmaDefragmentationMove.noperation(this.address(), value);
            return this;
        }

        public Buffer srcAllocation(@NativeType(value="VmaAllocation") long value) {
            VmaDefragmentationMove.nsrcAllocation(this.address(), value);
            return this;
        }

        public Buffer dstTmpAllocation(@NativeType(value="VmaAllocation") long value) {
            VmaDefragmentationMove.ndstTmpAllocation(this.address(), value);
            return this;
        }
    }
}

