/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationCallbacks;

public class VmaVirtualBlockCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int FLAGS;
    public static final int PALLOCATIONCALLBACKS;

    public VmaVirtualBlockCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaVirtualBlockCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualBlockCreateInfo.nsize(this.address());
    }

    @NativeType(value="VmaVirtualBlockCreateFlagBits")
    public int flags() {
        return VmaVirtualBlockCreateInfo.nflags(this.address());
    }

    @Nullable
    @NativeType(value="VkAllocationCallbacks const *")
    public VkAllocationCallbacks pAllocationCallbacks() {
        return VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address());
    }

    public VmaVirtualBlockCreateInfo size(@NativeType(value="VkDeviceSize") long value) {
        VmaVirtualBlockCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo flags(@NativeType(value="VmaVirtualBlockCreateFlagBits") int value) {
        VmaVirtualBlockCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo pAllocationCallbacks(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
        VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address(), value);
        return this;
    }

    public VmaVirtualBlockCreateInfo set(long size, int flags, @Nullable VkAllocationCallbacks pAllocationCallbacks) {
        this.size(size);
        this.flags(flags);
        this.pAllocationCallbacks(pAllocationCallbacks);
        return this;
    }

    public VmaVirtualBlockCreateInfo set(VmaVirtualBlockCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaVirtualBlockCreateInfo malloc() {
        return (VmaVirtualBlockCreateInfo)VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaVirtualBlockCreateInfo calloc() {
        return (VmaVirtualBlockCreateInfo)VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaVirtualBlockCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaVirtualBlockCreateInfo)VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaVirtualBlockCreateInfo create(long address) {
        return (VmaVirtualBlockCreateInfo)VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, (long)address);
    }

    @Nullable
    public static VmaVirtualBlockCreateInfo createSafe(long address) {
        return address == 0L ? null : (VmaVirtualBlockCreateInfo)VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaVirtualBlockCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaVirtualBlockCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaVirtualBlockCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualBlockCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaVirtualBlockCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaVirtualBlockCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaVirtualBlockCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaVirtualBlockCreateInfo malloc(MemoryStack stack) {
        return (VmaVirtualBlockCreateInfo)VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaVirtualBlockCreateInfo calloc(MemoryStack stack) {
        return (VmaVirtualBlockCreateInfo)VmaVirtualBlockCreateInfo.wrap(VmaVirtualBlockCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaVirtualBlockCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaVirtualBlockCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    @Nullable
    public static VkAllocationCallbacks npAllocationCallbacks(long struct) {
        return VkAllocationCallbacks.createSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PALLOCATIONCALLBACKS)));
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npAllocationCallbacks(long struct, @Nullable VkAllocationCallbacks value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PALLOCATIONCALLBACKS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        long pAllocationCallbacks = MemoryUtil.memGetAddress((long)(struct + (long)PALLOCATIONCALLBACKS));
        if (pAllocationCallbacks != 0L) {
            VkAllocationCallbacks.validate((long)pAllocationCallbacks);
        }
    }

    static {
        Struct.Layout layout = VmaVirtualBlockCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VmaVirtualBlockCreateInfo.__member((int)8), VmaVirtualBlockCreateInfo.__member((int)4), VmaVirtualBlockCreateInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        PALLOCATIONCALLBACKS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualBlockCreateInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualBlockCreateInfo ELEMENT_FACTORY = VmaVirtualBlockCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaVirtualBlockCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualBlockCreateInfo.nsize(this.address());
        }

        @NativeType(value="VmaVirtualBlockCreateFlagBits")
        public int flags() {
            return VmaVirtualBlockCreateInfo.nflags(this.address());
        }

        @Nullable
        @NativeType(value="VkAllocationCallbacks const *")
        public VkAllocationCallbacks pAllocationCallbacks() {
            return VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address());
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VmaVirtualBlockCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VmaVirtualBlockCreateFlagBits") int value) {
            VmaVirtualBlockCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pAllocationCallbacks(@Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks value) {
            VmaVirtualBlockCreateInfo.npAllocationCallbacks(this.address(), value);
            return this;
        }
    }
}

