/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.vma.LibVma;
import org.lwjgl.util.vma.VmaAllocationCreateInfo;
import org.lwjgl.util.vma.VmaAllocationInfo;
import org.lwjgl.util.vma.VmaAllocatorCreateInfo;
import org.lwjgl.util.vma.VmaDefragmentationInfo;
import org.lwjgl.util.vma.VmaDefragmentationInfo2;
import org.lwjgl.util.vma.VmaDefragmentationStats;
import org.lwjgl.util.vma.VmaPoolCreateInfo;
import org.lwjgl.util.vma.VmaPoolStats;
import org.lwjgl.util.vma.VmaStats;
import org.lwjgl.vulkan.VkBufferCreateInfo;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkMemoryRequirements;

public class Vma {
    public static final int VMA_RECORD_FLUSH_AFTER_CALL_BIT = 1;
    public static final int VMA_ALLOCATOR_CREATE_EXTERNALLY_SYNCHRONIZED_BIT = 1;
    public static final int VMA_ALLOCATOR_CREATE_KHR_DEDICATED_ALLOCATION_BIT = 2;
    public static final int VMA_ALLOCATOR_CREATE_KHR_BIND_MEMORY2_BIT = 4;
    public static final int VMA_MEMORY_USAGE_UNKNOWN = 0;
    public static final int VMA_MEMORY_USAGE_GPU_ONLY = 1;
    public static final int VMA_MEMORY_USAGE_CPU_ONLY = 2;
    public static final int VMA_MEMORY_USAGE_CPU_TO_GPU = 3;
    public static final int VMA_MEMORY_USAGE_GPU_TO_CPU = 4;
    public static final int VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT = 1;
    public static final int VMA_ALLOCATION_CREATE_NEVER_ALLOCATE_BIT = 2;
    public static final int VMA_ALLOCATION_CREATE_MAPPED_BIT = 4;
    public static final int VMA_ALLOCATION_CREATE_CAN_BECOME_LOST_BIT = 8;
    public static final int VMA_ALLOCATION_CREATE_CAN_MAKE_OTHER_LOST_BIT = 16;
    public static final int VMA_ALLOCATION_CREATE_USER_DATA_COPY_STRING_BIT = 32;
    public static final int VMA_ALLOCATION_CREATE_UPPER_ADDRESS_BIT = 64;
    public static final int VMA_ALLOCATION_CREATE_DONT_BIND_BIT = 128;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_BEST_FIT_BIT = 65536;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_WORST_FIT_BIT = 131072;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_FIRST_FIT_BIT = 262144;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT = 65536;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT = 262144;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MIN_FRAGMENTATION_BIT = 131072;
    public static final int VMA_ALLOCATION_CREATE_STRATEGY_MASK = 458752;
    public static final int VMA_POOL_CREATE_IGNORE_BUFFER_IMAGE_GRANULARITY_BIT = 2;
    public static final int VMA_POOL_CREATE_LINEAR_ALGORITHM_BIT = 4;
    public static final int VMA_POOL_CREATE_BUDDY_ALGORITHM_BIT = 8;
    public static final int VMA_POOL_CREATE_ALGORITHM_MASK = 12;

    protected Vma() {
        throw new UnsupportedOperationException();
    }

    public static native int nvmaCreateAllocator(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCreateAllocator(@NativeType(value="VmaAllocatorCreateInfo const *") VmaAllocatorCreateInfo pCreateInfo, @NativeType(value="VmaAllocator *") PointerBuffer pAllocator) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pAllocator, (int)1);
            VmaAllocatorCreateInfo.validate(pCreateInfo.address());
        }
        return Vma.nvmaCreateAllocator(pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocator));
    }

    public static native void nvmaDestroyAllocator(long var0);

    public static void vmaDestroyAllocator(@NativeType(value="VmaAllocator") long allocator) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaDestroyAllocator(allocator);
    }

    public static native void nvmaGetPhysicalDeviceProperties(long var0, long var2);

    public static void vmaGetPhysicalDeviceProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkPhysicalDeviceProperties const **") PointerBuffer ppPhysicalDeviceProperties) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)ppPhysicalDeviceProperties, (int)1);
        }
        Vma.nvmaGetPhysicalDeviceProperties(allocator, MemoryUtil.memAddress((CustomBuffer)ppPhysicalDeviceProperties));
    }

    public static native void nvmaGetMemoryProperties(long var0, long var2);

    public static void vmaGetMemoryProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkPhysicalDeviceMemoryProperties const **") PointerBuffer ppPhysicalDeviceMemoryProperties) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)ppPhysicalDeviceMemoryProperties, (int)1);
        }
        Vma.nvmaGetMemoryProperties(allocator, MemoryUtil.memAddress((CustomBuffer)ppPhysicalDeviceMemoryProperties));
    }

    public static native void nvmaGetMemoryTypeProperties(long var0, int var2, long var3);

    public static void vmaGetMemoryTypeProperties(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeIndex, @NativeType(value="VkMemoryPropertyFlags *") IntBuffer pFlags) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pFlags, (int)1);
        }
        Vma.nvmaGetMemoryTypeProperties(allocator, memoryTypeIndex, MemoryUtil.memAddress((IntBuffer)pFlags));
    }

    public static native void nvmaSetCurrentFrameIndex(long var0, int var2);

    public static void vmaSetCurrentFrameIndex(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int frameIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaSetCurrentFrameIndex(allocator, frameIndex);
    }

    public static native void nvmaCalculateStats(long var0, long var2);

    public static void vmaCalculateStats(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaStats *") VmaStats pStats) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaCalculateStats(allocator, pStats.address());
    }

    public static native void nvmaBuildStatsString(long var0, long var2, int var4);

    public static void vmaBuildStatsString(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="char **") PointerBuffer ppStatsString, @NativeType(value="VkBool32") boolean detailedMap) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)ppStatsString, (int)1);
        }
        Vma.nvmaBuildStatsString(allocator, MemoryUtil.memAddress((CustomBuffer)ppStatsString), detailedMap ? 1 : 0);
    }

    public static native void nvmaFreeStatsString(long var0, long var2);

    public static void vmaFreeStatsString(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="char *") ByteBuffer pStatsString) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.checkNT1((ByteBuffer)pStatsString);
        }
        Vma.nvmaFreeStatsString(allocator, MemoryUtil.memAddress((ByteBuffer)pStatsString));
    }

    public static native int nvmaFindMemoryTypeIndex(long var0, int var2, long var3, long var5);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndex(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeBits, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pMemoryTypeIndex, (int)1);
        }
        return Vma.nvmaFindMemoryTypeIndex(allocator, memoryTypeBits, pAllocationCreateInfo.address(), MemoryUtil.memAddress((IntBuffer)pMemoryTypeIndex));
    }

    public static native int nvmaFindMemoryTypeIndexForBufferInfo(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndexForBufferInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pMemoryTypeIndex, (int)1);
            VkBufferCreateInfo.validate((long)pBufferCreateInfo.address());
        }
        return Vma.nvmaFindMemoryTypeIndexForBufferInfo(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((IntBuffer)pMemoryTypeIndex));
    }

    public static native int nvmaFindMemoryTypeIndexForImageInfo(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaFindMemoryTypeIndexForImageInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="uint32_t *") IntBuffer pMemoryTypeIndex) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pMemoryTypeIndex, (int)1);
            VkImageCreateInfo.validate((long)pImageCreateInfo.address());
        }
        return Vma.nvmaFindMemoryTypeIndexForImageInfo(allocator, pImageCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((IntBuffer)pMemoryTypeIndex));
    }

    public static native int nvmaCreatePool(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaCreatePool(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPoolCreateInfo const *") VmaPoolCreateInfo pCreateInfo, @NativeType(value="VmaPool *") PointerBuffer pPool) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pPool, (int)1);
        }
        return Vma.nvmaCreatePool(allocator, pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pPool));
    }

    public static native void nvmaDestroyPool(long var0, long var2);

    public static void vmaDestroyPool(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        Vma.nvmaDestroyPool(allocator, pool);
    }

    public static native void nvmaGetPoolStats(long var0, long var2, long var4);

    public static void vmaGetPoolStats(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @NativeType(value="VmaPoolStats *") VmaPoolStats pPoolStats) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        Vma.nvmaGetPoolStats(allocator, pool, pPoolStats.address());
    }

    public static native void nvmaMakePoolAllocationsLost(long var0, long var2, long var4);

    public static void vmaMakePoolAllocationsLost(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool, @Nullable @NativeType(value="size_t *") PointerBuffer pLostAllocationCount) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
            Checks.checkSafe((CustomBuffer)pLostAllocationCount, (int)1);
        }
        Vma.nvmaMakePoolAllocationsLost(allocator, pool, MemoryUtil.memAddressSafe((Pointer)pLostAllocationCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static long vmaMakePoolAllocationsLost(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer pLostAllocationCount = stack.callocPointer(1);
            Vma.nvmaMakePoolAllocationsLost(allocator, pool, MemoryUtil.memAddress((CustomBuffer)pLostAllocationCount));
            long l = pLostAllocationCount.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nvmaCheckPoolCorruption(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaCheckPoolCorruption(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaPool") long pool) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)pool);
        }
        return Vma.nvmaCheckPoolCorruption(allocator, pool);
    }

    public static native int nvmaAllocateMemory(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkMemoryRequirements const *") VkMemoryRequirements pVkMemoryRequirements, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaAllocateMemory(allocator, pVkMemoryRequirements.address(), pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryPages(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryPages(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkMemoryRequirements const *") VkMemoryRequirements pVkMemoryRequirements, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocations, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo.Buffer pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.checkSafe((CustomBuffer)pAllocationInfo, (int)pAllocations.remaining());
            Checks.check((CustomBuffer)pAllocations, (int)1);
        }
        return Vma.nvmaAllocateMemoryPages(allocator, pVkMemoryRequirements.address(), pCreateInfo.address(), pAllocations.remaining(), MemoryUtil.memAddress((CustomBuffer)pAllocations), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryForBuffer(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryForBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaAllocateMemoryForBuffer(allocator, buffer, pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native int nvmaAllocateMemoryForImage(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaAllocateMemoryForImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImage") long image, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pCreateInfo, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        return Vma.nvmaAllocateMemoryForImage(allocator, image, pCreateInfo.address(), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native void nvmaFreeMemory(long var0, long var2);

    public static void vmaFreeMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaFreeMemory(allocator, allocation);
    }

    public static native void nvmaFreeMemoryPages(long var0, long var2, long var4);

    public static void vmaFreeMemoryPages(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation *") PointerBuffer pAllocations) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        Vma.nvmaFreeMemoryPages(allocator, pAllocations.remaining(), MemoryUtil.memAddress((CustomBuffer)pAllocations));
    }

    public static native int nvmaResizeAllocation(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaResizeAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long newSize) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaResizeAllocation(allocator, allocation, newSize);
    }

    public static native void nvmaGetAllocationInfo(long var0, long var2, long var4);

    public static void vmaGetAllocationInfo(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaGetAllocationInfo(allocator, allocation, pAllocationInfo.address());
    }

    public static native int nvmaTouchAllocation(long var0, long var2);

    @NativeType(value="VkBool32")
    public static boolean vmaTouchAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaTouchAllocation(allocator, allocation) != 0;
    }

    public static native void nvmaSetAllocationUserData(long var0, long var2, long var4);

    public static void vmaSetAllocationUserData(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="void *") long pUserData) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((long)pUserData);
        }
        Vma.nvmaSetAllocationUserData(allocator, allocation, pUserData);
    }

    public static native void nvmaCreateLostAllocation(long var0, long var2);

    public static void vmaCreateLostAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pAllocation, (int)1);
        }
        Vma.nvmaCreateLostAllocation(allocator, MemoryUtil.memAddress((CustomBuffer)pAllocation));
    }

    public static native int nvmaMapMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaMapMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="void **") PointerBuffer ppData) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
            Checks.check((CustomBuffer)ppData, (int)1);
        }
        return Vma.nvmaMapMemory(allocator, allocation, MemoryUtil.memAddress((CustomBuffer)ppData));
    }

    public static native void nvmaUnmapMemory(long var0, long var2);

    public static void vmaUnmapMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaUnmapMemory(allocator, allocation);
    }

    public static native void nvmaFlushAllocation(long var0, long var2, long var4, long var6);

    public static void vmaFlushAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkDeviceSize") long size) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaFlushAllocation(allocator, allocation, offset, size);
    }

    public static native void nvmaInvalidateAllocation(long var0, long var2, long var4, long var6);

    public static void vmaInvalidateAllocation(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long offset, @NativeType(value="VkDeviceSize") long size) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaInvalidateAllocation(allocator, allocation, offset, size);
    }

    public static native int nvmaCheckCorruption(long var0, int var2);

    @NativeType(value="VkResult")
    public static int vmaCheckCorruption(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="uint32_t") int memoryTypeBits) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        return Vma.nvmaCheckCorruption(allocator, memoryTypeBits);
    }

    public static native int nvmaDefragmentationBegin(long var0, long var2, long var4, long var6);

    @NativeType(value="VkResult")
    public static int vmaDefragmentationBegin(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationInfo2 const *") VmaDefragmentationInfo2 pInfo, @Nullable @NativeType(value="VmaDefragmentationStats *") VmaDefragmentationStats pStats, @NativeType(value="VmaDefragmentationContext *") PointerBuffer pContext) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((CustomBuffer)pContext, (int)1);
            VmaDefragmentationInfo2.validate(pInfo.address());
        }
        return Vma.nvmaDefragmentationBegin(allocator, pInfo.address(), MemoryUtil.memAddressSafe((Pointer)pStats), MemoryUtil.memAddress((CustomBuffer)pContext));
    }

    public static native int nvmaDefragmentationEnd(long var0, long var2);

    @NativeType(value="VkResult")
    public static int vmaDefragmentationEnd(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaDefragmentationContext") long context) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
        }
        return Vma.nvmaDefragmentationEnd(allocator, context);
    }

    public static native int nvmaDefragment(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaDefragment(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation *") PointerBuffer pAllocations, @Nullable @NativeType(value="VkBool32 *") IntBuffer pAllocationsChanged, @Nullable @NativeType(value="VmaDefragmentationInfo const *") VmaDefragmentationInfo pDefragmentationInfo, @Nullable @NativeType(value="VmaDefragmentationStats *") VmaDefragmentationStats pDefragmentationStats) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.checkSafe((Buffer)pAllocationsChanged, (int)pAllocations.remaining());
        }
        return Vma.nvmaDefragment(allocator, MemoryUtil.memAddress((CustomBuffer)pAllocations), pAllocations.remaining(), MemoryUtil.memAddressSafe((IntBuffer)pAllocationsChanged), MemoryUtil.memAddressSafe((Pointer)pDefragmentationInfo), MemoryUtil.memAddressSafe((Pointer)pDefragmentationStats));
    }

    public static native int nvmaBindBufferMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBindBufferMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkBuffer") long buffer) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindBufferMemory(allocator, allocation, buffer);
    }

    public static native int nvmaBindBufferMemory2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaBindBufferMemory2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkBuffer") long buffer, @NativeType(value="void const *") long pNext) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindBufferMemory2(allocator, allocation, allocationLocalOffset, buffer, pNext);
    }

    public static native int nvmaBindImageMemory(long var0, long var2, long var4);

    @NativeType(value="VkResult")
    public static int vmaBindImageMemory(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkImage") long image) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindImageMemory(allocator, allocation, image);
    }

    public static native int nvmaBindImageMemory2(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="VkResult")
    public static int vmaBindImageMemory2(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VmaAllocation") long allocation, @NativeType(value="VkDeviceSize") long allocationLocalOffset, @NativeType(value="VkImage") long image, @NativeType(value="void const *") long pNext) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        return Vma.nvmaBindImageMemory2(allocator, allocation, allocationLocalOffset, image, pNext);
    }

    public static native int nvmaCreateBuffer(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaCreateBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBufferCreateInfo const *") VkBufferCreateInfo pBufferCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkBuffer *") LongBuffer pBuffer, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pBuffer, (int)1);
            Checks.check((CustomBuffer)pAllocation, (int)1);
            VkBufferCreateInfo.validate((long)pBufferCreateInfo.address());
        }
        return Vma.nvmaCreateBuffer(allocator, pBufferCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pBuffer), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native void nvmaDestroyBuffer(long var0, long var2, long var4);

    public static void vmaDestroyBuffer(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkBuffer") long buffer, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaDestroyBuffer(allocator, buffer, allocation);
    }

    public static native int nvmaCreateImage(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="VkResult")
    public static int vmaCreateImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo pImageCreateInfo, @NativeType(value="VmaAllocationCreateInfo const *") VmaAllocationCreateInfo pAllocationCreateInfo, @NativeType(value="VkImage *") LongBuffer pImage, @NativeType(value="VmaAllocation *") PointerBuffer pAllocation, @Nullable @NativeType(value="VmaAllocationInfo *") VmaAllocationInfo pAllocationInfo) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((Buffer)pImage, (int)1);
            Checks.check((CustomBuffer)pAllocation, (int)1);
            VkImageCreateInfo.validate((long)pImageCreateInfo.address());
        }
        return Vma.nvmaCreateImage(allocator, pImageCreateInfo.address(), pAllocationCreateInfo.address(), MemoryUtil.memAddress((LongBuffer)pImage), MemoryUtil.memAddress((CustomBuffer)pAllocation), MemoryUtil.memAddressSafe((Pointer)pAllocationInfo));
    }

    public static native void nvmaDestroyImage(long var0, long var2, long var4);

    public static void vmaDestroyImage(@NativeType(value="VmaAllocator") long allocator, @NativeType(value="VkImage") long image, @NativeType(value="VmaAllocation") long allocation) {
        if (Checks.CHECKS) {
            Checks.check((long)allocator);
            Checks.check((long)allocation);
        }
        Vma.nvmaDestroyImage(allocator, image, allocation);
    }

    static {
        LibVma.initialize();
    }
}

