/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBVorbisInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLE_RATE;
    public static final int CHANNELS;
    public static final int SETUP_MEMORY_REQUIRED;
    public static final int SETUP_TEMP_MEMORY_REQUIRED;
    public static final int TEMP_MEMORY_REQUIRED;
    public static final int MAX_FRAME_SIZE;

    STBVorbisInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBVorbisInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBVorbisInfo.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int sample_rate() {
        return STBVorbisInfo.nsample_rate(this.address());
    }

    public int channels() {
        return STBVorbisInfo.nchannels(this.address());
    }

    public int setup_memory_required() {
        return STBVorbisInfo.nsetup_memory_required(this.address());
    }

    public int setup_temp_memory_required() {
        return STBVorbisInfo.nsetup_temp_memory_required(this.address());
    }

    public int temp_memory_required() {
        return STBVorbisInfo.ntemp_memory_required(this.address());
    }

    public int max_frame_size() {
        return STBVorbisInfo.nmax_frame_size(this.address());
    }

    public static STBVorbisInfo malloc() {
        return STBVorbisInfo.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static STBVorbisInfo calloc() {
        return STBVorbisInfo.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static STBVorbisInfo create() {
        return new STBVorbisInfo(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBVorbisInfo create(long address) {
        return address == 0L ? null : new STBVorbisInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBVorbisInfo.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBVorbisInfo.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBVorbisInfo mallocStack() {
        return STBVorbisInfo.mallocStack(MemoryStack.stackGet());
    }

    public static STBVorbisInfo callocStack() {
        return STBVorbisInfo.callocStack(MemoryStack.stackGet());
    }

    public static STBVorbisInfo mallocStack(MemoryStack stack) {
        return STBVorbisInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBVorbisInfo callocStack(MemoryStack stack) {
        return STBVorbisInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBVorbisInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBVorbisInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBVorbisInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBVorbisInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsample_rate(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLE_RATE));
    }

    public static int nchannels(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CHANNELS));
    }

    public static int nsetup_memory_required(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SETUP_MEMORY_REQUIRED));
    }

    public static int nsetup_temp_memory_required(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SETUP_TEMP_MEMORY_REQUIRED));
    }

    public static int ntemp_memory_required(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TEMP_MEMORY_REQUIRED));
    }

    public static int nmax_frame_size(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAX_FRAME_SIZE));
    }

    static {
        Struct.Layout layout = STBVorbisInfo.__struct((Struct.Member[])new Struct.Member[]{STBVorbisInfo.__member((int)4), STBVorbisInfo.__member((int)4), STBVorbisInfo.__member((int)4), STBVorbisInfo.__member((int)4), STBVorbisInfo.__member((int)4), STBVorbisInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLE_RATE = layout.offsetof(0);
        CHANNELS = layout.offsetof(1);
        SETUP_MEMORY_REQUIRED = layout.offsetof(2);
        SETUP_TEMP_MEMORY_REQUIRED = layout.offsetof(3);
        TEMP_MEMORY_REQUIRED = layout.offsetof(4);
        MAX_FRAME_SIZE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<STBVorbisInfo, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBVorbisInfo newInstance(long address) {
            return new STBVorbisInfo(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public int sample_rate() {
            return STBVorbisInfo.nsample_rate(this.address());
        }

        public int channels() {
            return STBVorbisInfo.nchannels(this.address());
        }

        public int setup_memory_required() {
            return STBVorbisInfo.nsetup_memory_required(this.address());
        }

        public int setup_temp_memory_required() {
            return STBVorbisInfo.nsetup_temp_memory_required(this.address());
        }

        public int temp_memory_required() {
            return STBVorbisInfo.ntemp_memory_required(this.address());
        }

        public int max_frame_size() {
            return STBVorbisInfo.nmax_frame_size(this.address());
        }
    }
}

