/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class STBImage {
    public static final int STBI_default = 0;
    public static final int STBI_grey = 1;
    public static final int STBI_grey_alpha = 2;
    public static final int STBI_rgb = 3;
    public static final int STBI_rgb_alpha = 4;

    protected STBImage() {
        throw new UnsupportedOperationException();
    }

    public static native long nstbi_load(long var0, long var2, long var4, long var6, int var8);

    public static ByteBuffer stbi_load(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memByteBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_load(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_load_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static ByteBuffer stbi_load_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memByteBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static ByteBuffer stbi_load_from_callbacks(STBIIOCallbacks clbk, long user, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_load_from_callbacks(clbk.address(), user, MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memByteBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_load_16(long var0, long var2, long var4, long var6, int var8);

    public static ShortBuffer stbi_load_16(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memShortBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer stbi_load_16(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
            ShortBuffer shortBuffer = MemoryUtil.memShortBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
            return shortBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_loadf(long var0, long var2, long var4, long var6, int var8);

    public static FloatBuffer stbi_loadf(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memFloatBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatBuffer stbi_loadf(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
            FloatBuffer floatBuffer = MemoryUtil.memFloatBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
            return floatBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, long var3, long var5, long var7, int var9);

    public static FloatBuffer stbi_loadf_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memFloatBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, long var4, long var6, long var8, int var10);

    public static FloatBuffer stbi_loadf_from_callbacks(STBIIOCallbacks clbk, long user, IntBuffer x, IntBuffer y, IntBuffer channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_loadf_from_callbacks(clbk.address(), user, MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)channels_in_file), desired_channels);
        return MemoryUtil.memFloatBuffer((long)__result, (int)(x.get(x.position()) * y.get(y.position()) * (desired_channels != 0 ? desired_channels : channels_in_file.get(channels_in_file.position()))));
    }

    public static native void stbi_hdr_to_ldr_gamma(float var0);

    public static native void stbi_hdr_to_ldr_scale(float var0);

    public static native void stbi_ldr_to_hdr_gamma(float var0);

    public static native void stbi_ldr_to_hdr_scale(float var0);

    public static native int nstbi_is_hdr(long var0);

    public static boolean stbi_is_hdr(ByteBuffer filename) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
        }
        return STBImage.nstbi_is_hdr(MemoryUtil.memAddress((ByteBuffer)filename)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_is_hdr(CharSequence filename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImage.nstbi_is_hdr(MemoryUtil.memAddress((ByteBuffer)filenameEncoded)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_is_hdr_from_memory(long var0, int var2);

    public static boolean stbi_is_hdr_from_memory(ByteBuffer buffer) {
        return STBImage.nstbi_is_hdr_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining()) != 0;
    }

    public static native int nstbi_is_hdr_from_callbacks(long var0, long var2);

    public static boolean stbi_is_hdr_from_callbacks(STBIIOCallbacks clbk, long user) {
        if (Checks.CHECKS) {
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_is_hdr_from_callbacks(clbk.address(), user) != 0;
    }

    public static native long nstbi_failure_reason();

    public static String stbi_failure_reason() {
        long __result = STBImage.nstbi_failure_reason();
        return MemoryUtil.memASCII((long)__result);
    }

    public static native void nstbi_image_free(long var0);

    public static void stbi_image_free(ByteBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress((ByteBuffer)retval_from_stbi_load));
    }

    public static void stbi_image_free(FloatBuffer retval_from_stbi_load) {
        STBImage.nstbi_image_free(MemoryUtil.memAddress((FloatBuffer)retval_from_stbi_load));
    }

    public static native int nstbi_info(long var0, long var2, long var4, long var6);

    public static boolean stbi_info(ByteBuffer filename, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filename), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_info(CharSequence filename, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, long var3, long var5, long var7);

    public static boolean stbi_info_from_memory(ByteBuffer buffer, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, long var4, long var6, long var8);

    public static boolean stbi_info_from_callbacks(STBIIOCallbacks clbk, long user, IntBuffer x, IntBuffer y, IntBuffer comp) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)x, (int)1);
            Checks.check((Buffer)y, (int)1);
            Checks.check((Buffer)comp, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), user, MemoryUtil.memAddress((IntBuffer)x), MemoryUtil.memAddress((IntBuffer)y), MemoryUtil.memAddress((IntBuffer)comp)) != 0;
    }

    public static native void nstbi_set_unpremultiply_on_load(int var0);

    public static void stbi_set_unpremultiply_on_load(boolean flag_true_if_should_unpremultiply) {
        STBImage.nstbi_set_unpremultiply_on_load(flag_true_if_should_unpremultiply ? 1 : 0);
    }

    public static native void nstbi_convert_iphone_png_to_rgb(int var0);

    public static void stbi_convert_iphone_png_to_rgb(boolean flag_true_if_should_convert) {
        STBImage.nstbi_convert_iphone_png_to_rgb(flag_true_if_should_convert ? 1 : 0);
    }

    public static native void nstbi_set_flip_vertically_on_load(int var0);

    public static void stbi_set_flip_vertically_on_load(boolean flag_true_if_should_flip) {
        STBImage.nstbi_set_flip_vertically_on_load(flag_true_if_should_flip ? 1 : 0);
    }

    public static native long nstbi_zlib_decode_malloc_guesssize(long var0, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_malloc_guesssize(ByteBuffer buffer, int initial_size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc_guesssize(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), initial_size, MemoryUtil.memAddress((IntBuffer)outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_zlib_decode_malloc_guesssize_headerflag(long var0, int var2, int var3, long var4, int var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_malloc_guesssize_headerflag(ByteBuffer buffer, int initial_size, boolean parse_header) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc_guesssize_headerflag(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), initial_size, MemoryUtil.memAddress((IntBuffer)outlen), parse_header ? 1 : 0);
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_zlib_decode_malloc(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_malloc(ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_malloc(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_zlib_decode_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_buffer(ByteBuffer obuffer, ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_buffer(MemoryUtil.memAddress((ByteBuffer)obuffer), obuffer.remaining(), MemoryUtil.memAddress((ByteBuffer)ibuffer), ibuffer.remaining());
    }

    public static native long nstbi_zlib_decode_noheader_malloc(long var0, int var2, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_zlib_decode_noheader_malloc(ByteBuffer buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer outlen = stack.callocInt(1);
            long __result = STBImage.nstbi_zlib_decode_noheader_malloc(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)outlen));
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)__result, (int)outlen.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_zlib_decode_noheader_buffer(long var0, int var2, long var3, int var5);

    public static int stbi_zlib_decode_noheader_buffer(ByteBuffer obuffer, ByteBuffer ibuffer) {
        return STBImage.nstbi_zlib_decode_noheader_buffer(MemoryUtil.memAddress((ByteBuffer)obuffer), obuffer.remaining(), MemoryUtil.memAddress((ByteBuffer)ibuffer), ibuffer.remaining());
    }

    public static native long nstbi_load(long var0, int[] var2, int[] var3, int[] var4, int var5);

    public static ByteBuffer stbi_load(ByteBuffer filename, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filename), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memByteBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer stbi_load(CharSequence filename, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, channels_in_file, desired_channels);
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_load_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    public static ByteBuffer stbi_load_from_memory(ByteBuffer buffer, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memByteBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_load_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    public static ByteBuffer stbi_load_from_callbacks(STBIIOCallbacks clbk, long user, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_load_from_callbacks(clbk.address(), user, x, y, channels_in_file, desired_channels);
        return MemoryUtil.memByteBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_load_16(long var0, int[] var2, int[] var3, int[] var4, int var5);

    public static ShortBuffer stbi_load_16(ByteBuffer filename, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filename), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memShortBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShortBuffer stbi_load_16(CharSequence filename, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_load_16(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, channels_in_file, desired_channels);
            ShortBuffer shortBuffer = MemoryUtil.memShortBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
            return shortBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_loadf(long var0, int[] var2, int[] var3, int[] var4, int var5);

    public static FloatBuffer stbi_loadf(ByteBuffer filename, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filename), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memFloatBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatBuffer stbi_loadf(CharSequence filename, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            long __result = STBImage.nstbi_loadf(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, channels_in_file, desired_channels);
            FloatBuffer floatBuffer = MemoryUtil.memFloatBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
            return floatBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long nstbi_loadf_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5, int var6);

    public static FloatBuffer stbi_loadf_from_memory(ByteBuffer buffer, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
        }
        long __result = STBImage.nstbi_loadf_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), x, y, channels_in_file, desired_channels);
        return MemoryUtil.memFloatBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native long nstbi_loadf_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6, int var7);

    public static FloatBuffer stbi_loadf_from_callbacks(STBIIOCallbacks clbk, long user, int[] x, int[] y, int[] channels_in_file, int desired_channels) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])channels_in_file, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        long __result = STBImage.nstbi_loadf_from_callbacks(clbk.address(), user, x, y, channels_in_file, desired_channels);
        return MemoryUtil.memFloatBuffer((long)__result, (int)(x[0] * y[0] * (desired_channels != 0 ? desired_channels : channels_in_file[0])));
    }

    public static native int nstbi_info(long var0, int[] var2, int[] var3, int[] var4);

    public static boolean stbi_info(ByteBuffer filename, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)filename);
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
        }
        return STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filename), x, y, comp) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stbi_info(CharSequence filename, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer filenameEncoded = stack.ASCII(filename);
            boolean bl = STBImage.nstbi_info(MemoryUtil.memAddress((ByteBuffer)filenameEncoded), x, y, comp) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nstbi_info_from_memory(long var0, int var2, int[] var3, int[] var4, int[] var5);

    public static boolean stbi_info_from_memory(ByteBuffer buffer, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
        }
        return STBImage.nstbi_info_from_memory(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), x, y, comp) != 0;
    }

    public static native int nstbi_info_from_callbacks(long var0, long var2, int[] var4, int[] var5, int[] var6);

    public static boolean stbi_info_from_callbacks(STBIIOCallbacks clbk, long user, int[] x, int[] y, int[] comp) {
        if (Checks.CHECKS) {
            Checks.check((int[])x, (int)1);
            Checks.check((int[])y, (int)1);
            Checks.check((int[])comp, (int)1);
            STBIIOCallbacks.validate(clbk.address());
        }
        return STBImage.nstbi_info_from_callbacks(clbk.address(), user, x, y, comp) != 0;
    }

    static {
        LibSTB.initialize();
    }
}

