/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_resource_binding_2")
public class SpvcMslResourceBinding2
extends Struct<SpvcMslResourceBinding2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STAGE;
    public static final int DESC_SET;
    public static final int BINDING;
    public static final int COUNT;
    public static final int MSL_BUFFER;
    public static final int MSL_TEXTURE;
    public static final int MSL_SAMPLER;

    protected SpvcMslResourceBinding2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcMslResourceBinding2 create(long address, @Nullable ByteBuffer container) {
        return new SpvcMslResourceBinding2(address, container);
    }

    public SpvcMslResourceBinding2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcMslResourceBinding2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvExecutionModel")
    public int stage() {
        return SpvcMslResourceBinding2.nstage(this.address());
    }

    @NativeType(value="unsigned int")
    public int desc_set() {
        return SpvcMslResourceBinding2.ndesc_set(this.address());
    }

    @NativeType(value="unsigned int")
    public int binding() {
        return SpvcMslResourceBinding2.nbinding(this.address());
    }

    @NativeType(value="unsigned int")
    public int count() {
        return SpvcMslResourceBinding2.ncount(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_buffer() {
        return SpvcMslResourceBinding2.nmsl_buffer(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_texture() {
        return SpvcMslResourceBinding2.nmsl_texture(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_sampler() {
        return SpvcMslResourceBinding2.nmsl_sampler(this.address());
    }

    public SpvcMslResourceBinding2 stage(@NativeType(value="SpvExecutionModel") int value) {
        SpvcMslResourceBinding2.nstage(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding2 desc_set(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding2.ndesc_set(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding2 binding(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding2.nbinding(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding2 count(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding2.ncount(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding2 msl_buffer(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding2.nmsl_buffer(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding2 msl_texture(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding2.nmsl_texture(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding2 msl_sampler(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding2.nmsl_sampler(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding2 set(int stage, int desc_set, int binding, int count, int msl_buffer, int msl_texture, int msl_sampler) {
        this.stage(stage);
        this.desc_set(desc_set);
        this.binding(binding);
        this.count(count);
        this.msl_buffer(msl_buffer);
        this.msl_texture(msl_texture);
        this.msl_sampler(msl_sampler);
        return this;
    }

    public SpvcMslResourceBinding2 set(SpvcMslResourceBinding2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcMslResourceBinding2 malloc() {
        return new SpvcMslResourceBinding2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcMslResourceBinding2 calloc() {
        return new SpvcMslResourceBinding2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcMslResourceBinding2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcMslResourceBinding2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcMslResourceBinding2 create(long address) {
        return new SpvcMslResourceBinding2(address, null);
    }

    public static @Nullable SpvcMslResourceBinding2 createSafe(long address) {
        return address == 0L ? null : new SpvcMslResourceBinding2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcMslResourceBinding2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslResourceBinding2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcMslResourceBinding2 malloc(MemoryStack stack) {
        return new SpvcMslResourceBinding2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcMslResourceBinding2 calloc(MemoryStack stack) {
        return new SpvcMslResourceBinding2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstage(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STAGE));
    }

    public static int ndesc_set(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DESC_SET));
    }

    public static int nbinding(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BINDING));
    }

    public static int ncount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COUNT));
    }

    public static int nmsl_buffer(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MSL_BUFFER));
    }

    public static int nmsl_texture(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MSL_TEXTURE));
    }

    public static int nmsl_sampler(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MSL_SAMPLER));
    }

    public static void nstage(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STAGE), (int)value);
    }

    public static void ndesc_set(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DESC_SET), (int)value);
    }

    public static void nbinding(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BINDING), (int)value);
    }

    public static void ncount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COUNT), (int)value);
    }

    public static void nmsl_buffer(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MSL_BUFFER), (int)value);
    }

    public static void nmsl_texture(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MSL_TEXTURE), (int)value);
    }

    public static void nmsl_sampler(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MSL_SAMPLER), (int)value);
    }

    static {
        Struct.Layout layout = SpvcMslResourceBinding2.__struct((Struct.Member[])new Struct.Member[]{SpvcMslResourceBinding2.__member((int)4), SpvcMslResourceBinding2.__member((int)4), SpvcMslResourceBinding2.__member((int)4), SpvcMslResourceBinding2.__member((int)4), SpvcMslResourceBinding2.__member((int)4), SpvcMslResourceBinding2.__member((int)4), SpvcMslResourceBinding2.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STAGE = layout.offsetof(0);
        DESC_SET = layout.offsetof(1);
        BINDING = layout.offsetof(2);
        COUNT = layout.offsetof(3);
        MSL_BUFFER = layout.offsetof(4);
        MSL_TEXTURE = layout.offsetof(5);
        MSL_SAMPLER = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslResourceBinding2, Buffer>
    implements NativeResource {
        private static final SpvcMslResourceBinding2 ELEMENT_FACTORY = SpvcMslResourceBinding2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SpvcMslResourceBinding2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvExecutionModel")
        public int stage() {
            return SpvcMslResourceBinding2.nstage(this.address());
        }

        @NativeType(value="unsigned int")
        public int desc_set() {
            return SpvcMslResourceBinding2.ndesc_set(this.address());
        }

        @NativeType(value="unsigned int")
        public int binding() {
            return SpvcMslResourceBinding2.nbinding(this.address());
        }

        @NativeType(value="unsigned int")
        public int count() {
            return SpvcMslResourceBinding2.ncount(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_buffer() {
            return SpvcMslResourceBinding2.nmsl_buffer(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_texture() {
            return SpvcMslResourceBinding2.nmsl_texture(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_sampler() {
            return SpvcMslResourceBinding2.nmsl_sampler(this.address());
        }

        public Buffer stage(@NativeType(value="SpvExecutionModel") int value) {
            SpvcMslResourceBinding2.nstage(this.address(), value);
            return this;
        }

        public Buffer desc_set(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding2.ndesc_set(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding2.nbinding(this.address(), value);
            return this;
        }

        public Buffer count(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding2.ncount(this.address(), value);
            return this;
        }

        public Buffer msl_buffer(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding2.nmsl_buffer(this.address(), value);
            return this;
        }

        public Buffer msl_texture(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding2.nmsl_texture(this.address(), value);
            return this;
        }

        public Buffer msl_sampler(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding2.nmsl_sampler(this.address(), value);
            return this;
        }
    }
}

