/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.spvc.SpvcReflectedResource;

@NativeType(value="struct spvc_reflected_builtin_resource")
public class SpvcReflectedBuiltinResource
extends Struct<SpvcReflectedBuiltinResource>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUILTIN;
    public static final int VALUE_TYPE_ID;
    public static final int RESOURCE;

    protected SpvcReflectedBuiltinResource(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcReflectedBuiltinResource create(long address, @Nullable ByteBuffer container) {
        return new SpvcReflectedBuiltinResource(address, container);
    }

    public SpvcReflectedBuiltinResource(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcReflectedBuiltinResource.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvBuiltIn")
    public int builtin() {
        return SpvcReflectedBuiltinResource.nbuiltin(this.address());
    }

    @NativeType(value="spvc_type_id")
    public int value_type_id() {
        return SpvcReflectedBuiltinResource.nvalue_type_id(this.address());
    }

    @NativeType(value="spvc_reflected_resource")
    public SpvcReflectedResource resource() {
        return SpvcReflectedBuiltinResource.nresource(this.address());
    }

    public SpvcReflectedBuiltinResource builtin(@NativeType(value="SpvBuiltIn") int value) {
        SpvcReflectedBuiltinResource.nbuiltin(this.address(), value);
        return this;
    }

    public SpvcReflectedBuiltinResource value_type_id(@NativeType(value="spvc_type_id") int value) {
        SpvcReflectedBuiltinResource.nvalue_type_id(this.address(), value);
        return this;
    }

    public SpvcReflectedBuiltinResource resource(@NativeType(value="spvc_reflected_resource") SpvcReflectedResource value) {
        SpvcReflectedBuiltinResource.nresource(this.address(), value);
        return this;
    }

    public SpvcReflectedBuiltinResource resource(Consumer<SpvcReflectedResource> consumer) {
        consumer.accept(this.resource());
        return this;
    }

    public SpvcReflectedBuiltinResource set(int builtin, int value_type_id, SpvcReflectedResource resource) {
        this.builtin(builtin);
        this.value_type_id(value_type_id);
        this.resource(resource);
        return this;
    }

    public SpvcReflectedBuiltinResource set(SpvcReflectedBuiltinResource src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcReflectedBuiltinResource malloc() {
        return new SpvcReflectedBuiltinResource(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcReflectedBuiltinResource calloc() {
        return new SpvcReflectedBuiltinResource(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcReflectedBuiltinResource create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcReflectedBuiltinResource(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcReflectedBuiltinResource create(long address) {
        return new SpvcReflectedBuiltinResource(address, null);
    }

    @Nullable
    public static SpvcReflectedBuiltinResource createSafe(long address) {
        return address == 0L ? null : new SpvcReflectedBuiltinResource(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcReflectedBuiltinResource.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcReflectedBuiltinResource.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcReflectedBuiltinResource malloc(MemoryStack stack) {
        return new SpvcReflectedBuiltinResource(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcReflectedBuiltinResource calloc(MemoryStack stack) {
        return new SpvcReflectedBuiltinResource(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbuiltin(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUILTIN);
    }

    public static int nvalue_type_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)VALUE_TYPE_ID);
    }

    public static SpvcReflectedResource nresource(long struct) {
        return SpvcReflectedResource.create(struct + (long)RESOURCE);
    }

    public static void nbuiltin(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUILTIN, value);
    }

    public static void nvalue_type_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VALUE_TYPE_ID, value);
    }

    public static void nresource(long struct, SpvcReflectedResource value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RESOURCE), (long)SpvcReflectedResource.SIZEOF);
    }

    public static void validate(long struct) {
        SpvcReflectedResource.validate(struct + (long)RESOURCE);
    }

    static {
        Struct.Layout layout = SpvcReflectedBuiltinResource.__struct((Struct.Member[])new Struct.Member[]{SpvcReflectedBuiltinResource.__member((int)4), SpvcReflectedBuiltinResource.__member((int)4), SpvcReflectedBuiltinResource.__member((int)SpvcReflectedResource.SIZEOF, (int)SpvcReflectedResource.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUILTIN = layout.offsetof(0);
        VALUE_TYPE_ID = layout.offsetof(1);
        RESOURCE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SpvcReflectedBuiltinResource, Buffer>
    implements NativeResource {
        private static final SpvcReflectedBuiltinResource ELEMENT_FACTORY = SpvcReflectedBuiltinResource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcReflectedBuiltinResource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvBuiltIn")
        public int builtin() {
            return SpvcReflectedBuiltinResource.nbuiltin(this.address());
        }

        @NativeType(value="spvc_type_id")
        public int value_type_id() {
            return SpvcReflectedBuiltinResource.nvalue_type_id(this.address());
        }

        @NativeType(value="spvc_reflected_resource")
        public SpvcReflectedResource resource() {
            return SpvcReflectedBuiltinResource.nresource(this.address());
        }

        public Buffer builtin(@NativeType(value="SpvBuiltIn") int value) {
            SpvcReflectedBuiltinResource.nbuiltin(this.address(), value);
            return this;
        }

        public Buffer value_type_id(@NativeType(value="spvc_type_id") int value) {
            SpvcReflectedBuiltinResource.nvalue_type_id(this.address(), value);
            return this;
        }

        public Buffer resource(@NativeType(value="spvc_reflected_resource") SpvcReflectedResource value) {
            SpvcReflectedBuiltinResource.nresource(this.address(), value);
            return this;
        }

        public Buffer resource(Consumer<SpvcReflectedResource> consumer) {
            consumer.accept(this.resource());
            return this;
        }
    }
}

