/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.par.ParSLPosition;

@NativeType(value="struct parsl_spine_list")
public class ParSLSpineList
extends Struct<ParSLSpineList>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUM_VERTICES;
    public static final int NUM_SPINES;
    public static final int VERTICES;
    public static final int SPINE_LENGTHS;
    public static final int CLOSED;

    protected ParSLSpineList(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ParSLSpineList create(long address, @Nullable ByteBuffer container) {
        return new ParSLSpineList(address, container);
    }

    public ParSLSpineList(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParSLSpineList.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int num_vertices() {
        return ParSLSpineList.nnum_vertices(this.address());
    }

    @NativeType(value="uint16_t")
    public short num_spines() {
        return ParSLSpineList.nnum_spines(this.address());
    }

    @NativeType(value="parsl_position *")
    public ParSLPosition.Buffer vertices() {
        return ParSLSpineList.nvertices(this.address());
    }

    @NativeType(value="uint16_t *")
    public ShortBuffer spine_lengths() {
        return ParSLSpineList.nspine_lengths(this.address());
    }

    @NativeType(value="bool")
    public boolean closed() {
        return ParSLSpineList.nclosed(this.address());
    }

    public ParSLSpineList vertices(@NativeType(value="parsl_position *") ParSLPosition.Buffer value) {
        ParSLSpineList.nvertices(this.address(), value);
        return this;
    }

    public ParSLSpineList spine_lengths(@NativeType(value="uint16_t *") ShortBuffer value) {
        ParSLSpineList.nspine_lengths(this.address(), value);
        return this;
    }

    public ParSLSpineList closed(@NativeType(value="bool") boolean value) {
        ParSLSpineList.nclosed(this.address(), value);
        return this;
    }

    public ParSLSpineList set(ParSLPosition.Buffer vertices, ShortBuffer spine_lengths, boolean closed) {
        this.vertices(vertices);
        this.spine_lengths(spine_lengths);
        this.closed(closed);
        return this;
    }

    public ParSLSpineList set(ParSLSpineList src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ParSLSpineList malloc() {
        return new ParSLSpineList(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ParSLSpineList calloc() {
        return new ParSLSpineList(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ParSLSpineList create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ParSLSpineList(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ParSLSpineList create(long address) {
        return new ParSLSpineList(address, null);
    }

    public static @Nullable ParSLSpineList createSafe(long address) {
        return address == 0L ? null : new ParSLSpineList(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ParSLSpineList.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ParSLSpineList.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ParSLSpineList mallocStack() {
        return ParSLSpineList.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLSpineList callocStack() {
        return ParSLSpineList.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ParSLSpineList mallocStack(MemoryStack stack) {
        return ParSLSpineList.malloc(stack);
    }

    @Deprecated
    public static ParSLSpineList callocStack(MemoryStack stack) {
        return ParSLSpineList.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ParSLSpineList.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ParSLSpineList.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ParSLSpineList.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ParSLSpineList.calloc(capacity, stack);
    }

    public static ParSLSpineList malloc(MemoryStack stack) {
        return new ParSLSpineList(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ParSLSpineList calloc(MemoryStack stack) {
        return new ParSLSpineList(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnum_vertices(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_VERTICES));
    }

    public static short nnum_spines(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)NUM_SPINES));
    }

    public static ParSLPosition.Buffer nvertices(long struct) {
        return ParSLPosition.create(MemoryUtil.memGetAddress((long)(struct + (long)VERTICES)), ParSLSpineList.nnum_vertices(struct));
    }

    public static ShortBuffer nspine_lengths(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SPINE_LENGTHS)), (int)Short.toUnsignedInt(ParSLSpineList.nnum_spines(struct)));
    }

    public static boolean nclosed(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CLOSED)) != 0;
    }

    public static void nnum_vertices(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUM_VERTICES), (int)value);
    }

    public static void nnum_spines(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)NUM_SPINES), (short)value);
    }

    public static void nvertices(long struct, ParSLPosition.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VERTICES), (long)value.address());
        ParSLSpineList.nnum_vertices(struct, value.remaining());
    }

    public static void nspine_lengths(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPINE_LENGTHS), (long)MemoryUtil.memAddress((ShortBuffer)value));
        ParSLSpineList.nnum_spines(struct, (short)value.remaining());
    }

    public static void nclosed(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)CLOSED), (byte)(value ? (byte)1 : 0));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VERTICES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPINE_LENGTHS)));
    }

    static {
        Struct.Layout layout = ParSLSpineList.__struct((Struct.Member[])new Struct.Member[]{ParSLSpineList.__member((int)4), ParSLSpineList.__member((int)2), ParSLSpineList.__member((int)POINTER_SIZE), ParSLSpineList.__member((int)POINTER_SIZE), ParSLSpineList.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUM_VERTICES = layout.offsetof(0);
        NUM_SPINES = layout.offsetof(1);
        VERTICES = layout.offsetof(2);
        SPINE_LENGTHS = layout.offsetof(3);
        CLOSED = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<ParSLSpineList, Buffer>
    implements NativeResource {
        private static final ParSLSpineList ELEMENT_FACTORY = ParSLSpineList.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ParSLSpineList getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int num_vertices() {
            return ParSLSpineList.nnum_vertices(this.address());
        }

        @NativeType(value="uint16_t")
        public short num_spines() {
            return ParSLSpineList.nnum_spines(this.address());
        }

        @NativeType(value="parsl_position *")
        public ParSLPosition.Buffer vertices() {
            return ParSLSpineList.nvertices(this.address());
        }

        @NativeType(value="uint16_t *")
        public ShortBuffer spine_lengths() {
            return ParSLSpineList.nspine_lengths(this.address());
        }

        @NativeType(value="bool")
        public boolean closed() {
            return ParSLSpineList.nclosed(this.address());
        }

        public Buffer vertices(@NativeType(value="parsl_position *") ParSLPosition.Buffer value) {
            ParSLSpineList.nvertices(this.address(), value);
            return this;
        }

        public Buffer spine_lengths(@NativeType(value="uint16_t *") ShortBuffer value) {
            ParSLSpineList.nspine_lengths(this.address(), value);
            return this;
        }

        public Buffer closed(@NativeType(value="bool") boolean value) {
            ParSLSpineList.nclosed(this.address(), value);
            return this;
        }
    }
}

