/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.par.ParSLAnnotation;
import org.lwjgl.util.par.ParSLPosition;

@NativeType(value="struct parsl_mesh")
public class ParSLMesh
extends Struct<ParSLMesh> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUM_VERTICES;
    public static final int NUM_TRIANGLES;
    public static final int TRIANGLE_INDICES;
    public static final int POSITIONS;
    public static final int ANNOTATIONS;
    public static final int SPINE_LENGTHS;
    public static final int RANDOM_OFFSETS;

    protected ParSLMesh(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ParSLMesh create(long address, @Nullable ByteBuffer container) {
        return new ParSLMesh(address, container);
    }

    public ParSLMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParSLMesh.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int num_vertices() {
        return ParSLMesh.nnum_vertices(this.address());
    }

    @NativeType(value="uint32_t")
    public int num_triangles() {
        return ParSLMesh.nnum_triangles(this.address());
    }

    @NativeType(value="uint32_t *")
    public IntBuffer triangle_indices(int capacity) {
        return ParSLMesh.ntriangle_indices(this.address(), capacity);
    }

    @NativeType(value="parsl_position *")
    public ParSLPosition.Buffer positions() {
        return ParSLMesh.npositions(this.address());
    }

    @NativeType(value="parsl_annotation *")
    public @Nullable ParSLAnnotation.Buffer annotations() {
        return ParSLMesh.nannotations(this.address());
    }

    @NativeType(value="float *")
    public @Nullable FloatBuffer spine_lengths() {
        return ParSLMesh.nspine_lengths(this.address());
    }

    @NativeType(value="float *")
    public @Nullable FloatBuffer random_offsets() {
        return ParSLMesh.nrandom_offsets(this.address());
    }

    public static ParSLMesh create(long address) {
        return new ParSLMesh(address, null);
    }

    public static @Nullable ParSLMesh createSafe(long address) {
        return address == 0L ? null : new ParSLMesh(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nnum_vertices(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_VERTICES));
    }

    public static int nnum_triangles(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_TRIANGLES));
    }

    public static IntBuffer ntriangle_indices(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)TRIANGLE_INDICES)), (int)capacity);
    }

    public static ParSLPosition.Buffer npositions(long struct) {
        return ParSLPosition.create(MemoryUtil.memGetAddress((long)(struct + (long)POSITIONS)), ParSLMesh.nnum_vertices(struct));
    }

    public static @Nullable ParSLAnnotation.Buffer nannotations(long struct) {
        return ParSLAnnotation.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ANNOTATIONS)), ParSLMesh.nnum_vertices(struct));
    }

    public static @Nullable FloatBuffer nspine_lengths(long struct) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)SPINE_LENGTHS)), (int)ParSLMesh.nnum_vertices(struct));
    }

    public static @Nullable FloatBuffer nrandom_offsets(long struct) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)RANDOM_OFFSETS)), (int)ParSLMesh.nnum_vertices(struct));
    }

    static {
        Struct.Layout layout = ParSLMesh.__struct((Struct.Member[])new Struct.Member[]{ParSLMesh.__member((int)4), ParSLMesh.__member((int)4), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUM_VERTICES = layout.offsetof(0);
        NUM_TRIANGLES = layout.offsetof(1);
        TRIANGLE_INDICES = layout.offsetof(2);
        POSITIONS = layout.offsetof(3);
        ANNOTATIONS = layout.offsetof(4);
        SPINE_LENGTHS = layout.offsetof(5);
        RANDOM_OFFSETS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ParSLMesh, Buffer> {
        private static final ParSLMesh ELEMENT_FACTORY = ParSLMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ParSLMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int num_vertices() {
            return ParSLMesh.nnum_vertices(this.address());
        }

        @NativeType(value="uint32_t")
        public int num_triangles() {
            return ParSLMesh.nnum_triangles(this.address());
        }

        @NativeType(value="uint32_t *")
        public IntBuffer triangle_indices(int capacity) {
            return ParSLMesh.ntriangle_indices(this.address(), capacity);
        }

        @NativeType(value="parsl_position *")
        public ParSLPosition.Buffer positions() {
            return ParSLMesh.npositions(this.address());
        }

        @NativeType(value="parsl_annotation *")
        public @Nullable ParSLAnnotation.Buffer annotations() {
            return ParSLMesh.nannotations(this.address());
        }

        @NativeType(value="float *")
        public @Nullable FloatBuffer spine_lengths() {
            return ParSLMesh.nspine_lengths(this.address());
        }

        @NativeType(value="float *")
        public @Nullable FloatBuffer random_offsets() {
            return ParSLMesh.nrandom_offsets(this.address());
        }
    }
}

