/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL22;
import org.lwjgl.opencl.CLContextDestructorCallbackI;
import org.lwjgl.opencl.CLImageDesc;
import org.lwjgl.opencl.CLImageFormat;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CL30
extends CL22 {
    public static final int CL_VERSION_3_0 = 1;
    public static final int CL_PLATFORM_NUMERIC_VERSION = 2310;
    public static final int CL_PLATFORM_EXTENSIONS_WITH_VERSION = 2311;
    public static final int CL_DEVICE_NUMERIC_VERSION = 4190;
    public static final int CL_DEVICE_EXTENSIONS_WITH_VERSION = 4192;
    public static final int CL_DEVICE_ILS_WITH_VERSION = 4193;
    public static final int CL_DEVICE_BUILT_IN_KERNELS_WITH_VERSION = 4194;
    public static final int CL_DEVICE_ATOMIC_MEMORY_CAPABILITIES = 4195;
    public static final int CL_DEVICE_ATOMIC_FENCE_CAPABILITIES = 4196;
    public static final int CL_DEVICE_NON_UNIFORM_WORK_GROUP_SUPPORT = 4197;
    public static final int CL_DEVICE_OPENCL_C_ALL_VERSIONS = 4198;
    public static final int CL_DEVICE_PREFERRED_WORK_GROUP_SIZE_MULTIPLE = 4199;
    public static final int CL_DEVICE_WORK_GROUP_COLLECTIVE_FUNCTIONS_SUPPORT = 4200;
    public static final int CL_DEVICE_GENERIC_ADDRESS_SPACE_SUPPORT = 4201;
    public static final int CL_DEVICE_OPENCL_C_FEATURES = 4207;
    public static final int CL_DEVICE_DEVICE_ENQUEUE_CAPABILITIES = 4208;
    public static final int CL_DEVICE_PIPE_SUPPORT = 4209;
    public static final int CL_DEVICE_LATEST_CONFORMANCE_VERSION_PASSED = 4210;
    public static final int CL_QUEUE_PROPERTIES_ARRAY = 4248;
    public static final int CL_MEM_PROPERTIES = 4362;
    public static final int CL_PIPE_PROPERTIES = 4386;
    public static final int CL_SAMPLER_PROPERTIES = 4440;
    public static final int CL_COMMAND_SVM_MIGRATE_MEM = 4622;
    public static final int CL_DEVICE_ATOMIC_ORDER_RELAXED = 1;
    public static final int CL_DEVICE_ATOMIC_ORDER_ACQ_REL = 2;
    public static final int CL_DEVICE_ATOMIC_ORDER_SEQ_CST = 4;
    public static final int CL_DEVICE_ATOMIC_SCOPE_WORK_ITEM = 8;
    public static final int CL_DEVICE_ATOMIC_SCOPE_WORK_GROUP = 16;
    public static final int CL_DEVICE_ATOMIC_SCOPE_DEVICE = 32;
    public static final int CL_DEVICE_ATOMIC_SCOPE_ALL_DEVICES = 64;
    public static final int CL_DEVICE_QUEUE_SUPPORTED = 1;
    public static final int CL_DEVICE_QUEUE_REPLACEABLE_DEFAULT = 2;
    public static final int CL_VERSION_MAJOR_BITS = 10;
    public static final int CL_VERSION_MINOR_BITS = 10;
    public static final int CL_VERSION_PATCH_BITS = 12;
    public static final int CL_VERSION_MAJOR_MASK = 1023;
    public static final int CL_VERSION_MINOR_MASK = 1023;
    public static final int CL_VERSION_PATCH_MASK = 4095;

    protected CL30() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="uint32_t")
    public static int CL_VERSION_MAJOR(@NativeType(value="uint32_t") int version) {
        return version >>> 22;
    }

    @NativeType(value="uint32_t")
    public static int CL_VERSION_MINOR(@NativeType(value="uint32_t") int version) {
        return version >>> 12 & 0x3FF;
    }

    @NativeType(value="uint32_t")
    public static int CL_VERSION_PATCH(@NativeType(value="uint32_t") int version) {
        return version & 0xFFF;
    }

    @NativeType(value="uint32_t")
    public static int CL_MAKE_VERSION(@NativeType(value="uint32_t") int major, @NativeType(value="uint32_t") int minor, @NativeType(value="uint32_t") int patch) {
        return (major & 0x3FF) << 22 | (minor & 0x3FF) << 12 | patch & 0xFFF;
    }

    public static int nclSetContextDestructorCallback(long context, long pfn_notify, long user_data) {
        long __functionAddress = CL.getICD().clSetContextDestructorCallback;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPPI((long)context, (long)pfn_notify, (long)user_data, (long)__functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clSetContextDestructorCallback(@NativeType(value="cl_context") long context, @NativeType(value="void (*) (cl_context, void *)") CLContextDestructorCallbackI pfn_notify, @NativeType(value="void *") long user_data) {
        return CL30.nclSetContextDestructorCallback(context, pfn_notify.address(), user_data);
    }

    public static long nclCreateBufferWithProperties(long context, long properties, long flags, long size, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBufferWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPJPPPP((long)context, (long)properties, (long)flags, (long)size, (long)host_ptr, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="size_t") long size, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateBufferWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, size, 0L, MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ByteBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateBufferWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, host_ptr.remaining(), MemoryUtil.memAddress((ByteBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ShortBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateBufferWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, Integer.toUnsignedLong(host_ptr.remaining()) << 1, MemoryUtil.memAddress((ShortBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") IntBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateBufferWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, Integer.toUnsignedLong(host_ptr.remaining()) << 2, MemoryUtil.memAddress((IntBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") FloatBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateBufferWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, Integer.toUnsignedLong(host_ptr.remaining()) << 2, MemoryUtil.memAddress((FloatBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") DoubleBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateBufferWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, Integer.toUnsignedLong(host_ptr.remaining()) << 3, MemoryUtil.memAddress((DoubleBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    public static long nclCreateImageWithProperties(long context, long properties, long flags, long image_format, long image_desc, long host_ptr, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImageWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
        }
        return JNI.callPPJPPPPP((long)context, (long)properties, (long)flags, (long)image_format, (long)image_desc, (long)host_ptr, (long)errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") @Nullable ByteBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateImageWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe((ByteBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") @Nullable ShortBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateImageWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe((ShortBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") @Nullable IntBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateImageWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe((IntBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") @Nullable LongBuffer properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") @Nullable FloatBuffer host_ptr, @NativeType(value="cl_int *") @Nullable IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((LongBuffer)properties);
            Checks.checkSafe((Buffer)errcode_ret, (int)1);
        }
        return CL30.nclCreateImageWithProperties(context, MemoryUtil.memAddressSafe((LongBuffer)properties), flags, image_format.address(), image_desc.address(), MemoryUtil.memAddressSafe((FloatBuffer)host_ptr), MemoryUtil.memAddressSafe((IntBuffer)errcode_ret));
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") ByteBuffer host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBufferWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPP((long)context, (long[])properties, (long)flags, (long)host_ptr.remaining(), (long)MemoryUtil.memAddress((ByteBuffer)host_ptr), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") short[] host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBufferWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPP((long)context, (long[])properties, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 1), (short[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") int[] host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBufferWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPP((long)context, (long[])properties, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 2), (int[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") float[] host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBufferWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPP((long)context, (long[])properties, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 2), (float[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateBufferWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="void *") double[] host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateBufferWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPP((long)context, (long[])properties, (long)flags, (long)(Integer.toUnsignedLong(host_ptr.length) << 3), (double[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") @Nullable ByteBuffer host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImageWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPPP((long)context, (long[])properties, (long)flags, (long)image_format.address(), (long)image_desc.address(), (long)MemoryUtil.memAddressSafe((ByteBuffer)host_ptr), (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") short @Nullable [] host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImageWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPPP((long)context, (long[])properties, (long)flags, (long)image_format.address(), (long)image_desc.address(), (short[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") int @Nullable [] host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImageWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPPP((long)context, (long[])properties, (long)flags, (long)image_format.address(), (long)image_desc.address(), (int[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }

    @NativeType(value="cl_mem")
    public static long clCreateImageWithProperties(@NativeType(value="cl_context") long context, @NativeType(value="cl_mem_properties const *") long @Nullable [] properties, @NativeType(value="cl_mem_flags") long flags, @NativeType(value="cl_image_format const *") CLImageFormat image_format, @NativeType(value="cl_image_desc const *") CLImageDesc image_desc, @NativeType(value="void *") float @Nullable [] host_ptr, @NativeType(value="cl_int *") int @Nullable [] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateImageWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)context);
            Checks.checkNTSafe((long[])properties);
            Checks.checkSafe((int[])errcode_ret, (int)1);
        }
        return JNI.callPPJPPPPP((long)context, (long[])properties, (long)flags, (long)image_format.address(), (long)image_desc.address(), (float[])host_ptr, (int[])errcode_ret, (long)__functionAddress);
    }
}

