/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLMemEXTHostPtr
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCATION_TYPE;
    public static final int HOST_CACHE_POLICY;

    CLMemEXTHostPtr(long address, ByteBuffer container) {
        super(address, container);
    }

    public CLMemEXTHostPtr(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), CLMemEXTHostPtr.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int allocation_type() {
        return CLMemEXTHostPtr.nallocation_type(this.address());
    }

    public int host_cache_policy() {
        return CLMemEXTHostPtr.nhost_cache_policy(this.address());
    }

    public CLMemEXTHostPtr allocation_type(int value) {
        CLMemEXTHostPtr.nallocation_type(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr host_cache_policy(int value) {
        CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
        return this;
    }

    public CLMemEXTHostPtr set(int allocation_type, int host_cache_policy) {
        this.allocation_type(allocation_type);
        this.host_cache_policy(host_cache_policy);
        return this;
    }

    public CLMemEXTHostPtr set(CLMemEXTHostPtr src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (int)SIZEOF);
        return this;
    }

    public static CLMemEXTHostPtr malloc() {
        return CLMemEXTHostPtr.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static CLMemEXTHostPtr calloc() {
        return CLMemEXTHostPtr.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static CLMemEXTHostPtr create() {
        return new CLMemEXTHostPtr(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static CLMemEXTHostPtr create(long address) {
        return address == 0L ? null : new CLMemEXTHostPtr(address, null);
    }

    public static Buffer malloc(int capacity) {
        return CLMemEXTHostPtr.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLMemEXTHostPtr.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static CLMemEXTHostPtr mallocStack() {
        return CLMemEXTHostPtr.mallocStack(MemoryStack.stackGet());
    }

    public static CLMemEXTHostPtr callocStack() {
        return CLMemEXTHostPtr.callocStack(MemoryStack.stackGet());
    }

    public static CLMemEXTHostPtr mallocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLMemEXTHostPtr callocStack(MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return CLMemEXTHostPtr.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return CLMemEXTHostPtr.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CLMemEXTHostPtr.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nallocation_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ALLOCATION_TYPE));
    }

    public static int nhost_cache_policy(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HOST_CACHE_POLICY));
    }

    public static void nallocation_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ALLOCATION_TYPE), (int)value);
    }

    public static void nhost_cache_policy(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HOST_CACHE_POLICY), (int)value);
    }

    static {
        Struct.Layout layout = CLMemEXTHostPtr.__struct((Struct.Member[])new Struct.Member[]{CLMemEXTHostPtr.__member((int)4), CLMemEXTHostPtr.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCATION_TYPE = layout.offsetof(0);
        HOST_CACHE_POLICY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLMemEXTHostPtr, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected CLMemEXTHostPtr newInstance(long address) {
            return new CLMemEXTHostPtr(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public int allocation_type() {
            return CLMemEXTHostPtr.nallocation_type(this.address());
        }

        public int host_cache_policy() {
            return CLMemEXTHostPtr.nhost_cache_policy(this.address());
        }

        public Buffer allocation_type(int value) {
            CLMemEXTHostPtr.nallocation_type(this.address(), value);
            return this;
        }

        public Buffer host_cache_policy(int value) {
            CLMemEXTHostPtr.nhost_cache_policy(this.address(), value);
            return this;
        }
    }
}

