/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTStaticBuffer {
    protected EXTStaticBuffer() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.alBufferDataStatic});
    }

    public static void nalBufferDataStatic(int buffer, int format, long data, int len, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.invokePV((long)__functionAddress, (int)buffer, (int)format, (long)data, (int)len, (int)freq);
    }

    public static void alBufferDataStatic(int buffer, int format, ByteBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), freq);
    }

    public static void alBufferDataStatic(int buffer, int format, ShortBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress((ShortBuffer)data), data.remaining() << 1, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, IntBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress((IntBuffer)data), data.remaining() << 2, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, FloatBuffer data, int freq) {
        EXTStaticBuffer.nalBufferDataStatic(buffer, format, MemoryUtil.memAddress((FloatBuffer)data), data.remaining() << 2, freq);
    }

    public static void alBufferDataStatic(int buffer, int format, short[] data, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.invokePV((long)__functionAddress, (int)buffer, (int)format, (short[])data, (int)(data.length << 1), (int)freq);
    }

    public static void alBufferDataStatic(int buffer, int format, int[] data, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.invokePV((long)__functionAddress, (int)buffer, (int)format, (int[])data, (int)(data.length << 2), (int)freq);
    }

    public static void alBufferDataStatic(int buffer, int format, float[] data, int freq) {
        long __functionAddress = AL.getCapabilities().alBufferDataStatic;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress((long)__functionAddress);
        }
        JNI.invokePV((long)__functionAddress, (int)buffer, (int)format, (float[])data, (int)(data.length << 2), (int)freq);
    }
}

