/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ALC10 {
    public static final int ALC_INVALID = -1;
    public static final int ALC_FALSE = 0;
    public static final int ALC_TRUE = 1;
    public static final int ALC_FREQUENCY = 4103;
    public static final int ALC_REFRESH = 4104;
    public static final int ALC_SYNC = 4105;
    public static final int ALC_NO_ERROR = 0;
    public static final int ALC_INVALID_DEVICE = 40961;
    public static final int ALC_INVALID_CONTEXT = 40962;
    public static final int ALC_INVALID_ENUM = 40963;
    public static final int ALC_INVALID_VALUE = 40964;
    public static final int ALC_OUT_OF_MEMORY = 40965;
    public static final int ALC_DEFAULT_DEVICE_SPECIFIER = 4100;
    public static final int ALC_DEVICE_SPECIFIER = 4101;
    public static final int ALC_EXTENSIONS = 4102;
    public static final int ALC_MAJOR_VERSION = 4096;
    public static final int ALC_MINOR_VERSION = 4097;
    public static final int ALC_ATTRIBUTES_SIZE = 4098;
    public static final int ALC_ALL_ATTRIBUTES = 4099;

    protected ALC10() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(ALCCapabilities caps) {
        return Checks.checkFunctions((long[])new long[]{caps.alcOpenDevice, caps.alcCloseDevice, caps.alcCreateContext, caps.alcMakeContextCurrent, caps.alcProcessContext, caps.alcSuspendContext, caps.alcDestroyContext, caps.alcGetCurrentContext, caps.alcGetContextsDevice, caps.alcIsExtensionPresent, caps.alcGetProcAddress, caps.alcGetEnumValue, caps.alcGetError, caps.alcGetString, caps.alcGetIntegerv});
    }

    public static long nalcOpenDevice(long deviceSpecifier) {
        long __functionAddress = ALC.getICD().alcOpenDevice;
        return JNI.invokePP((long)__functionAddress, (long)deviceSpecifier);
    }

    public static long alcOpenDevice(ByteBuffer deviceSpecifier) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)deviceSpecifier);
        }
        return ALC10.nalcOpenDevice(MemoryUtil.memAddressSafe((ByteBuffer)deviceSpecifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alcOpenDevice(CharSequence deviceSpecifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer deviceSpecifierEncoded = stack.UTF8(deviceSpecifier);
            long l = ALC10.nalcOpenDevice(MemoryUtil.memAddressSafe((ByteBuffer)deviceSpecifierEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean alcCloseDevice(long deviceHandle) {
        long __functionAddress = ALC.getICD().alcCloseDevice;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)deviceHandle);
        }
        return JNI.invokePZ((long)__functionAddress, (long)deviceHandle);
    }

    public static long nalcCreateContext(long deviceHandle, long attrList) {
        long __functionAddress = ALC.getICD().alcCreateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)deviceHandle);
        }
        return JNI.invokePPP((long)__functionAddress, (long)deviceHandle, (long)attrList);
    }

    public static long alcCreateContext(long deviceHandle, IntBuffer attrList) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrList);
        }
        return ALC10.nalcCreateContext(deviceHandle, MemoryUtil.memAddressSafe((IntBuffer)attrList));
    }

    public static boolean alcMakeContextCurrent(long context) {
        long __functionAddress = ALC.getICD().alcMakeContextCurrent;
        return JNI.invokePZ((long)__functionAddress, (long)context);
    }

    public static void alcProcessContext(long context) {
        long __functionAddress = ALC.getICD().alcProcessContext;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)context);
        }
        JNI.invokePV((long)__functionAddress, (long)context);
    }

    public static void alcSuspendContext(long context) {
        long __functionAddress = ALC.getICD().alcSuspendContext;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)context);
        }
        JNI.invokePV((long)__functionAddress, (long)context);
    }

    public static void alcDestroyContext(long context) {
        long __functionAddress = ALC.getICD().alcDestroyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)context);
        }
        JNI.invokePV((long)__functionAddress, (long)context);
    }

    public static long alcGetCurrentContext() {
        long __functionAddress = ALC.getICD().alcGetCurrentContext;
        return JNI.invokeP((long)__functionAddress);
    }

    public static long alcGetContextsDevice(long context) {
        long __functionAddress = ALC.getICD().alcGetContextsDevice;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)context);
        }
        return JNI.invokePP((long)__functionAddress, (long)context);
    }

    public static boolean nalcIsExtensionPresent(long deviceHandle, long extName) {
        long __functionAddress = ALC.getICD().alcIsExtensionPresent;
        return JNI.invokePPZ((long)__functionAddress, (long)deviceHandle, (long)extName);
    }

    public static boolean alcIsExtensionPresent(long deviceHandle, ByteBuffer extName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)extName);
        }
        return ALC10.nalcIsExtensionPresent(deviceHandle, MemoryUtil.memAddress((ByteBuffer)extName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean alcIsExtensionPresent(long deviceHandle, CharSequence extName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer extNameEncoded = stack.ASCII(extName);
            boolean bl = ALC10.nalcIsExtensionPresent(deviceHandle, MemoryUtil.memAddress((ByteBuffer)extNameEncoded));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nalcGetProcAddress(long deviceHandle, long funcName) {
        long __functionAddress = ALC.getICD().alcGetProcAddress;
        return JNI.invokePPP((long)__functionAddress, (long)deviceHandle, (long)funcName);
    }

    public static long alcGetProcAddress(long deviceHandle, ByteBuffer funcName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)funcName);
        }
        return ALC10.nalcGetProcAddress(deviceHandle, MemoryUtil.memAddress((ByteBuffer)funcName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long alcGetProcAddress(long deviceHandle, CharSequence funcName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer funcNameEncoded = stack.ASCII(funcName);
            long l = ALC10.nalcGetProcAddress(deviceHandle, MemoryUtil.memAddress((ByteBuffer)funcNameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nalcGetEnumValue(long deviceHandle, long enumName) {
        long __functionAddress = ALC.getICD().alcGetEnumValue;
        return JNI.invokePPI((long)__functionAddress, (long)deviceHandle, (long)enumName);
    }

    public static int alcGetEnumValue(long deviceHandle, ByteBuffer enumName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)enumName);
        }
        return ALC10.nalcGetEnumValue(deviceHandle, MemoryUtil.memAddress((ByteBuffer)enumName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int alcGetEnumValue(long deviceHandle, CharSequence enumName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer enumNameEncoded = stack.ASCII(enumName);
            int n = ALC10.nalcGetEnumValue(deviceHandle, MemoryUtil.memAddress((ByteBuffer)enumNameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int alcGetError(long deviceHandle) {
        long __functionAddress = ALC.getICD().alcGetError;
        return JNI.invokePI((long)__functionAddress, (long)deviceHandle);
    }

    public static long nalcGetString(long deviceHandle, int token) {
        long __functionAddress = ALC.getICD().alcGetString;
        return JNI.invokePP((long)__functionAddress, (long)deviceHandle, (int)token);
    }

    public static String alcGetString(long deviceHandle, int token) {
        long __result = ALC10.nalcGetString(deviceHandle, token);
        return MemoryUtil.memUTF8((long)__result);
    }

    public static void nalcGetIntegerv(long deviceHandle, int token, int size, long dest) {
        long __functionAddress = ALC.getICD().alcGetIntegerv;
        JNI.invokePPV((long)__functionAddress, (long)deviceHandle, (int)token, (int)size, (long)dest);
    }

    public static void alcGetIntegerv(long deviceHandle, int token, IntBuffer dest) {
        ALC10.nalcGetIntegerv(deviceHandle, token, dest.remaining(), MemoryUtil.memAddress((IntBuffer)dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int alcGetInteger(long deviceHandle, int token) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer dest = stack.callocInt(1);
            ALC10.nalcGetIntegerv(deviceHandle, token, 1, MemoryUtil.memAddress((IntBuffer)dest));
            int n = dest.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long alcCreateContext(long deviceHandle, int[] attrList) {
        long __functionAddress = ALC.getICD().alcCreateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer((long)deviceHandle);
            Checks.checkNTSafe((int[])attrList);
        }
        return JNI.invokePPP((long)__functionAddress, (long)deviceHandle, (int[])attrList);
    }

    public static void alcGetIntegerv(long deviceHandle, int token, int[] dest) {
        long __functionAddress = ALC.getICD().alcGetIntegerv;
        JNI.invokePPV((long)__functionAddress, (long)deviceHandle, (int)token, (int)dest.length, (int[])dest);
    }
}

