/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_scroll")
public class NkScroll
extends Struct<NkScroll>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected NkScroll(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkScroll create(long address, @Nullable ByteBuffer container) {
        return new NkScroll(address, container);
    }

    public NkScroll(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkScroll.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_uint")
    public int x() {
        return NkScroll.nx(this.address());
    }

    @NativeType(value="nk_uint")
    public int y() {
        return NkScroll.ny(this.address());
    }

    public static NkScroll malloc() {
        return new NkScroll(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NkScroll calloc() {
        return new NkScroll(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NkScroll create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NkScroll(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NkScroll create(long address) {
        return new NkScroll(address, null);
    }

    public static @Nullable NkScroll createSafe(long address) {
        return address == 0L ? null : new NkScroll(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NkScroll.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkScroll.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkScroll mallocStack() {
        return NkScroll.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkScroll callocStack() {
        return NkScroll.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkScroll mallocStack(MemoryStack stack) {
        return NkScroll.malloc(stack);
    }

    @Deprecated
    public static NkScroll callocStack(MemoryStack stack) {
        return NkScroll.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkScroll.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkScroll.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkScroll.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkScroll.calloc(capacity, stack);
    }

    public static NkScroll malloc(MemoryStack stack) {
        return new NkScroll(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkScroll calloc(MemoryStack stack) {
        return new NkScroll(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    static {
        Struct.Layout layout = NkScroll.__struct((Struct.Member[])new Struct.Member[]{NkScroll.__member((int)4), NkScroll.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkScroll, Buffer>
    implements NativeResource {
        private static final NkScroll ELEMENT_FACTORY = NkScroll.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkScroll getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_uint")
        public int x() {
            return NkScroll.nx(this.address());
        }

        @NativeType(value="nk_uint")
        public int y() {
            return NkScroll.ny(this.address());
        }
    }
}

