/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.nuklear.NkKey;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_keyboard")
public class NkKeyboard
extends Struct<NkKeyboard> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KEYS;
    public static final int TEXT;
    public static final int TEXT_LEN;

    protected NkKeyboard(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkKeyboard create(long address, @Nullable ByteBuffer container) {
        return new NkKeyboard(address, container);
    }

    public NkKeyboard(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkKeyboard.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_key[NK_KEY_MAX]")
    public NkKey.Buffer keys() {
        return NkKeyboard.nkeys(this.address());
    }

    @NativeType(value="struct nk_key")
    public NkKey keys(int index) {
        return NkKeyboard.nkeys(this.address(), index);
    }

    @NativeType(value="char[NK_INPUT_MAX]")
    public ByteBuffer text() {
        return NkKeyboard.ntext(this.address());
    }

    @NativeType(value="char")
    public byte text(int index) {
        return NkKeyboard.ntext(this.address(), index);
    }

    public int text_len() {
        return NkKeyboard.ntext_len(this.address());
    }

    public static NkKeyboard create(long address) {
        return new NkKeyboard(address, null);
    }

    public static @Nullable NkKeyboard createSafe(long address) {
        return address == 0L ? null : new NkKeyboard(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkKey.Buffer nkeys(long struct) {
        return NkKey.create(struct + (long)KEYS, 30);
    }

    public static NkKey nkeys(long struct, int index) {
        return NkKey.create(struct + (long)KEYS + Checks.check((int)index, (int)30) * (long)NkKey.SIZEOF);
    }

    public static ByteBuffer ntext(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)TEXT), (int)16);
    }

    public static byte ntext(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)TEXT + Checks.check((int)index, (int)16) * 1L));
    }

    public static int ntext_len(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TEXT_LEN));
    }

    static {
        Struct.Layout layout = NkKeyboard.__struct((Struct.Member[])new Struct.Member[]{NkKeyboard.__array((int)NkKey.SIZEOF, (int)NkKey.ALIGNOF, (int)30), NkKeyboard.__array((int)1, (int)16), NkKeyboard.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KEYS = layout.offsetof(0);
        TEXT = layout.offsetof(1);
        TEXT_LEN = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkKeyboard, Buffer> {
        private static final NkKeyboard ELEMENT_FACTORY = NkKeyboard.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkKeyboard getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_key[NK_KEY_MAX]")
        public NkKey.Buffer keys() {
            return NkKeyboard.nkeys(this.address());
        }

        @NativeType(value="struct nk_key")
        public NkKey keys(int index) {
            return NkKeyboard.nkeys(this.address(), index);
        }

        @NativeType(value="char[NK_INPUT_MAX]")
        public ByteBuffer text() {
            return NkKeyboard.ntext(this.address());
        }

        @NativeType(value="char")
        public byte text(int index) {
            return NkKeyboard.ntext(this.address(), index);
        }

        public int text_len() {
            return NkKeyboard.ntext_len(this.address());
        }
    }
}

