/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.nuklear.NkScroll;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_edit_state")
public class NkEditState
extends Struct<NkEditState> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SEQ;
    public static final int OLD;
    public static final int ACTIVE;
    public static final int PREV;
    public static final int CURSOR;
    public static final int SEL_START;
    public static final int SEL_END;
    public static final int SCROLLBAR;
    public static final int MODE;
    public static final int SINGLE_LINE;

    protected NkEditState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NkEditState create(long address, @Nullable ByteBuffer container) {
        return new NkEditState(address, container);
    }

    public NkEditState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkEditState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_hash")
    public int name() {
        return NkEditState.nname(this.address());
    }

    @NativeType(value="unsigned int")
    public int seq() {
        return NkEditState.nseq(this.address());
    }

    @NativeType(value="unsigned int")
    public int old() {
        return NkEditState.nold(this.address());
    }

    public int active() {
        return NkEditState.nactive(this.address());
    }

    public int prev() {
        return NkEditState.nprev(this.address());
    }

    public int cursor() {
        return NkEditState.ncursor(this.address());
    }

    public int sel_start() {
        return NkEditState.nsel_start(this.address());
    }

    public int sel_end() {
        return NkEditState.nsel_end(this.address());
    }

    @NativeType(value="struct nk_scroll")
    public NkScroll scrollbar() {
        return NkEditState.nscrollbar(this.address());
    }

    @NativeType(value="unsigned char")
    public byte mode() {
        return NkEditState.nmode(this.address());
    }

    @NativeType(value="bool")
    public boolean single_line() {
        return NkEditState.nsingle_line(this.address());
    }

    public static NkEditState create(long address) {
        return new NkEditState(address, null);
    }

    public static @Nullable NkEditState createSafe(long address) {
        return address == 0L ? null : new NkEditState(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nname(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NAME));
    }

    public static int nseq(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SEQ));
    }

    public static int nold(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OLD));
    }

    public static int nactive(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ACTIVE));
    }

    public static int nprev(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PREV));
    }

    public static int ncursor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CURSOR));
    }

    public static int nsel_start(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SEL_START));
    }

    public static int nsel_end(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SEL_END));
    }

    public static NkScroll nscrollbar(long struct) {
        return NkScroll.create(struct + (long)SCROLLBAR);
    }

    public static byte nmode(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MODE));
    }

    public static boolean nsingle_line(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SINGLE_LINE)) != 0;
    }

    static {
        Struct.Layout layout = NkEditState.__struct((Struct.Member[])new Struct.Member[]{NkEditState.__member((int)4), NkEditState.__member((int)4), NkEditState.__member((int)4), NkEditState.__member((int)4), NkEditState.__member((int)4), NkEditState.__member((int)4), NkEditState.__member((int)4), NkEditState.__member((int)4), NkEditState.__member((int)NkScroll.SIZEOF, (int)NkScroll.ALIGNOF), NkEditState.__member((int)1), NkEditState.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SEQ = layout.offsetof(1);
        OLD = layout.offsetof(2);
        ACTIVE = layout.offsetof(3);
        PREV = layout.offsetof(4);
        CURSOR = layout.offsetof(5);
        SEL_START = layout.offsetof(6);
        SEL_END = layout.offsetof(7);
        SCROLLBAR = layout.offsetof(8);
        MODE = layout.offsetof(9);
        SINGLE_LINE = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<NkEditState, Buffer> {
        private static final NkEditState ELEMENT_FACTORY = NkEditState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NkEditState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_hash")
        public int name() {
            return NkEditState.nname(this.address());
        }

        @NativeType(value="unsigned int")
        public int seq() {
            return NkEditState.nseq(this.address());
        }

        @NativeType(value="unsigned int")
        public int old() {
            return NkEditState.nold(this.address());
        }

        public int active() {
            return NkEditState.nactive(this.address());
        }

        public int prev() {
            return NkEditState.nprev(this.address());
        }

        public int cursor() {
            return NkEditState.ncursor(this.address());
        }

        public int sel_start() {
            return NkEditState.nsel_start(this.address());
        }

        public int sel_end() {
            return NkEditState.nsel_end(this.address());
        }

        @NativeType(value="struct nk_scroll")
        public NkScroll scrollbar() {
            return NkEditState.nscrollbar(this.address());
        }

        @NativeType(value="unsigned char")
        public byte mode() {
            return NkEditState.nmode(this.address());
        }

        @NativeType(value="bool")
        public boolean single_line() {
            return NkEditState.nsingle_line(this.address());
        }
    }
}

