/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_recti")
public class NkRecti
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    public NkRecti(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkRecti.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public short x() {
        return NkRecti.nx(this.address());
    }

    public short y() {
        return NkRecti.ny(this.address());
    }

    public short w() {
        return NkRecti.nw(this.address());
    }

    public short h() {
        return NkRecti.nh(this.address());
    }

    public NkRecti x(short value) {
        NkRecti.nx(this.address(), value);
        return this;
    }

    public NkRecti y(short value) {
        NkRecti.ny(this.address(), value);
        return this;
    }

    public NkRecti w(short value) {
        NkRecti.nw(this.address(), value);
        return this;
    }

    public NkRecti h(short value) {
        NkRecti.nh(this.address(), value);
        return this;
    }

    public NkRecti set(short x, short y, short w, short h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public NkRecti set(NkRecti src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkRecti malloc() {
        return (NkRecti)NkRecti.wrap(NkRecti.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkRecti calloc() {
        return (NkRecti)NkRecti.wrap(NkRecti.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkRecti create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkRecti)NkRecti.wrap(NkRecti.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkRecti create(long address) {
        return (NkRecti)NkRecti.wrap(NkRecti.class, (long)address);
    }

    @Nullable
    public static NkRecti createSafe(long address) {
        return address == 0L ? null : (NkRecti)NkRecti.wrap(NkRecti.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkRecti.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkRecti.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkRecti.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkRecti.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkRecti.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkRecti.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkRecti.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkRecti malloc(MemoryStack stack) {
        return (NkRecti)NkRecti.wrap(NkRecti.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkRecti calloc(MemoryStack stack) {
        return (NkRecti)NkRecti.wrap(NkRecti.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkRecti.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkRecti.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static short nx(long struct) {
        return UNSAFE.getShort(null, struct + (long)X);
    }

    public static short ny(long struct) {
        return UNSAFE.getShort(null, struct + (long)Y);
    }

    public static short nw(long struct) {
        return UNSAFE.getShort(null, struct + (long)W);
    }

    public static short nh(long struct) {
        return UNSAFE.getShort(null, struct + (long)H);
    }

    public static void nx(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)X, value);
    }

    public static void ny(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)Y, value);
    }

    public static void nw(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)W, value);
    }

    public static void nh(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)H, value);
    }

    static {
        Struct.Layout layout = NkRecti.__struct((Struct.Member[])new Struct.Member[]{NkRecti.__member((int)2), NkRecti.__member((int)2), NkRecti.__member((int)2), NkRecti.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkRecti, Buffer>
    implements NativeResource {
        private static final NkRecti ELEMENT_FACTORY = NkRecti.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkRecti getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public short x() {
            return NkRecti.nx(this.address());
        }

        public short y() {
            return NkRecti.ny(this.address());
        }

        public short w() {
            return NkRecti.nw(this.address());
        }

        public short h() {
            return NkRecti.nh(this.address());
        }

        public Buffer x(short value) {
            NkRecti.nx(this.address(), value);
            return this;
        }

        public Buffer y(short value) {
            NkRecti.ny(this.address(), value);
            return this;
        }

        public Buffer w(short value) {
            NkRecti.nw(this.address(), value);
            return this;
        }

        public Buffer h(short value) {
            NkRecti.nh(this.address(), value);
            return this;
        }
    }
}

