/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkAllocator;
import org.lwjgl.nuklear.NkCursor;
import org.lwjgl.nuklear.NkFont;
import org.lwjgl.nuklear.NkFontConfig;
import org.lwjgl.nuklear.NkFontGlyph;
import org.lwjgl.nuklear.NkRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_font_atlas")
public class NkFontAtlas
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXEL;
    public static final int TEX_WIDTH;
    public static final int TEX_HEIGHT;
    public static final int PERMANENT;
    public static final int TEMPORARY;
    public static final int CUSTOM;
    public static final int CURSORS;
    public static final int GLYPH_COUNT;
    public static final int GLYPHS;
    public static final int DEFAULT_FONT;
    public static final int FONTS;
    public static final int CONFIG;
    public static final int FONT_NUM;

    public NkFontAtlas(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkFontAtlas.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer pixel() {
        return NkFontAtlas.npixel(this.address());
    }

    public int tex_width() {
        return NkFontAtlas.ntex_width(this.address());
    }

    public int tex_height() {
        return NkFontAtlas.ntex_height(this.address());
    }

    @NativeType(value="struct nk_allocator")
    public NkAllocator permanent() {
        return NkFontAtlas.npermanent(this.address());
    }

    @NativeType(value="struct nk_allocator")
    public NkAllocator temporary() {
        return NkFontAtlas.ntemporary(this.address());
    }

    @NativeType(value="struct nk_recti")
    public NkRecti custom() {
        return NkFontAtlas.ncustom(this.address());
    }

    @NativeType(value="struct nk_cursor[7]")
    public NkCursor.Buffer cursors() {
        return NkFontAtlas.ncursors(this.address());
    }

    @NativeType(value="struct nk_cursor")
    public NkCursor cursors(int index) {
        return NkFontAtlas.ncursors(this.address(), index);
    }

    public int glyph_count() {
        return NkFontAtlas.nglyph_count(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_font_glyph *")
    public NkFontGlyph.Buffer glyphs() {
        return NkFontAtlas.nglyphs(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_font *")
    public NkFont default_font() {
        return NkFontAtlas.ndefault_font(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_font *")
    public NkFont fonts() {
        return NkFontAtlas.nfonts(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_font_config *")
    public NkFontConfig config() {
        return NkFontAtlas.nconfig(this.address());
    }

    public int font_num() {
        return NkFontAtlas.nfont_num(this.address());
    }

    public NkFontAtlas pixel(@Nullable @NativeType(value="void *") ByteBuffer value) {
        NkFontAtlas.npixel(this.address(), value);
        return this;
    }

    public NkFontAtlas tex_width(int value) {
        NkFontAtlas.ntex_width(this.address(), value);
        return this;
    }

    public NkFontAtlas tex_height(int value) {
        NkFontAtlas.ntex_height(this.address(), value);
        return this;
    }

    public NkFontAtlas permanent(@NativeType(value="struct nk_allocator") NkAllocator value) {
        NkFontAtlas.npermanent(this.address(), value);
        return this;
    }

    public NkFontAtlas permanent(Consumer<NkAllocator> consumer) {
        consumer.accept(this.permanent());
        return this;
    }

    public NkFontAtlas temporary(@NativeType(value="struct nk_allocator") NkAllocator value) {
        NkFontAtlas.ntemporary(this.address(), value);
        return this;
    }

    public NkFontAtlas temporary(Consumer<NkAllocator> consumer) {
        consumer.accept(this.temporary());
        return this;
    }

    public NkFontAtlas custom(@NativeType(value="struct nk_recti") NkRecti value) {
        NkFontAtlas.ncustom(this.address(), value);
        return this;
    }

    public NkFontAtlas custom(Consumer<NkRecti> consumer) {
        consumer.accept(this.custom());
        return this;
    }

    public NkFontAtlas cursors(@NativeType(value="struct nk_cursor[7]") NkCursor.Buffer value) {
        NkFontAtlas.ncursors(this.address(), value);
        return this;
    }

    public NkFontAtlas cursors(int index, @NativeType(value="struct nk_cursor") NkCursor value) {
        NkFontAtlas.ncursors(this.address(), index, value);
        return this;
    }

    public NkFontAtlas cursors(Consumer<NkCursor.Buffer> consumer) {
        consumer.accept(this.cursors());
        return this;
    }

    public NkFontAtlas cursors(int index, Consumer<NkCursor> consumer) {
        consumer.accept(this.cursors(index));
        return this;
    }

    public NkFontAtlas glyph_count(int value) {
        NkFontAtlas.nglyph_count(this.address(), value);
        return this;
    }

    public NkFontAtlas glyphs(@Nullable @NativeType(value="struct nk_font_glyph *") NkFontGlyph.Buffer value) {
        NkFontAtlas.nglyphs(this.address(), value);
        return this;
    }

    public NkFontAtlas default_font(@Nullable @NativeType(value="struct nk_font *") NkFont value) {
        NkFontAtlas.ndefault_font(this.address(), value);
        return this;
    }

    public NkFontAtlas fonts(@Nullable @NativeType(value="struct nk_font *") NkFont value) {
        NkFontAtlas.nfonts(this.address(), value);
        return this;
    }

    public NkFontAtlas config(@Nullable @NativeType(value="struct nk_font_config *") NkFontConfig value) {
        NkFontAtlas.nconfig(this.address(), value);
        return this;
    }

    public NkFontAtlas font_num(int value) {
        NkFontAtlas.nfont_num(this.address(), value);
        return this;
    }

    public NkFontAtlas set(@Nullable ByteBuffer pixel, int tex_width, int tex_height, NkAllocator permanent, NkAllocator temporary, NkRecti custom, NkCursor.Buffer cursors, int glyph_count, @Nullable NkFontGlyph.Buffer glyphs, @Nullable NkFont default_font, @Nullable NkFont fonts, @Nullable NkFontConfig config, int font_num) {
        this.pixel(pixel);
        this.tex_width(tex_width);
        this.tex_height(tex_height);
        this.permanent(permanent);
        this.temporary(temporary);
        this.custom(custom);
        this.cursors(cursors);
        this.glyph_count(glyph_count);
        this.glyphs(glyphs);
        this.default_font(default_font);
        this.fonts(fonts);
        this.config(config);
        this.font_num(font_num);
        return this;
    }

    public NkFontAtlas set(NkFontAtlas src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkFontAtlas malloc() {
        return (NkFontAtlas)NkFontAtlas.wrap(NkFontAtlas.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkFontAtlas calloc() {
        return (NkFontAtlas)NkFontAtlas.wrap(NkFontAtlas.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkFontAtlas create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkFontAtlas)NkFontAtlas.wrap(NkFontAtlas.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkFontAtlas create(long address) {
        return (NkFontAtlas)NkFontAtlas.wrap(NkFontAtlas.class, (long)address);
    }

    @Nullable
    public static NkFontAtlas createSafe(long address) {
        return address == 0L ? null : (NkFontAtlas)NkFontAtlas.wrap(NkFontAtlas.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkFontAtlas.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkFontAtlas.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkFontAtlas.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkFontAtlas.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkFontAtlas.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkFontAtlas.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkFontAtlas.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkFontAtlas malloc(MemoryStack stack) {
        return (NkFontAtlas)NkFontAtlas.wrap(NkFontAtlas.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkFontAtlas calloc(MemoryStack stack) {
        return (NkFontAtlas)NkFontAtlas.wrap(NkFontAtlas.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkFontAtlas.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkFontAtlas.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    @Nullable
    public static ByteBuffer npixel(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXEL)), (int)(NkFontAtlas.ntex_width(struct) * NkFontAtlas.ntex_height(struct)));
    }

    public static int ntex_width(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEX_WIDTH);
    }

    public static int ntex_height(long struct) {
        return UNSAFE.getInt(null, struct + (long)TEX_HEIGHT);
    }

    public static NkAllocator npermanent(long struct) {
        return NkAllocator.create(struct + (long)PERMANENT);
    }

    public static NkAllocator ntemporary(long struct) {
        return NkAllocator.create(struct + (long)TEMPORARY);
    }

    public static NkRecti ncustom(long struct) {
        return NkRecti.create(struct + (long)CUSTOM);
    }

    public static NkCursor.Buffer ncursors(long struct) {
        return NkCursor.create(struct + (long)CURSORS, 7);
    }

    public static NkCursor ncursors(long struct, int index) {
        return NkCursor.create(struct + (long)CURSORS + Checks.check((int)index, (int)7) * (long)NkCursor.SIZEOF);
    }

    public static int nglyph_count(long struct) {
        return UNSAFE.getInt(null, struct + (long)GLYPH_COUNT);
    }

    @Nullable
    public static NkFontGlyph.Buffer nglyphs(long struct) {
        return NkFontGlyph.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)GLYPHS)), NkFontAtlas.nglyph_count(struct));
    }

    @Nullable
    public static NkFont ndefault_font(long struct) {
        return NkFont.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DEFAULT_FONT)));
    }

    @Nullable
    public static NkFont nfonts(long struct) {
        return NkFont.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FONTS)));
    }

    @Nullable
    public static NkFontConfig nconfig(long struct) {
        return NkFontConfig.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CONFIG)));
    }

    public static int nfont_num(long struct) {
        return UNSAFE.getInt(null, struct + (long)FONT_NUM);
    }

    public static void npixel(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIXEL), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        NkFontAtlas.ntex_width(struct, value == null ? 0 : value.remaining());
    }

    public static void ntex_width(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TEX_WIDTH, value);
    }

    public static void ntex_height(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TEX_HEIGHT, value);
    }

    public static void npermanent(long struct, NkAllocator value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PERMANENT), (long)NkAllocator.SIZEOF);
    }

    public static void ntemporary(long struct, NkAllocator value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEMPORARY), (long)NkAllocator.SIZEOF);
    }

    public static void ncustom(long struct, NkRecti value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CUSTOM), (long)NkRecti.SIZEOF);
    }

    public static void ncursors(long struct, NkCursor.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSORS), (long)(value.remaining() * NkCursor.SIZEOF));
    }

    public static void ncursors(long struct, int index, NkCursor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CURSORS + Checks.check((int)index, (int)7) * (long)NkCursor.SIZEOF), (long)NkCursor.SIZEOF);
    }

    public static void nglyph_count(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GLYPH_COUNT, value);
    }

    public static void nglyphs(long struct, @Nullable NkFontGlyph.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)GLYPHS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        NkFontAtlas.nglyph_count(struct, value == null ? 0 : value.remaining());
    }

    public static void ndefault_font(long struct, @Nullable NkFont value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEFAULT_FONT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfonts(long struct, @Nullable NkFont value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FONTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nconfig(long struct, @Nullable NkFontConfig value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIG), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfont_num(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FONT_NUM, value);
    }

    static {
        Struct.Layout layout = NkFontAtlas.__struct((Struct.Member[])new Struct.Member[]{NkFontAtlas.__member((int)POINTER_SIZE), NkFontAtlas.__member((int)4), NkFontAtlas.__member((int)4), NkFontAtlas.__member((int)NkAllocator.SIZEOF, (int)NkAllocator.ALIGNOF), NkFontAtlas.__member((int)NkAllocator.SIZEOF, (int)NkAllocator.ALIGNOF), NkFontAtlas.__member((int)NkRecti.SIZEOF, (int)NkRecti.ALIGNOF), NkFontAtlas.__array((int)NkCursor.SIZEOF, (int)NkCursor.ALIGNOF, (int)7), NkFontAtlas.__member((int)4), NkFontAtlas.__member((int)POINTER_SIZE), NkFontAtlas.__member((int)POINTER_SIZE), NkFontAtlas.__member((int)POINTER_SIZE), NkFontAtlas.__member((int)POINTER_SIZE), NkFontAtlas.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXEL = layout.offsetof(0);
        TEX_WIDTH = layout.offsetof(1);
        TEX_HEIGHT = layout.offsetof(2);
        PERMANENT = layout.offsetof(3);
        TEMPORARY = layout.offsetof(4);
        CUSTOM = layout.offsetof(5);
        CURSORS = layout.offsetof(6);
        GLYPH_COUNT = layout.offsetof(7);
        GLYPHS = layout.offsetof(8);
        DEFAULT_FONT = layout.offsetof(9);
        FONTS = layout.offsetof(10);
        CONFIG = layout.offsetof(11);
        FONT_NUM = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<NkFontAtlas, Buffer>
    implements NativeResource {
        private static final NkFontAtlas ELEMENT_FACTORY = NkFontAtlas.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkFontAtlas getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="void *")
        public ByteBuffer pixel() {
            return NkFontAtlas.npixel(this.address());
        }

        public int tex_width() {
            return NkFontAtlas.ntex_width(this.address());
        }

        public int tex_height() {
            return NkFontAtlas.ntex_height(this.address());
        }

        @NativeType(value="struct nk_allocator")
        public NkAllocator permanent() {
            return NkFontAtlas.npermanent(this.address());
        }

        @NativeType(value="struct nk_allocator")
        public NkAllocator temporary() {
            return NkFontAtlas.ntemporary(this.address());
        }

        @NativeType(value="struct nk_recti")
        public NkRecti custom() {
            return NkFontAtlas.ncustom(this.address());
        }

        @NativeType(value="struct nk_cursor[7]")
        public NkCursor.Buffer cursors() {
            return NkFontAtlas.ncursors(this.address());
        }

        @NativeType(value="struct nk_cursor")
        public NkCursor cursors(int index) {
            return NkFontAtlas.ncursors(this.address(), index);
        }

        public int glyph_count() {
            return NkFontAtlas.nglyph_count(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_font_glyph *")
        public NkFontGlyph.Buffer glyphs() {
            return NkFontAtlas.nglyphs(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_font *")
        public NkFont default_font() {
            return NkFontAtlas.ndefault_font(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_font *")
        public NkFont fonts() {
            return NkFontAtlas.nfonts(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_font_config *")
        public NkFontConfig config() {
            return NkFontAtlas.nconfig(this.address());
        }

        public int font_num() {
            return NkFontAtlas.nfont_num(this.address());
        }

        public Buffer pixel(@Nullable @NativeType(value="void *") ByteBuffer value) {
            NkFontAtlas.npixel(this.address(), value);
            return this;
        }

        public Buffer tex_width(int value) {
            NkFontAtlas.ntex_width(this.address(), value);
            return this;
        }

        public Buffer tex_height(int value) {
            NkFontAtlas.ntex_height(this.address(), value);
            return this;
        }

        public Buffer permanent(@NativeType(value="struct nk_allocator") NkAllocator value) {
            NkFontAtlas.npermanent(this.address(), value);
            return this;
        }

        public Buffer permanent(Consumer<NkAllocator> consumer) {
            consumer.accept(this.permanent());
            return this;
        }

        public Buffer temporary(@NativeType(value="struct nk_allocator") NkAllocator value) {
            NkFontAtlas.ntemporary(this.address(), value);
            return this;
        }

        public Buffer temporary(Consumer<NkAllocator> consumer) {
            consumer.accept(this.temporary());
            return this;
        }

        public Buffer custom(@NativeType(value="struct nk_recti") NkRecti value) {
            NkFontAtlas.ncustom(this.address(), value);
            return this;
        }

        public Buffer custom(Consumer<NkRecti> consumer) {
            consumer.accept(this.custom());
            return this;
        }

        public Buffer cursors(@NativeType(value="struct nk_cursor[7]") NkCursor.Buffer value) {
            NkFontAtlas.ncursors(this.address(), value);
            return this;
        }

        public Buffer cursors(int index, @NativeType(value="struct nk_cursor") NkCursor value) {
            NkFontAtlas.ncursors(this.address(), index, value);
            return this;
        }

        public Buffer cursors(Consumer<NkCursor.Buffer> consumer) {
            consumer.accept(this.cursors());
            return this;
        }

        public Buffer cursors(int index, Consumer<NkCursor> consumer) {
            consumer.accept(this.cursors(index));
            return this;
        }

        public Buffer glyph_count(int value) {
            NkFontAtlas.nglyph_count(this.address(), value);
            return this;
        }

        public Buffer glyphs(@Nullable @NativeType(value="struct nk_font_glyph *") NkFontGlyph.Buffer value) {
            NkFontAtlas.nglyphs(this.address(), value);
            return this;
        }

        public Buffer default_font(@Nullable @NativeType(value="struct nk_font *") NkFont value) {
            NkFontAtlas.ndefault_font(this.address(), value);
            return this;
        }

        public Buffer fonts(@Nullable @NativeType(value="struct nk_font *") NkFont value) {
            NkFontAtlas.nfonts(this.address(), value);
            return this;
        }

        public Buffer config(@Nullable @NativeType(value="struct nk_font_config *") NkFontConfig value) {
            NkFontAtlas.nconfig(this.address(), value);
            return this;
        }

        public Buffer font_num(int value) {
            NkFontAtlas.nfont_num(this.address(), value);
            return this;
        }
    }
}

