/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkBakedFont;
import org.lwjgl.nuklear.NkFontConfig;
import org.lwjgl.nuklear.NkFontGlyph;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.nuklear.NkUserFont;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_font")
public class NkFont
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NEXT;
    public static final int HANDLE;
    public static final int INFO;
    public static final int SCALE;
    public static final int GLYPHS;
    public static final int FALLBACK;
    public static final int FALLBACK_CODEPOINT;
    public static final int TEXTURE;
    public static final int CONFIG;

    public NkFont(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkFont.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="struct nk_font *")
    public NkFont next() {
        return NkFont.nnext(this.address());
    }

    @NativeType(value="struct nk_user_font")
    public NkUserFont handle() {
        return NkFont.nhandle(this.address());
    }

    @NativeType(value="struct nk_baked_font")
    public NkBakedFont info() {
        return NkFont.ninfo(this.address());
    }

    public float scale() {
        return NkFont.nscale(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_font_glyph *")
    public NkFontGlyph glyphs() {
        return NkFont.nglyphs(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_font_glyph const *")
    public NkFontGlyph fallback() {
        return NkFont.nfallback(this.address());
    }

    @NativeType(value="nk_rune")
    public int fallback_codepoint() {
        return NkFont.nfallback_codepoint(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle texture() {
        return NkFont.ntexture(this.address());
    }

    @Nullable
    @NativeType(value="struct nk_font_config *")
    public NkFontConfig config() {
        return NkFont.nconfig(this.address());
    }

    public NkFont next(@Nullable @NativeType(value="struct nk_font *") NkFont value) {
        NkFont.nnext(this.address(), value);
        return this;
    }

    public NkFont handle(@NativeType(value="struct nk_user_font") NkUserFont value) {
        NkFont.nhandle(this.address(), value);
        return this;
    }

    public NkFont handle(Consumer<NkUserFont> consumer) {
        consumer.accept(this.handle());
        return this;
    }

    public NkFont info(@NativeType(value="struct nk_baked_font") NkBakedFont value) {
        NkFont.ninfo(this.address(), value);
        return this;
    }

    public NkFont info(Consumer<NkBakedFont> consumer) {
        consumer.accept(this.info());
        return this;
    }

    public NkFont scale(float value) {
        NkFont.nscale(this.address(), value);
        return this;
    }

    public NkFont glyphs(@Nullable @NativeType(value="struct nk_font_glyph *") NkFontGlyph value) {
        NkFont.nglyphs(this.address(), value);
        return this;
    }

    public NkFont fallback(@Nullable @NativeType(value="struct nk_font_glyph const *") NkFontGlyph value) {
        NkFont.nfallback(this.address(), value);
        return this;
    }

    public NkFont fallback_codepoint(@NativeType(value="nk_rune") int value) {
        NkFont.nfallback_codepoint(this.address(), value);
        return this;
    }

    public NkFont texture(@NativeType(value="nk_handle") NkHandle value) {
        NkFont.ntexture(this.address(), value);
        return this;
    }

    public NkFont texture(Consumer<NkHandle> consumer) {
        consumer.accept(this.texture());
        return this;
    }

    public NkFont config(@Nullable @NativeType(value="struct nk_font_config *") NkFontConfig value) {
        NkFont.nconfig(this.address(), value);
        return this;
    }

    public NkFont set(@Nullable NkFont next, NkUserFont handle, NkBakedFont info, float scale, @Nullable NkFontGlyph glyphs, @Nullable NkFontGlyph fallback, int fallback_codepoint, NkHandle texture, @Nullable NkFontConfig config) {
        this.next(next);
        this.handle(handle);
        this.info(info);
        this.scale(scale);
        this.glyphs(glyphs);
        this.fallback(fallback);
        this.fallback_codepoint(fallback_codepoint);
        this.texture(texture);
        this.config(config);
        return this;
    }

    public NkFont set(NkFont src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkFont malloc() {
        return (NkFont)NkFont.wrap(NkFont.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkFont calloc() {
        return (NkFont)NkFont.wrap(NkFont.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkFont create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkFont)NkFont.wrap(NkFont.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkFont create(long address) {
        return (NkFont)NkFont.wrap(NkFont.class, (long)address);
    }

    @Nullable
    public static NkFont createSafe(long address) {
        return address == 0L ? null : (NkFont)NkFont.wrap(NkFont.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkFont.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkFont.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkFont.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkFont.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkFont.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkFont.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkFont.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkFont malloc(MemoryStack stack) {
        return (NkFont)NkFont.wrap(NkFont.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkFont calloc(MemoryStack stack) {
        return (NkFont)NkFont.wrap(NkFont.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkFont.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkFont.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    @Nullable
    public static NkFont nnext(long struct) {
        return NkFont.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static NkUserFont nhandle(long struct) {
        return NkUserFont.create(struct + (long)HANDLE);
    }

    public static NkBakedFont ninfo(long struct) {
        return NkBakedFont.create(struct + (long)INFO);
    }

    public static float nscale(long struct) {
        return UNSAFE.getFloat(null, struct + (long)SCALE);
    }

    @Nullable
    public static NkFontGlyph nglyphs(long struct) {
        return NkFontGlyph.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)GLYPHS)));
    }

    @Nullable
    public static NkFontGlyph nfallback(long struct) {
        return NkFontGlyph.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FALLBACK)));
    }

    public static int nfallback_codepoint(long struct) {
        return UNSAFE.getInt(null, struct + (long)FALLBACK_CODEPOINT);
    }

    public static NkHandle ntexture(long struct) {
        return NkHandle.create(struct + (long)TEXTURE);
    }

    @Nullable
    public static NkFontConfig nconfig(long struct) {
        return NkFontConfig.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CONFIG)));
    }

    public static void nnext(long struct, @Nullable NkFont value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nhandle(long struct, NkUserFont value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HANDLE), (long)NkUserFont.SIZEOF);
    }

    public static void ninfo(long struct, NkBakedFont value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)INFO), (long)NkBakedFont.SIZEOF);
    }

    public static void nscale(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)SCALE, value);
    }

    public static void nglyphs(long struct, @Nullable NkFontGlyph value) {
        MemoryUtil.memPutAddress((long)(struct + (long)GLYPHS), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfallback(long struct, @Nullable NkFontGlyph value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FALLBACK), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nfallback_codepoint(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FALLBACK_CODEPOINT, value);
    }

    public static void ntexture(long struct, NkHandle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXTURE), (long)NkHandle.SIZEOF);
    }

    public static void nconfig(long struct, @Nullable NkFontConfig value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIG), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = NkFont.__struct((Struct.Member[])new Struct.Member[]{NkFont.__member((int)POINTER_SIZE), NkFont.__member((int)NkUserFont.SIZEOF, (int)NkUserFont.ALIGNOF), NkFont.__member((int)NkBakedFont.SIZEOF, (int)NkBakedFont.ALIGNOF), NkFont.__member((int)4), NkFont.__member((int)POINTER_SIZE), NkFont.__member((int)POINTER_SIZE), NkFont.__member((int)4), NkFont.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF), NkFont.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NEXT = layout.offsetof(0);
        HANDLE = layout.offsetof(1);
        INFO = layout.offsetof(2);
        SCALE = layout.offsetof(3);
        GLYPHS = layout.offsetof(4);
        FALLBACK = layout.offsetof(5);
        FALLBACK_CODEPOINT = layout.offsetof(6);
        TEXTURE = layout.offsetof(7);
        CONFIG = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<NkFont, Buffer>
    implements NativeResource {
        private static final NkFont ELEMENT_FACTORY = NkFont.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkFont getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="struct nk_font *")
        public NkFont next() {
            return NkFont.nnext(this.address());
        }

        @NativeType(value="struct nk_user_font")
        public NkUserFont handle() {
            return NkFont.nhandle(this.address());
        }

        @NativeType(value="struct nk_baked_font")
        public NkBakedFont info() {
            return NkFont.ninfo(this.address());
        }

        public float scale() {
            return NkFont.nscale(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_font_glyph *")
        public NkFontGlyph glyphs() {
            return NkFont.nglyphs(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_font_glyph const *")
        public NkFontGlyph fallback() {
            return NkFont.nfallback(this.address());
        }

        @NativeType(value="nk_rune")
        public int fallback_codepoint() {
            return NkFont.nfallback_codepoint(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle texture() {
            return NkFont.ntexture(this.address());
        }

        @Nullable
        @NativeType(value="struct nk_font_config *")
        public NkFontConfig config() {
            return NkFont.nconfig(this.address());
        }

        public Buffer next(@Nullable @NativeType(value="struct nk_font *") NkFont value) {
            NkFont.nnext(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="struct nk_user_font") NkUserFont value) {
            NkFont.nhandle(this.address(), value);
            return this;
        }

        public Buffer handle(Consumer<NkUserFont> consumer) {
            consumer.accept(this.handle());
            return this;
        }

        public Buffer info(@NativeType(value="struct nk_baked_font") NkBakedFont value) {
            NkFont.ninfo(this.address(), value);
            return this;
        }

        public Buffer info(Consumer<NkBakedFont> consumer) {
            consumer.accept(this.info());
            return this;
        }

        public Buffer scale(float value) {
            NkFont.nscale(this.address(), value);
            return this;
        }

        public Buffer glyphs(@Nullable @NativeType(value="struct nk_font_glyph *") NkFontGlyph value) {
            NkFont.nglyphs(this.address(), value);
            return this;
        }

        public Buffer fallback(@Nullable @NativeType(value="struct nk_font_glyph const *") NkFontGlyph value) {
            NkFont.nfallback(this.address(), value);
            return this;
        }

        public Buffer fallback_codepoint(@NativeType(value="nk_rune") int value) {
            NkFont.nfallback_codepoint(this.address(), value);
            return this;
        }

        public Buffer texture(@NativeType(value="nk_handle") NkHandle value) {
            NkFont.ntexture(this.address(), value);
            return this;
        }

        public Buffer texture(Consumer<NkHandle> consumer) {
            consumer.accept(this.texture());
            return this;
        }

        public Buffer config(@Nullable @NativeType(value="struct nk_font_config *") NkFontConfig value) {
            NkFont.nconfig(this.address(), value);
            return this;
        }
    }
}

