/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkChartSlot;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_chart")
public class NkChart
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SLOT;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;
    public static final int SLOTS;

    public NkChart(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkChart.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int slot() {
        return NkChart.nslot(this.address());
    }

    public float x() {
        return NkChart.nx(this.address());
    }

    public float y() {
        return NkChart.ny(this.address());
    }

    public float w() {
        return NkChart.nw(this.address());
    }

    public float h() {
        return NkChart.nh(this.address());
    }

    @NativeType(value="struct nk_chart_slot[NK_CHART_MAX_SLOT]")
    public NkChartSlot.Buffer slots() {
        return NkChart.nslots(this.address());
    }

    @NativeType(value="struct nk_chart_slot")
    public NkChartSlot slots(int index) {
        return NkChart.nslots(this.address(), index);
    }

    public static NkChart create(long address) {
        return (NkChart)NkChart.wrap(NkChart.class, (long)address);
    }

    @Nullable
    public static NkChart createSafe(long address) {
        return address == 0L ? null : (NkChart)NkChart.wrap(NkChart.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkChart.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkChart.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int nslot(long struct) {
        return UNSAFE.getInt(null, struct + (long)SLOT);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static float nw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)W);
    }

    public static float nh(long struct) {
        return UNSAFE.getFloat(null, struct + (long)H);
    }

    public static NkChartSlot.Buffer nslots(long struct) {
        return NkChartSlot.create(struct + (long)SLOTS, 4);
    }

    public static NkChartSlot nslots(long struct, int index) {
        return NkChartSlot.create(struct + (long)SLOTS + Checks.check((int)index, (int)4) * (long)NkChartSlot.SIZEOF);
    }

    static {
        Struct.Layout layout = NkChart.__struct((Struct.Member[])new Struct.Member[]{NkChart.__member((int)4), NkChart.__member((int)4), NkChart.__member((int)4), NkChart.__member((int)4), NkChart.__member((int)4), NkChart.__array((int)NkChartSlot.SIZEOF, (int)NkChartSlot.ALIGNOF, (int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SLOT = layout.offsetof(0);
        X = layout.offsetof(1);
        Y = layout.offsetof(2);
        W = layout.offsetof(3);
        H = layout.offsetof(4);
        SLOTS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NkChart, Buffer> {
        private static final NkChart ELEMENT_FACTORY = NkChart.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkChart getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int slot() {
            return NkChart.nslot(this.address());
        }

        public float x() {
            return NkChart.nx(this.address());
        }

        public float y() {
            return NkChart.ny(this.address());
        }

        public float w() {
            return NkChart.nw(this.address());
        }

        public float h() {
            return NkChart.nh(this.address());
        }

        @NativeType(value="struct nk_chart_slot[NK_CHART_MAX_SLOT]")
        public NkChartSlot.Buffer slots() {
            return NkChart.nslots(this.address());
        }

        @NativeType(value="struct nk_chart_slot")
        public NkChartSlot slots(int index) {
            return NkChart.nslots(this.address(), index);
        }
    }
}

