/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nfdwindowhandle_t")
public class NFDWindowHandle
extends Struct<NFDWindowHandle>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int HANDLE;

    protected NFDWindowHandle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected NFDWindowHandle create(long address, @Nullable ByteBuffer container) {
        return new NFDWindowHandle(address, container);
    }

    public NFDWindowHandle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NFDWindowHandle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long type() {
        return NFDWindowHandle.ntype(this.address());
    }

    @NativeType(value="void *")
    public long handle() {
        return NFDWindowHandle.nhandle(this.address());
    }

    public NFDWindowHandle type(@NativeType(value="size_t") long value) {
        NFDWindowHandle.ntype(this.address(), value);
        return this;
    }

    public NFDWindowHandle handle(@NativeType(value="void *") long value) {
        NFDWindowHandle.nhandle(this.address(), value);
        return this;
    }

    public NFDWindowHandle set(long type, long handle) {
        this.type(type);
        this.handle(handle);
        return this;
    }

    public NFDWindowHandle set(NFDWindowHandle src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NFDWindowHandle malloc() {
        return new NFDWindowHandle(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static NFDWindowHandle calloc() {
        return new NFDWindowHandle(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static NFDWindowHandle create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new NFDWindowHandle(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static NFDWindowHandle create(long address) {
        return new NFDWindowHandle(address, null);
    }

    public static @Nullable NFDWindowHandle createSafe(long address) {
        return address == 0L ? null : new NFDWindowHandle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)NFDWindowHandle.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDWindowHandle.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NFDWindowHandle malloc(MemoryStack stack) {
        return new NFDWindowHandle(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NFDWindowHandle calloc(MemoryStack stack) {
        return new NFDWindowHandle(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntype(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TYPE));
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static void ntype(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TYPE), (long)value);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)value);
    }

    static {
        Struct.Layout layout = NFDWindowHandle.__struct((Struct.Member[])new Struct.Member[]{NFDWindowHandle.__member((int)POINTER_SIZE), NFDWindowHandle.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        HANDLE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NFDWindowHandle, Buffer>
    implements NativeResource {
        private static final NFDWindowHandle ELEMENT_FACTORY = NFDWindowHandle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected NFDWindowHandle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long type() {
            return NFDWindowHandle.ntype(this.address());
        }

        @NativeType(value="void *")
        public long handle() {
            return NFDWindowHandle.nhandle(this.address());
        }

        public Buffer type(@NativeType(value="size_t") long value) {
            NFDWindowHandle.ntype(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            NFDWindowHandle.nhandle(this.address(), value);
            return this;
        }
    }
}

