/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.util.meshoptimizer.LibMeshOptimizer;
import org.lwjgl.util.meshoptimizer.MeshoptAllocateI;
import org.lwjgl.util.meshoptimizer.MeshoptBounds;
import org.lwjgl.util.meshoptimizer.MeshoptDeallocateI;
import org.lwjgl.util.meshoptimizer.MeshoptMeshlet;
import org.lwjgl.util.meshoptimizer.MeshoptOverdrawStatistics;
import org.lwjgl.util.meshoptimizer.MeshoptStream;
import org.lwjgl.util.meshoptimizer.MeshoptVertexCacheStatistics;
import org.lwjgl.util.meshoptimizer.MeshoptVertexFetchStatistics;

public class MeshOptimizer {
    public static final int MESHOPTIMIZER_VERSION = 220;
    public static final int meshopt_EncodeExpSeparate = 0;
    public static final int meshopt_EncodeExpSharedVector = 1;
    public static final int meshopt_EncodeExpSharedComponent = 2;
    public static final int meshopt_EncodeExpClamped = 3;
    public static final int meshopt_SimplifyLockBorder = 1;
    public static final int meshopt_SimplifySparse = 2;
    public static final int meshopt_SimplifyErrorAbsolute = 4;
    public static final int meshopt_SimplifyPrune = 8;

    protected MeshOptimizer() {
        throw new UnsupportedOperationException();
    }

    public static native long nmeshopt_generateVertexRemap(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long meshopt_generateVertexRemap(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") @Nullable IntBuffer indices, @NativeType(value="size_t") long index_count, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)vertex_count);
            Checks.checkSafe((Buffer)indices, (long)index_count);
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_generateVertexRemap(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddressSafe((IntBuffer)indices), index_count, MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size);
    }

    public static native long nmeshopt_generateVertexRemapMulti(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long meshopt_generateVertexRemapMulti(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") @Nullable IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="struct meshopt_Stream const *") MeshoptStream.Buffer streams) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)vertex_count);
            Struct.validate((long)streams.address(), (int)streams.remaining(), (int)MeshoptStream.SIZEOF, MeshoptStream::validate);
        }
        return MeshOptimizer.nmeshopt_generateVertexRemapMulti(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddressSafe((IntBuffer)indices), Checks.remainingSafe((Buffer)indices), vertex_count, streams.address(), streams.remaining());
    }

    public static native void nmeshopt_remapVertexBuffer(long var0, long var2, long var4, long var6, long var8);

    public static void meshopt_remapVertexBuffer(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size, @NativeType(value="unsigned int const *") IntBuffer remap) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
            Checks.check((Buffer)remap, (long)vertex_count);
        }
        MeshOptimizer.nmeshopt_remapVertexBuffer(MemoryUtil.memAddress((ByteBuffer)destination), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size, MemoryUtil.memAddress((IntBuffer)remap));
    }

    public static native void nmeshopt_remapIndexBuffer(long var0, long var2, long var4, long var6);

    public static void meshopt_remapIndexBuffer(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") @Nullable IntBuffer indices, @NativeType(value="size_t") long index_count, @NativeType(value="unsigned int const *") IntBuffer remap) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)index_count);
            Checks.checkSafe((Buffer)indices, (long)index_count);
        }
        MeshOptimizer.nmeshopt_remapIndexBuffer(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddressSafe((IntBuffer)indices), index_count, MemoryUtil.memAddress((IntBuffer)remap));
    }

    public static native void nmeshopt_generateShadowIndexBuffer(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    public static void meshopt_generateShadowIndexBuffer(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size, @NativeType(value="size_t") long vertex_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_stride));
        }
        MeshOptimizer.nmeshopt_generateShadowIndexBuffer(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size, vertex_stride);
    }

    public static native void nmeshopt_generateShadowIndexBufferMulti(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void meshopt_generateShadowIndexBufferMulti(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="struct meshopt_Stream const *") MeshoptStream.Buffer streams) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
            Struct.validate((long)streams.address(), (int)streams.remaining(), (int)MeshoptStream.SIZEOF, MeshoptStream::validate);
        }
        MeshOptimizer.nmeshopt_generateShadowIndexBufferMulti(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, streams.address(), streams.remaining());
    }

    public static native void nmeshopt_generateAdjacencyIndexBuffer(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void meshopt_generateAdjacencyIndexBuffer(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)(indices.remaining() << 1));
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_generateAdjacencyIndexBuffer(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride);
    }

    public static native void nmeshopt_generateTessellationIndexBuffer(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void meshopt_generateTessellationIndexBuffer(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)(indices.remaining() << 2));
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_generateTessellationIndexBuffer(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride);
    }

    public static native long nmeshopt_generateProvokingIndexBuffer(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long meshopt_generateProvokingIndexBuffer(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int *") IntBuffer reorder, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long index_count, @NativeType(value="size_t") long vertex_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)index_count);
            Checks.check((Buffer)reorder, (long)(vertex_count + index_count / 3L));
            Checks.check((Buffer)indices, (long)index_count);
        }
        return MeshOptimizer.nmeshopt_generateProvokingIndexBuffer(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)reorder), MemoryUtil.memAddress((IntBuffer)indices), index_count, vertex_count);
    }

    public static native void nmeshopt_optimizeVertexCache(long var0, long var2, long var4, long var6);

    public static void meshopt_optimizeVertexCache(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
        }
        MeshOptimizer.nmeshopt_optimizeVertexCache(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count);
    }

    public static native void nmeshopt_optimizeVertexCacheStrip(long var0, long var2, long var4, long var6);

    public static void meshopt_optimizeVertexCacheStrip(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
        }
        MeshOptimizer.nmeshopt_optimizeVertexCacheStrip(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count);
    }

    public static native void nmeshopt_optimizeVertexCacheFifo(long var0, long var2, long var4, long var6, int var8);

    public static void meshopt_optimizeVertexCacheFifo(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="unsigned int") int cache_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
        }
        MeshOptimizer.nmeshopt_optimizeVertexCacheFifo(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, cache_size);
    }

    public static native void nmeshopt_optimizeOverdraw(long var0, long var2, long var4, long var6, long var8, long var10, float var12);

    public static void meshopt_optimizeOverdraw(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, float threshold) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_optimizeOverdraw(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, threshold);
    }

    public static native long nmeshopt_optimizeVertexFetch(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="size_t")
    public static long meshopt_optimizeVertexFetch(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="unsigned int *") IntBuffer indices, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(vertex_count * vertex_size));
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_optimizeVertexFetch(MemoryUtil.memAddress((ByteBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size);
    }

    public static native long nmeshopt_optimizeVertexFetchRemap(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long meshopt_optimizeVertexFetchRemap(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices) {
        return MeshOptimizer.nmeshopt_optimizeVertexFetchRemap(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), destination.remaining());
    }

    public static native long nmeshopt_encodeIndexBuffer(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long meshopt_encodeIndexBuffer(@NativeType(value="unsigned char *") ByteBuffer buffer, @NativeType(value="unsigned int const *") IntBuffer indices) {
        return MeshOptimizer.nmeshopt_encodeIndexBuffer(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining());
    }

    @NativeType(value="size_t")
    public static native long meshopt_encodeIndexBufferBound(@NativeType(value="size_t") long var0, @NativeType(value="size_t") long var2);

    public static native void meshopt_encodeIndexVersion(int var0);

    public static native int nmeshopt_decodeIndexBuffer(long var0, long var2, long var4, long var6, long var8);

    public static int meshopt_decodeIndexBuffer(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long index_count, @NativeType(value="size_t") long index_size, @NativeType(value="unsigned char const *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(index_count * index_size));
        }
        return MeshOptimizer.nmeshopt_decodeIndexBuffer(MemoryUtil.memAddress((ByteBuffer)destination), index_count, index_size, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    public static native long nmeshopt_encodeIndexSequence(long var0, long var2, long var4, long var6);

    @NativeType(value="size_t")
    public static long meshopt_encodeIndexSequence(@NativeType(value="unsigned char *") ByteBuffer buffer, @NativeType(value="unsigned int const *") IntBuffer indices) {
        return MeshOptimizer.nmeshopt_encodeIndexSequence(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining());
    }

    @NativeType(value="size_t")
    public static native long meshopt_encodeIndexSequenceBound(@NativeType(value="size_t") long var0, @NativeType(value="size_t") long var2);

    public static native int nmeshopt_decodeIndexSequence(long var0, long var2, long var4, long var6, long var8);

    public static int meshopt_decodeIndexSequence(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long index_count, @NativeType(value="size_t") long index_size, @NativeType(value="unsigned char const *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(index_count * index_size));
        }
        return MeshOptimizer.nmeshopt_decodeIndexSequence(MemoryUtil.memAddress((ByteBuffer)destination), index_count, index_size, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    public static native long nmeshopt_encodeVertexBuffer(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="size_t")
    public static long meshopt_encodeVertexBuffer(@NativeType(value="unsigned char *") ByteBuffer buffer, @NativeType(value="void const *") ByteBuffer vertices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertices, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_encodeVertexBuffer(MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining(), MemoryUtil.memAddress((ByteBuffer)vertices), vertex_count, vertex_size);
    }

    @NativeType(value="size_t")
    public static native long meshopt_encodeVertexBufferBound(@NativeType(value="size_t") long var0, @NativeType(value="size_t") long var2);

    public static native void meshopt_encodeVertexVersion(int var0);

    public static native int nmeshopt_decodeVertexBuffer(long var0, long var2, long var4, long var6, long var8);

    public static int meshopt_decodeVertexBuffer(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size, @NativeType(value="unsigned char const *") ByteBuffer buffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(vertex_count * vertex_size));
        }
        return MeshOptimizer.nmeshopt_decodeVertexBuffer(MemoryUtil.memAddress((ByteBuffer)destination), vertex_count, vertex_size, MemoryUtil.memAddress((ByteBuffer)buffer), buffer.remaining());
    }

    public static native void nmeshopt_decodeFilterOct(long var0, long var2, long var4);

    public static void meshopt_decodeFilterOct(@NativeType(value="void *") ByteBuffer buffer, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (long)(count * stride));
        }
        MeshOptimizer.nmeshopt_decodeFilterOct(MemoryUtil.memAddress((ByteBuffer)buffer), count, stride);
    }

    public static void meshopt_decodeFilterOct(@NativeType(value="void *") ShortBuffer buffer, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (long)(count * stride >> 1));
        }
        MeshOptimizer.nmeshopt_decodeFilterOct(MemoryUtil.memAddress((ShortBuffer)buffer), count, stride);
    }

    public static native void nmeshopt_decodeFilterQuat(long var0, long var2, long var4);

    public static void meshopt_decodeFilterQuat(@NativeType(value="void *") ByteBuffer buffer, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (long)(count * stride));
        }
        MeshOptimizer.nmeshopt_decodeFilterQuat(MemoryUtil.memAddress((ByteBuffer)buffer), count, stride);
    }

    public static void meshopt_decodeFilterQuat(@NativeType(value="void *") ShortBuffer buffer, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (long)(count * stride >> 1));
        }
        MeshOptimizer.nmeshopt_decodeFilterQuat(MemoryUtil.memAddress((ShortBuffer)buffer), count, stride);
    }

    public static native void nmeshopt_decodeFilterExp(long var0, long var2, long var4);

    public static void meshopt_decodeFilterExp(@NativeType(value="void *") ByteBuffer buffer, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (long)(count * stride));
        }
        MeshOptimizer.nmeshopt_decodeFilterExp(MemoryUtil.memAddress((ByteBuffer)buffer), count, stride);
    }

    public static void meshopt_decodeFilterExp(@NativeType(value="void *") IntBuffer buffer, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)buffer, (long)(count * stride >> 2));
        }
        MeshOptimizer.nmeshopt_decodeFilterExp(MemoryUtil.memAddress((IntBuffer)buffer), count, stride);
    }

    public static native void nmeshopt_encodeFilterOct(long var0, long var2, long var4, int var6, long var7);

    public static void meshopt_encodeFilterOct(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride, int bits, @NativeType(value="float const *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(count * 4L * (stride >> 2)));
            Checks.check((Buffer)data, (long)(count * 4L));
        }
        MeshOptimizer.nmeshopt_encodeFilterOct(MemoryUtil.memAddress((ByteBuffer)destination), count, stride, bits, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void meshopt_encodeFilterOct(@NativeType(value="void *") ShortBuffer destination, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride, int bits, @NativeType(value="float const *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(count * 4L * (stride >> 2) >> 1));
            Checks.check((Buffer)data, (long)(count * 4L));
        }
        MeshOptimizer.nmeshopt_encodeFilterOct(MemoryUtil.memAddress((ShortBuffer)destination), count, stride, bits, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native void nmeshopt_encodeFilterQuat(long var0, long var2, long var4, int var6, long var7);

    public static void meshopt_encodeFilterQuat(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride, int bits, @NativeType(value="float const *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(count * 4L * 2L));
            Checks.check((Buffer)data, (long)(count * 4L));
        }
        MeshOptimizer.nmeshopt_encodeFilterQuat(MemoryUtil.memAddress((ByteBuffer)destination), count, stride, bits, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static void meshopt_encodeFilterQuat(@NativeType(value="void *") ShortBuffer destination, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride, int bits, @NativeType(value="float const *") FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(count * 4L * 2L >> 1));
            Checks.check((Buffer)data, (long)(count * 4L));
        }
        MeshOptimizer.nmeshopt_encodeFilterQuat(MemoryUtil.memAddress((ShortBuffer)destination), count, stride, bits, MemoryUtil.memAddress((FloatBuffer)data));
    }

    public static native void nmeshopt_encodeFilterExp(long var0, long var2, long var4, int var6, long var7, int var9);

    public static void meshopt_encodeFilterExp(@NativeType(value="void *") ByteBuffer destination, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride, int bits, @NativeType(value="float const *") FloatBuffer data, @NativeType(value="enum meshopt_EncodeExpMode") int mode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(count * (stride >> 2) * 4L));
            Checks.check((Buffer)data, (long)(count * (stride >> 2)));
        }
        MeshOptimizer.nmeshopt_encodeFilterExp(MemoryUtil.memAddress((ByteBuffer)destination), count, stride, bits, MemoryUtil.memAddress((FloatBuffer)data), mode);
    }

    public static void meshopt_encodeFilterExp(@NativeType(value="void *") IntBuffer destination, @NativeType(value="size_t") long count, @NativeType(value="size_t") long stride, int bits, @NativeType(value="float const *") FloatBuffer data, @NativeType(value="enum meshopt_EncodeExpMode") int mode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)(count * (stride >> 2) * 4L >> 2));
            Checks.check((Buffer)data, (long)(count * (stride >> 2)));
        }
        MeshOptimizer.nmeshopt_encodeFilterExp(MemoryUtil.memAddress((IntBuffer)destination), count, stride, bits, MemoryUtil.memAddress((FloatBuffer)data), mode);
    }

    public static native long nmeshopt_simplify(long var0, long var2, long var4, long var6, long var8, long var10, long var12, float var14, int var15, long var16);

    @NativeType(value="size_t")
    public static long meshopt_simplify(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="size_t") long target_index_count, float target_error, @NativeType(value="unsigned int") int options, @NativeType(value="float *") @Nullable FloatBuffer result_error) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
            Checks.checkSafe((Buffer)result_error, (int)1);
        }
        return MeshOptimizer.nmeshopt_simplify(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, target_index_count, target_error, options, MemoryUtil.memAddressSafe((FloatBuffer)result_error));
    }

    public static native long nmeshopt_simplifyWithAttributes(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, long var22, float var24, int var25, long var26);

    @NativeType(value="size_t")
    public static long meshopt_simplifyWithAttributes(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="float const *") FloatBuffer vertex_attributes, @NativeType(value="size_t") long vertex_attributes_stride, @NativeType(value="float const *") FloatBuffer attribute_weights, @NativeType(value="unsigned char const *") @Nullable ByteBuffer vertex_lock, @NativeType(value="size_t") long target_index_count, float target_error, @NativeType(value="unsigned int") int options, @NativeType(value="float *") @Nullable FloatBuffer result_error) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
            Checks.check((Buffer)vertex_attributes, (long)(vertex_count * (vertex_attributes_stride >>> 2)));
            Checks.checkSafe((Buffer)vertex_lock, (long)vertex_count);
            Checks.checkSafe((Buffer)result_error, (int)1);
        }
        return MeshOptimizer.nmeshopt_simplifyWithAttributes(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, MemoryUtil.memAddress((FloatBuffer)vertex_attributes), vertex_attributes_stride, MemoryUtil.memAddress((FloatBuffer)attribute_weights), attribute_weights.remaining(), MemoryUtil.memAddressSafe((ByteBuffer)vertex_lock), target_index_count, target_error, options, MemoryUtil.memAddressSafe((FloatBuffer)result_error));
    }

    public static native long nmeshopt_simplifySloppy(long var0, long var2, long var4, long var6, long var8, long var10, long var12, float var14, long var15);

    @NativeType(value="size_t")
    public static long meshopt_simplifySloppy(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="size_t") long target_index_count, float target_error, @NativeType(value="float *") @Nullable FloatBuffer result_error) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
            Checks.checkSafe((Buffer)result_error, (int)1);
        }
        return MeshOptimizer.nmeshopt_simplifySloppy(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, target_index_count, target_error, MemoryUtil.memAddressSafe((FloatBuffer)result_error));
    }

    public static native long nmeshopt_simplifyPoints(long var0, long var2, long var4, long var6, long var8, long var10, float var12, long var13);

    @NativeType(value="size_t")
    public static long meshopt_simplifyPoints(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="float const *") @Nullable FloatBuffer vertex_colors, @NativeType(value="size_t") long vertex_colors_stride, float color_weight, @NativeType(value="size_t") long target_vertex_count) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)target_vertex_count);
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
            Checks.checkSafe((Buffer)vertex_colors, (long)(vertex_count * (vertex_colors_stride >>> 2)));
        }
        return MeshOptimizer.nmeshopt_simplifyPoints(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, MemoryUtil.memAddressSafe((FloatBuffer)vertex_colors), vertex_colors_stride, color_weight, target_vertex_count);
    }

    public static native float nmeshopt_simplifyScale(long var0, long var2, long var4);

    public static float meshopt_simplifyScale(@NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        return MeshOptimizer.nmeshopt_simplifyScale(MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride);
    }

    public static native long nmeshopt_stripify(long var0, long var2, long var4, long var6, int var8);

    @NativeType(value="size_t")
    public static long meshopt_stripify(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="unsigned int") int restart_index) {
        return MeshOptimizer.nmeshopt_stripify(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, restart_index);
    }

    @NativeType(value="size_t")
    public static native long meshopt_stripifyBound(@NativeType(value="size_t") long var0);

    public static native long nmeshopt_unstripify(long var0, long var2, long var4, int var6);

    @NativeType(value="size_t")
    public static long meshopt_unstripify(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="unsigned int") int restart_index) {
        return MeshOptimizer.nmeshopt_unstripify(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), restart_index);
    }

    @NativeType(value="size_t")
    public static native long meshopt_unstripifyBound(@NativeType(value="size_t") long var0);

    public static native void nmeshopt_analyzeVertexCache(long var0, long var2, long var4, int var6, int var7, int var8, long var9);

    @NativeType(value="struct meshopt_VertexCacheStatistics")
    public static MeshoptVertexCacheStatistics meshopt_analyzeVertexCache(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="unsigned int") int cache_size, @NativeType(value="unsigned int") int warp_size, @NativeType(value="unsigned int") int primgroup_size, @NativeType(value="struct meshopt_VertexCacheStatistics") MeshoptVertexCacheStatistics __result) {
        MeshOptimizer.nmeshopt_analyzeVertexCache(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, cache_size, warp_size, primgroup_size, __result.address());
        return __result;
    }

    public static native void nmeshopt_analyzeOverdraw(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="struct meshopt_OverdrawStatistics")
    public static MeshoptOverdrawStatistics meshopt_analyzeOverdraw(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="struct meshopt_OverdrawStatistics") MeshoptOverdrawStatistics __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_analyzeOverdraw(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, __result.address());
        return __result;
    }

    public static native void nmeshopt_analyzeVertexFetch(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="struct meshopt_VertexFetchStatistics")
    public static MeshoptVertexFetchStatistics meshopt_analyzeVertexFetch(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_size, @NativeType(value="struct meshopt_VertexFetchStatistics") MeshoptVertexFetchStatistics __result) {
        MeshOptimizer.nmeshopt_analyzeVertexFetch(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, vertex_size, __result.address());
        return __result;
    }

    public static native long nmeshopt_buildMeshlets(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, float var20);

    @NativeType(value="size_t")
    public static long meshopt_buildMeshlets(@NativeType(value="struct meshopt_Meshlet *") MeshoptMeshlet.Buffer meshlets, @NativeType(value="unsigned int *") IntBuffer meshlet_vertices, @NativeType(value="unsigned char *") ByteBuffer meshlet_triangles, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="size_t") long max_vertices, @NativeType(value="size_t") long max_triangles, float cone_weight) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)meshlet_vertices, (long)((long)meshlets.remaining() * max_vertices));
            Checks.check((Buffer)meshlet_triangles, (long)((long)meshlets.remaining() * max_triangles * 3L));
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        return MeshOptimizer.nmeshopt_buildMeshlets(meshlets.address(), MemoryUtil.memAddress((IntBuffer)meshlet_vertices), MemoryUtil.memAddress((ByteBuffer)meshlet_triangles), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, max_vertices, max_triangles, cone_weight);
    }

    public static native long nmeshopt_buildMeshletsScan(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    @NativeType(value="size_t")
    public static long meshopt_buildMeshletsScan(@NativeType(value="struct meshopt_Meshlet *") MeshoptMeshlet.Buffer meshlets, @NativeType(value="unsigned int *") IntBuffer meshlet_vertices, @NativeType(value="unsigned char *") ByteBuffer meshlet_triangles, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long max_vertices, @NativeType(value="size_t") long max_triangles) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)meshlet_vertices, (long)((long)meshlets.remaining() * max_vertices));
            Checks.check((Buffer)meshlet_triangles, (long)((long)meshlets.remaining() * max_triangles * 3L));
        }
        return MeshOptimizer.nmeshopt_buildMeshletsScan(meshlets.address(), MemoryUtil.memAddress((IntBuffer)meshlet_vertices), MemoryUtil.memAddress((ByteBuffer)meshlet_triangles), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), vertex_count, max_vertices, max_triangles);
    }

    @NativeType(value="size_t")
    public static native long meshopt_buildMeshletsBound(@NativeType(value="size_t") long var0, @NativeType(value="size_t") long var2, @NativeType(value="size_t") long var4);

    public static native void nmeshopt_optimizeMeshlet(long var0, long var2, long var4, long var6);

    public static void meshopt_optimizeMeshlet(@NativeType(value="unsigned int *") IntBuffer meshlet_vertices, @NativeType(value="unsigned char *") ByteBuffer meshlet_triangles) {
        MeshOptimizer.nmeshopt_optimizeMeshlet(MemoryUtil.memAddress((IntBuffer)meshlet_vertices), MemoryUtil.memAddress((ByteBuffer)meshlet_triangles), Integer.toUnsignedLong(meshlet_triangles.remaining()) / 3L, meshlet_vertices.remaining());
    }

    public static native void nmeshopt_computeClusterBounds(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="struct meshopt_Bounds")
    public static MeshoptBounds meshopt_computeClusterBounds(@NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="struct meshopt_Bounds") MeshoptBounds __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_computeClusterBounds(MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, __result.address());
        return __result;
    }

    public static native void nmeshopt_computeMeshletBounds(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    @NativeType(value="struct meshopt_Bounds")
    public static MeshoptBounds meshopt_computeMeshletBounds(@NativeType(value="unsigned int const *") IntBuffer meshlet_vertices, @NativeType(value="unsigned char const *") ByteBuffer meshlet_triangles, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride, @NativeType(value="struct meshopt_Bounds") MeshoptBounds __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_computeMeshletBounds(MemoryUtil.memAddress((IntBuffer)meshlet_vertices), MemoryUtil.memAddress((ByteBuffer)meshlet_triangles), Integer.toUnsignedLong(meshlet_triangles.remaining()) / 3L, MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride, __result.address());
        return __result;
    }

    public static native void nmeshopt_spatialSortRemap(long var0, long var2, long var4, long var6);

    public static void meshopt_spatialSortRemap(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (long)vertex_count);
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_spatialSortRemap(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride);
    }

    public static native void nmeshopt_spatialSortTriangles(long var0, long var2, long var4, long var6, long var8, long var10);

    public static void meshopt_spatialSortTriangles(@NativeType(value="unsigned int *") IntBuffer destination, @NativeType(value="unsigned int const *") IntBuffer indices, @NativeType(value="float const *") FloatBuffer vertex_positions, @NativeType(value="size_t") long vertex_count, @NativeType(value="size_t") long vertex_positions_stride) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)destination, (int)indices.remaining());
            Checks.check((Buffer)vertex_positions, (long)(vertex_count * (vertex_positions_stride >>> 2)));
        }
        MeshOptimizer.nmeshopt_spatialSortTriangles(MemoryUtil.memAddress((IntBuffer)destination), MemoryUtil.memAddress((IntBuffer)indices), indices.remaining(), MemoryUtil.memAddress((FloatBuffer)vertex_positions), vertex_count, vertex_positions_stride);
    }

    public static native void nmeshopt_setAllocator(long var0, long var2);

    public static void meshopt_setAllocator(@NativeType(value="void * (*) (size_t)") MeshoptAllocateI allocate, @NativeType(value="void (*) (void *)") MeshoptDeallocateI deallocate) {
        MeshOptimizer.nmeshopt_setAllocator(allocate.address(), deallocate.address());
    }

    static native int nmeshopt_quantizeUnorm_ref(float var0, int var1);

    static int meshopt_quantizeUnorm_ref(float v, int N) {
        return MeshOptimizer.nmeshopt_quantizeUnorm_ref(v, N);
    }

    static native int nmeshopt_quantizeSnorm_ref(float var0, int var1);

    static int meshopt_quantizeSnorm_ref(float v, int N) {
        return MeshOptimizer.nmeshopt_quantizeSnorm_ref(v, N);
    }

    static native short nmeshopt_quantizeHalf_ref(float var0);

    static short meshopt_quantizeHalf_ref(float v) {
        return MeshOptimizer.nmeshopt_quantizeHalf_ref(v);
    }

    static native float nmeshopt_quantizeFloat_ref(float var0, int var1);

    static float meshopt_quantizeFloat_ref(float v, int N) {
        return MeshOptimizer.nmeshopt_quantizeFloat_ref(v, N);
    }

    static native float nmeshopt_dequantizeHalf_ref(short var0);

    static float meshopt_dequantizeHalf_ref(@NativeType(value="unsigned short") short h) {
        return MeshOptimizer.nmeshopt_dequantizeHalf_ref(h);
    }

    public static int meshopt_quantizeUnorm(float v, int N) {
        float scale = (1 << N) - 1;
        v = v >= 0.0f ? v : 0.0f;
        v = v <= 1.0f ? v : 1.0f;
        return (int)(v * scale + 0.5f);
    }

    public static int meshopt_quantizeSnorm(float v, int N) {
        float scale = (1 << N - 1) - 1;
        float round = v >= 0.0f ? 0.5f : -0.5f;
        v = v >= -1.0f ? v : -1.0f;
        v = v <= 1.0f ? v : 1.0f;
        return (int)(v * scale + round);
    }

    public static short meshopt_quantizeHalf(float v) {
        int ui = Float.floatToRawIntBits(v);
        int s = ui >>> 16 & 0x8000;
        int em = ui & Integer.MAX_VALUE;
        int h = em - 0x38000000 + 4096 >> 13;
        h = em < 0x38800000 ? 0 : h;
        h = em >= 1199570944 ? 31744 : h;
        h = em > 2139095040 ? 32256 : h;
        return (short)(s | h);
    }

    public static float meshopt_quantizeFloat(float v, int N) {
        int ui = Float.floatToRawIntBits(v);
        int mask = (1 << 23 - N) - 1;
        int round = 1 << 23 - N >> 1;
        int e = ui & 0x7F800000;
        int rui = ui + round & ~mask;
        ui = e == 2139095040 ? ui : rui;
        ui = e == 0 ? 0 : ui;
        return Float.intBitsToFloat(ui);
    }

    public static float meshopt_dequantizeHalf(@NativeType(value="unsigned short") short h) {
        int s = (h & 0x8000) << 16;
        int em = h & Short.MAX_VALUE;
        int r = em + 114688 << 13;
        r = em < 1024 ? 0 : r;
        return Float.intBitsToFloat(s | (r += em >= 31744 ? 0x38000000 : 0));
    }

    static {
        LibMeshOptimizer.initialize();
    }
}

