/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.LibMeow;

@NativeType(value="struct meow_u128")
public class MeowU128
extends Struct<MeowU128> {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    protected MeowU128(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MeowU128 create(long address, @Nullable ByteBuffer container) {
        return new MeowU128(address, container);
    }

    public MeowU128(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeowU128.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static MeowU128 create(long address) {
        return new MeowU128(address, null);
    }

    public static @Nullable MeowU128 createSafe(long address) {
        return address == 0L ? null : new MeowU128(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    static {
        LibMeow.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = MeowU128.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<MeowU128, Buffer> {
        private static final MeowU128 ELEMENT_FACTORY = MeowU128.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected MeowU128 getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

