/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.LibMeow;

@NativeType(value="struct meow_hash_state")
public class MeowHashState
extends Struct<MeowHashState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    protected MeowHashState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected MeowHashState create(long address, @Nullable ByteBuffer container) {
        return new MeowHashState(address, container);
    }

    public MeowHashState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeowHashState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public static MeowHashState malloc() {
        return new MeowHashState(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static MeowHashState calloc() {
        return new MeowHashState(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static MeowHashState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new MeowHashState(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static MeowHashState create(long address) {
        return new MeowHashState(address, null);
    }

    public static @Nullable MeowHashState createSafe(long address) {
        return address == 0L ? null : new MeowHashState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)MeowHashState.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeowHashState.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static MeowHashState mallocStack() {
        return MeowHashState.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHashState callocStack() {
        return MeowHashState.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHashState mallocStack(MemoryStack stack) {
        return MeowHashState.malloc(stack);
    }

    @Deprecated
    public static MeowHashState callocStack(MemoryStack stack) {
        return MeowHashState.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return MeowHashState.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return MeowHashState.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MeowHashState.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MeowHashState.calloc(capacity, stack);
    }

    public static MeowHashState malloc(MemoryStack stack) {
        return new MeowHashState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MeowHashState calloc(MemoryStack stack) {
        return new MeowHashState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        LibMeow.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = MeowHashState.offsets(MemoryUtil.memAddress((IntBuffer)offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<MeowHashState, Buffer>
    implements NativeResource {
        private static final MeowHashState ELEMENT_FACTORY = MeowHashState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected MeowHashState getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

