/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOrcCDependenceMapPair;
import org.lwjgl.llvm.LLVMOrcCSymbolsList;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolDependenceGroup
extends Struct<LLVMOrcCSymbolDependenceGroup>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SYMBOLS;
    public static final int DEPENDENCIES;
    public static final int NUMDEPENDENCIES;

    protected LLVMOrcCSymbolDependenceGroup(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LLVMOrcCSymbolDependenceGroup create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCSymbolDependenceGroup(address, container);
    }

    public LLVMOrcCSymbolDependenceGroup(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOrcCSymbolDependenceGroup.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public LLVMOrcCSymbolsList Symbols() {
        return LLVMOrcCSymbolDependenceGroup.nSymbols(this.address());
    }

    @NativeType(value="LLVMOrcCDependenceMapPairs")
    public LLVMOrcCDependenceMapPair.Buffer Dependencies() {
        return LLVMOrcCSymbolDependenceGroup.nDependencies(this.address());
    }

    @NativeType(value="size_t")
    public long NumDependencies() {
        return LLVMOrcCSymbolDependenceGroup.nNumDependencies(this.address());
    }

    public LLVMOrcCSymbolDependenceGroup Symbols(LLVMOrcCSymbolsList value) {
        LLVMOrcCSymbolDependenceGroup.nSymbols(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup Symbols(Consumer<LLVMOrcCSymbolsList> consumer) {
        consumer.accept(this.Symbols());
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup Dependencies(@NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer value) {
        LLVMOrcCSymbolDependenceGroup.nDependencies(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup set(LLVMOrcCSymbolsList Symbols, LLVMOrcCDependenceMapPair.Buffer Dependencies) {
        this.Symbols(Symbols);
        this.Dependencies(Dependencies);
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup set(LLVMOrcCSymbolDependenceGroup src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolDependenceGroup malloc() {
        return new LLVMOrcCSymbolDependenceGroup(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LLVMOrcCSymbolDependenceGroup calloc() {
        return new LLVMOrcCSymbolDependenceGroup(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LLVMOrcCSymbolDependenceGroup create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LLVMOrcCSymbolDependenceGroup(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LLVMOrcCSymbolDependenceGroup create(long address) {
        return new LLVMOrcCSymbolDependenceGroup(address, null);
    }

    public static @Nullable LLVMOrcCSymbolDependenceGroup createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCSymbolDependenceGroup(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LLVMOrcCSymbolDependenceGroup.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolDependenceGroup.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCSymbolDependenceGroup malloc(MemoryStack stack) {
        return new LLVMOrcCSymbolDependenceGroup(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCSymbolDependenceGroup calloc(MemoryStack stack) {
        return new LLVMOrcCSymbolDependenceGroup(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LLVMOrcCSymbolsList nSymbols(long struct) {
        return LLVMOrcCSymbolsList.create(struct + (long)SYMBOLS);
    }

    public static LLVMOrcCDependenceMapPair.Buffer nDependencies(long struct) {
        return LLVMOrcCDependenceMapPair.create(MemoryUtil.memGetAddress((long)(struct + (long)DEPENDENCIES)), (int)LLVMOrcCSymbolDependenceGroup.nNumDependencies(struct));
    }

    public static long nNumDependencies(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NUMDEPENDENCIES));
    }

    public static void nSymbols(long struct, LLVMOrcCSymbolsList value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SYMBOLS), (long)LLVMOrcCSymbolsList.SIZEOF);
    }

    public static void nDependencies(long struct, LLVMOrcCDependenceMapPair.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DEPENDENCIES), (long)value.address());
        LLVMOrcCSymbolDependenceGroup.nNumDependencies(struct, value.remaining());
    }

    public static void nNumDependencies(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NUMDEPENDENCIES), (long)value);
    }

    public static void validate(long struct) {
        LLVMOrcCSymbolsList.validate(struct + (long)SYMBOLS);
        long NumDependencies = LLVMOrcCSymbolDependenceGroup.nNumDependencies(struct);
        long Dependencies = MemoryUtil.memGetAddress((long)(struct + (long)DEPENDENCIES));
        Checks.check((long)Dependencies);
        LLVMOrcCSymbolDependenceGroup.validate((long)Dependencies, (long)NumDependencies, (int)LLVMOrcCDependenceMapPair.SIZEOF, LLVMOrcCDependenceMapPair::validate);
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolDependenceGroup.__struct((Struct.Member[])new Struct.Member[]{LLVMOrcCSymbolDependenceGroup.__member((int)LLVMOrcCSymbolsList.SIZEOF, (int)LLVMOrcCSymbolsList.ALIGNOF), LLVMOrcCSymbolDependenceGroup.__member((int)POINTER_SIZE), LLVMOrcCSymbolDependenceGroup.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SYMBOLS = layout.offsetof(0);
        DEPENDENCIES = layout.offsetof(1);
        NUMDEPENDENCIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolDependenceGroup, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolDependenceGroup ELEMENT_FACTORY = LLVMOrcCSymbolDependenceGroup.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected LLVMOrcCSymbolDependenceGroup getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public LLVMOrcCSymbolsList Symbols() {
            return LLVMOrcCSymbolDependenceGroup.nSymbols(this.address());
        }

        @NativeType(value="LLVMOrcCDependenceMapPairs")
        public LLVMOrcCDependenceMapPair.Buffer Dependencies() {
            return LLVMOrcCSymbolDependenceGroup.nDependencies(this.address());
        }

        @NativeType(value="size_t")
        public long NumDependencies() {
            return LLVMOrcCSymbolDependenceGroup.nNumDependencies(this.address());
        }

        public Buffer Symbols(LLVMOrcCSymbolsList value) {
            LLVMOrcCSymbolDependenceGroup.nSymbols(this.address(), value);
            return this;
        }

        public Buffer Symbols(Consumer<LLVMOrcCSymbolsList> consumer) {
            consumer.accept(this.Symbols());
            return this;
        }

        public Buffer Dependencies(@NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer value) {
            LLVMOrcCSymbolDependenceGroup.nDependencies(this.address(), value);
            return this;
        }
    }
}

