/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOrcCSymbolAliasMapEntry;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolAliasMapPair
extends Struct<LLVMOrcCSymbolAliasMapPair>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int ENTRY;

    protected LLVMOrcCSymbolAliasMapPair(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LLVMOrcCSymbolAliasMapPair create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCSymbolAliasMapPair(address, container);
    }

    public LLVMOrcCSymbolAliasMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOrcCSymbolAliasMapPair.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCSymbolAliasMapPair.nName(this.address());
    }

    public LLVMOrcCSymbolAliasMapEntry Entry() {
        return LLVMOrcCSymbolAliasMapPair.nEntry(this.address());
    }

    public LLVMOrcCSymbolAliasMapPair Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCSymbolAliasMapPair.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair Entry(LLVMOrcCSymbolAliasMapEntry value) {
        LLVMOrcCSymbolAliasMapPair.nEntry(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair Entry(Consumer<LLVMOrcCSymbolAliasMapEntry> consumer) {
        consumer.accept(this.Entry());
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair set(long Name, LLVMOrcCSymbolAliasMapEntry Entry) {
        this.Name(Name);
        this.Entry(Entry);
        return this;
    }

    public LLVMOrcCSymbolAliasMapPair set(LLVMOrcCSymbolAliasMapPair src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolAliasMapPair malloc() {
        return new LLVMOrcCSymbolAliasMapPair(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LLVMOrcCSymbolAliasMapPair calloc() {
        return new LLVMOrcCSymbolAliasMapPair(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LLVMOrcCSymbolAliasMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LLVMOrcCSymbolAliasMapPair(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LLVMOrcCSymbolAliasMapPair create(long address) {
        return new LLVMOrcCSymbolAliasMapPair(address, null);
    }

    public static @Nullable LLVMOrcCSymbolAliasMapPair createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCSymbolAliasMapPair(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LLVMOrcCSymbolAliasMapPair.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolAliasMapPair.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCSymbolAliasMapPair malloc(MemoryStack stack) {
        return new LLVMOrcCSymbolAliasMapPair(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCSymbolAliasMapPair calloc(MemoryStack stack) {
        return new LLVMOrcCSymbolAliasMapPair(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NAME));
    }

    public static LLVMOrcCSymbolAliasMapEntry nEntry(long struct) {
        return LLVMOrcCSymbolAliasMapEntry.create(struct + (long)ENTRY);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)Checks.check((long)value));
    }

    public static void nEntry(long struct, LLVMOrcCSymbolAliasMapEntry value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ENTRY), (long)LLVMOrcCSymbolAliasMapEntry.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
        LLVMOrcCSymbolAliasMapEntry.validate(struct + (long)ENTRY);
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolAliasMapPair.__struct((Struct.Member[])new Struct.Member[]{LLVMOrcCSymbolAliasMapPair.__member((int)POINTER_SIZE), LLVMOrcCSymbolAliasMapPair.__member((int)LLVMOrcCSymbolAliasMapEntry.SIZEOF, (int)LLVMOrcCSymbolAliasMapEntry.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        ENTRY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolAliasMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolAliasMapPair ELEMENT_FACTORY = LLVMOrcCSymbolAliasMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected LLVMOrcCSymbolAliasMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCSymbolAliasMapPair.nName(this.address());
        }

        public LLVMOrcCSymbolAliasMapEntry Entry() {
            return LLVMOrcCSymbolAliasMapPair.nEntry(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCSymbolAliasMapPair.nName(this.address(), value);
            return this;
        }

        public Buffer Entry(LLVMOrcCSymbolAliasMapEntry value) {
            LLVMOrcCSymbolAliasMapPair.nEntry(this.address(), value);
            return this;
        }

        public Buffer Entry(Consumer<LLVMOrcCSymbolAliasMapEntry> consumer) {
            consumer.accept(this.Entry());
            return this;
        }
    }
}

