/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXVersion
extends Struct<CXVersion> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAJOR;
    public static final int MINOR;
    public static final int SUBMINOR;

    protected CXVersion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXVersion create(long address, @Nullable ByteBuffer container) {
        return new CXVersion(address, container);
    }

    public CXVersion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXVersion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int Major() {
        return CXVersion.nMajor(this.address());
    }

    public int Minor() {
        return CXVersion.nMinor(this.address());
    }

    public int Subminor() {
        return CXVersion.nSubminor(this.address());
    }

    public static CXVersion create(long address) {
        return new CXVersion(address, null);
    }

    public static @Nullable CXVersion createSafe(long address) {
        return address == 0L ? null : new CXVersion(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nMajor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAJOR));
    }

    public static int nMinor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MINOR));
    }

    public static int nSubminor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBMINOR));
    }

    static {
        Struct.Layout layout = CXVersion.__struct((Struct.Member[])new Struct.Member[]{CXVersion.__member((int)4), CXVersion.__member((int)4), CXVersion.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAJOR = layout.offsetof(0);
        MINOR = layout.offsetof(1);
        SUBMINOR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXVersion, Buffer> {
        private static final CXVersion ELEMENT_FACTORY = CXVersion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXVersion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int Major() {
            return CXVersion.nMajor(this.address());
        }

        public int Minor() {
            return CXVersion.nMinor(this.address());
        }

        public int Subminor() {
            return CXVersion.nSubminor(this.address());
        }
    }
}

