/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.CXTUResourceUsageEntry;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXTUResourceUsage
extends Struct<CXTUResourceUsage>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int NUMENTRIES;
    public static final int ENTRIES;

    protected CXTUResourceUsage(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXTUResourceUsage create(long address, @Nullable ByteBuffer container) {
        return new CXTUResourceUsage(address, container);
    }

    public CXTUResourceUsage(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXTUResourceUsage.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long data() {
        return CXTUResourceUsage.ndata(this.address());
    }

    @NativeType(value="unsigned")
    public int numEntries() {
        return CXTUResourceUsage.nnumEntries(this.address());
    }

    @NativeType(value="CXTUResourceUsageEntry *")
    public CXTUResourceUsageEntry.Buffer entries() {
        return CXTUResourceUsage.nentries(this.address());
    }

    public static CXTUResourceUsage malloc() {
        return new CXTUResourceUsage(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXTUResourceUsage calloc() {
        return new CXTUResourceUsage(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXTUResourceUsage create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXTUResourceUsage(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXTUResourceUsage create(long address) {
        return new CXTUResourceUsage(address, null);
    }

    public static @Nullable CXTUResourceUsage createSafe(long address) {
        return address == 0L ? null : new CXTUResourceUsage(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXTUResourceUsage.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXTUResourceUsage.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXTUResourceUsage mallocStack() {
        return CXTUResourceUsage.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXTUResourceUsage callocStack() {
        return CXTUResourceUsage.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXTUResourceUsage mallocStack(MemoryStack stack) {
        return CXTUResourceUsage.malloc(stack);
    }

    @Deprecated
    public static CXTUResourceUsage callocStack(MemoryStack stack) {
        return CXTUResourceUsage.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXTUResourceUsage.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXTUResourceUsage.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXTUResourceUsage.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXTUResourceUsage.calloc(capacity, stack);
    }

    public static CXTUResourceUsage malloc(MemoryStack stack) {
        return new CXTUResourceUsage(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXTUResourceUsage calloc(MemoryStack stack) {
        return new CXTUResourceUsage(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndata(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DATA));
    }

    public static int nnumEntries(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUMENTRIES));
    }

    public static CXTUResourceUsageEntry.Buffer nentries(long struct) {
        return CXTUResourceUsageEntry.create(MemoryUtil.memGetAddress((long)(struct + (long)ENTRIES)), CXTUResourceUsage.nnumEntries(struct));
    }

    static {
        Struct.Layout layout = CXTUResourceUsage.__struct((Struct.Member[])new Struct.Member[]{CXTUResourceUsage.__member((int)POINTER_SIZE), CXTUResourceUsage.__member((int)4), CXTUResourceUsage.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        NUMENTRIES = layout.offsetof(1);
        ENTRIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXTUResourceUsage, Buffer>
    implements NativeResource {
        private static final CXTUResourceUsage ELEMENT_FACTORY = CXTUResourceUsage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXTUResourceUsage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long data() {
            return CXTUResourceUsage.ndata(this.address());
        }

        @NativeType(value="unsigned")
        public int numEntries() {
            return CXTUResourceUsage.nnumEntries(this.address());
        }

        @NativeType(value="CXTUResourceUsageEntry *")
        public CXTUResourceUsageEntry.Buffer entries() {
            return CXTUResourceUsage.nentries(this.address());
        }
    }
}

