/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXString
extends Struct<CXString>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int PRIVATE_FLAGS;

    protected CXString(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXString create(long address, @Nullable ByteBuffer container) {
        return new CXString(address, container);
    }

    public CXString(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXString.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public ByteBuffer data(int capacity) {
        return CXString.ndata(this.address(), capacity);
    }

    @NativeType(value="unsigned")
    public int private_flags() {
        return CXString.nprivate_flags(this.address());
    }

    public static CXString malloc() {
        return new CXString(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXString calloc() {
        return new CXString(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXString create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXString(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXString create(long address) {
        return new CXString(address, null);
    }

    public static @Nullable CXString createSafe(long address) {
        return address == 0L ? null : new CXString(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXString.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXString.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXString mallocStack() {
        return CXString.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXString callocStack() {
        return CXString.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXString mallocStack(MemoryStack stack) {
        return CXString.malloc(stack);
    }

    @Deprecated
    public static CXString callocStack(MemoryStack stack) {
        return CXString.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXString.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXString.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXString.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXString.calloc(capacity, stack);
    }

    public static CXString malloc(MemoryStack stack) {
        return new CXString(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXString calloc(MemoryStack stack) {
        return new CXString(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)capacity);
    }

    public static int nprivate_flags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRIVATE_FLAGS));
    }

    static {
        Struct.Layout layout = CXString.__struct((Struct.Member[])new Struct.Member[]{CXString.__member((int)POINTER_SIZE), CXString.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        PRIVATE_FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXString, Buffer>
    implements NativeResource {
        private static final CXString ELEMENT_FACTORY = CXString.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXString getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public ByteBuffer data(int capacity) {
            return CXString.ndata(this.address(), capacity);
        }

        @NativeType(value="unsigned")
        public int private_flags() {
            return CXString.nprivate_flags(this.address());
        }
    }
}

