/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXComment
extends Struct<CXComment>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASTNODE;
    public static final int TRANSLATIONUNIT;

    protected CXComment(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXComment create(long address, @Nullable ByteBuffer container) {
        return new CXComment(address, container);
    }

    public CXComment(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXComment.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public long ASTNode() {
        return CXComment.nASTNode(this.address());
    }

    @NativeType(value="CXTranslationUnit")
    public long TranslationUnit() {
        return CXComment.nTranslationUnit(this.address());
    }

    public static CXComment malloc() {
        return new CXComment(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXComment calloc() {
        return new CXComment(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXComment create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXComment(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXComment create(long address) {
        return new CXComment(address, null);
    }

    public static @Nullable CXComment createSafe(long address) {
        return address == 0L ? null : new CXComment(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXComment.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXComment.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXComment mallocStack() {
        return CXComment.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXComment callocStack() {
        return CXComment.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXComment mallocStack(MemoryStack stack) {
        return CXComment.malloc(stack);
    }

    @Deprecated
    public static CXComment callocStack(MemoryStack stack) {
        return CXComment.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXComment.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXComment.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXComment.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXComment.calloc(capacity, stack);
    }

    public static CXComment malloc(MemoryStack stack) {
        return new CXComment(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXComment calloc(MemoryStack stack) {
        return new CXComment(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nASTNode(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ASTNODE));
    }

    public static long nTranslationUnit(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TRANSLATIONUNIT));
    }

    static {
        Struct.Layout layout = CXComment.__struct((Struct.Member[])new Struct.Member[]{CXComment.__member((int)POINTER_SIZE), CXComment.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASTNODE = layout.offsetof(0);
        TRANSLATIONUNIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXComment, Buffer>
    implements NativeResource {
        private static final CXComment ELEMENT_FACTORY = CXComment.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXComment getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public long ASTNode() {
            return CXComment.nASTNode(this.address());
        }

        @NativeType(value="CXTranslationUnit")
        public long TranslationUnit() {
            return CXComment.nTranslationUnit(this.address());
        }
    }
}

