/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.jemalloc.MallocMessageCallbackI;

public class JEmalloc {
    private static final SharedLibrary JEMALLOC = Library.loadNative((String)((String)Configuration.JEMALLOC_LIBRARY_NAME.get((Object)Platform.mapLibraryNameBundled((String)"jemalloc"))));

    protected JEmalloc() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return JEMALLOC;
    }

    public static PointerBuffer je_malloc_message() {
        long __result = Functions.malloc_message;
        return MemoryUtil.memPointerBuffer((long)__result, (int)1);
    }

    public static long nje_malloc(long size) {
        long __functionAddress = Functions.malloc;
        return JNI.invokePP((long)__functionAddress, (long)size);
    }

    public static ByteBuffer je_malloc(long size) {
        long __result = JEmalloc.nje_malloc(size);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)size));
    }

    public static long nje_calloc(long num, long size) {
        long __functionAddress = Functions.calloc;
        return JNI.invokePPP((long)__functionAddress, (long)num, (long)size);
    }

    public static ByteBuffer je_calloc(long num, long size) {
        long __result = JEmalloc.nje_calloc(num, size);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)num * (int)size));
    }

    public static int nje_posix_memalign(long memptr, long alignment, long size) {
        long __functionAddress = Functions.posix_memalign;
        return JNI.invokePPPI((long)__functionAddress, (long)memptr, (long)alignment, (long)size);
    }

    public static int je_posix_memalign(PointerBuffer memptr, long alignment, long size) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((CustomBuffer)memptr, (int)1);
        }
        return JEmalloc.nje_posix_memalign(MemoryUtil.memAddress((CustomBuffer)memptr), alignment, size);
    }

    public static long nje_aligned_alloc(long alignment, long size) {
        long __functionAddress = Functions.aligned_alloc;
        return JNI.invokePPP((long)__functionAddress, (long)alignment, (long)size);
    }

    public static ByteBuffer je_aligned_alloc(long alignment, long size) {
        long __result = JEmalloc.nje_aligned_alloc(alignment, size);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)size));
    }

    public static long nje_realloc(long ptr, long size) {
        long __functionAddress = Functions.realloc;
        return JNI.invokePPP((long)__functionAddress, (long)ptr, (long)size);
    }

    public static ByteBuffer je_realloc(ByteBuffer ptr, long size) {
        long __result = JEmalloc.nje_realloc(MemoryUtil.memAddressSafe((ByteBuffer)ptr), size);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)size));
    }

    public static void nje_free(long ptr) {
        long __functionAddress = Functions.free;
        JNI.invokePV((long)__functionAddress, (long)ptr);
    }

    public static void je_free(ByteBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe((ByteBuffer)ptr));
    }

    public static void je_free(ShortBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe((ShortBuffer)ptr));
    }

    public static void je_free(IntBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe((IntBuffer)ptr));
    }

    public static void je_free(LongBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe((LongBuffer)ptr));
    }

    public static void je_free(FloatBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe((FloatBuffer)ptr));
    }

    public static void je_free(DoubleBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe((DoubleBuffer)ptr));
    }

    public static void je_free(PointerBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe((Pointer)ptr));
    }

    public static long nje_mallocx(long size, int flags) {
        long __functionAddress = Functions.mallocx;
        return JNI.invokePP((long)__functionAddress, (long)size, (int)flags);
    }

    public static ByteBuffer je_mallocx(long size, int flags) {
        long __result = JEmalloc.nje_mallocx(size, flags);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)size));
    }

    public static long nje_rallocx(long ptr, long size, int flags) {
        long __functionAddress = Functions.rallocx;
        return JNI.invokePPP((long)__functionAddress, (long)ptr, (long)size, (int)flags);
    }

    public static ByteBuffer je_rallocx(ByteBuffer ptr, long size, int flags) {
        long __result = JEmalloc.nje_rallocx(MemoryUtil.memAddressSafe((ByteBuffer)ptr), size, flags);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)size));
    }

    public static long nje_xallocx(long ptr, long size, long extra, int flags) {
        long __functionAddress = Functions.xallocx;
        return JNI.invokePPPP((long)__functionAddress, (long)ptr, (long)size, (long)extra, (int)flags);
    }

    public static long je_xallocx(ByteBuffer ptr, long size, long extra, int flags) {
        return JEmalloc.nje_xallocx(MemoryUtil.memAddressSafe((ByteBuffer)ptr), size, extra, flags);
    }

    public static long nje_sallocx(long ptr, int flags) {
        long __functionAddress = Functions.sallocx;
        return JNI.invokePP((long)__functionAddress, (long)ptr, (int)flags);
    }

    public static long je_sallocx(ByteBuffer ptr, int flags) {
        return JEmalloc.nje_sallocx(MemoryUtil.memAddress((ByteBuffer)ptr), flags);
    }

    public static void nje_dallocx(long ptr, int flags) {
        long __functionAddress = Functions.dallocx;
        JNI.invokePV((long)__functionAddress, (long)ptr, (int)flags);
    }

    public static void je_dallocx(ByteBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress((ByteBuffer)ptr), flags);
    }

    public static void je_dallocx(ShortBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress((ShortBuffer)ptr), flags);
    }

    public static void je_dallocx(IntBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress((IntBuffer)ptr), flags);
    }

    public static void je_dallocx(LongBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress((LongBuffer)ptr), flags);
    }

    public static void je_dallocx(FloatBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress((FloatBuffer)ptr), flags);
    }

    public static void je_dallocx(DoubleBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress((DoubleBuffer)ptr), flags);
    }

    public static void je_dallocx(PointerBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress((CustomBuffer)ptr), flags);
    }

    public static void nje_sdallocx(long ptr, long size, int flags) {
        long __functionAddress = Functions.sdallocx;
        JNI.invokePPV((long)__functionAddress, (long)ptr, (long)size, (int)flags);
    }

    public static void je_sdallocx(ByteBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress((ByteBuffer)ptr), ptr.remaining(), flags);
    }

    public static void je_sdallocx(ShortBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress((ShortBuffer)ptr), ptr.remaining() << 1, flags);
    }

    public static void je_sdallocx(IntBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress((IntBuffer)ptr), ptr.remaining() << 2, flags);
    }

    public static void je_sdallocx(LongBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress((LongBuffer)ptr), ptr.remaining() << 3, flags);
    }

    public static void je_sdallocx(FloatBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress((FloatBuffer)ptr), ptr.remaining() << 2, flags);
    }

    public static void je_sdallocx(DoubleBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress((DoubleBuffer)ptr), ptr.remaining() << 3, flags);
    }

    public static void je_sdallocx(PointerBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress((CustomBuffer)ptr), ptr.remaining() << Pointer.POINTER_SHIFT, flags);
    }

    public static long nje_nallocx(long size, int flags) {
        long __functionAddress = Functions.nallocx;
        return JNI.invokePP((long)__functionAddress, (long)size, (int)flags);
    }

    public static ByteBuffer je_nallocx(long size, int flags) {
        long __result = JEmalloc.nje_nallocx(size, flags);
        return MemoryUtil.memByteBuffer((long)__result, (int)((int)size));
    }

    public static int nje_mallctl(long name, long oldp, long oldlenp, long newp, long newlen) {
        long __functionAddress = Functions.mallctl;
        return JNI.invokePPPPPI((long)__functionAddress, (long)name, (long)oldp, (long)oldlenp, (long)newp, (long)newlen);
    }

    public static int je_mallctl(ByteBuffer name, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.checkBufferSafe((CustomBuffer)oldlenp, (int)1);
        }
        return JEmalloc.nje_mallctl(MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddressSafe((ByteBuffer)oldp), MemoryUtil.memAddressSafe((Pointer)oldlenp), MemoryUtil.memAddressSafe((ByteBuffer)newp), Checks.remainingSafe((Buffer)newp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int je_mallctl(CharSequence name, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((CustomBuffer)oldlenp, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = JEmalloc.nje_mallctl(MemoryUtil.memAddress((ByteBuffer)nameEncoded), MemoryUtil.memAddressSafe((ByteBuffer)oldp), MemoryUtil.memAddressSafe((Pointer)oldlenp), MemoryUtil.memAddressSafe((ByteBuffer)newp), Checks.remainingSafe((Buffer)newp));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nje_mallctlnametomib(long name, long mibp, long miblenp) {
        long __functionAddress = Functions.mallctlnametomib;
        return JNI.invokePPPI((long)__functionAddress, (long)name, (long)mibp, (long)miblenp);
    }

    public static int je_mallctlnametomib(ByteBuffer name, PointerBuffer mibp, PointerBuffer miblenp) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.checkBuffer((CustomBuffer)miblenp, (int)1);
            Checks.checkBuffer((CustomBuffer)mibp, (long)miblenp.get(miblenp.position()));
        }
        return JEmalloc.nje_mallctlnametomib(MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddress((CustomBuffer)mibp), MemoryUtil.memAddress((CustomBuffer)miblenp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int je_mallctlnametomib(CharSequence name, PointerBuffer mibp, PointerBuffer miblenp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((CustomBuffer)miblenp, (int)1);
            Checks.checkBuffer((CustomBuffer)mibp, (long)miblenp.get(miblenp.position()));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = JEmalloc.nje_mallctlnametomib(MemoryUtil.memAddress((ByteBuffer)nameEncoded), MemoryUtil.memAddress((CustomBuffer)mibp), MemoryUtil.memAddress((CustomBuffer)miblenp));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nje_mallctlbymib(long mib, long miblen, long oldp, long oldlenp, long newp, long newlen) {
        long __functionAddress = Functions.mallctlbymib;
        return JNI.invokePPPPPPI((long)__functionAddress, (long)mib, (long)miblen, (long)oldp, (long)oldlenp, (long)newp, (long)newlen);
    }

    public static int je_mallctlbymib(PointerBuffer mib, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS) {
            Checks.checkBufferSafe((CustomBuffer)oldlenp, (int)1);
        }
        return JEmalloc.nje_mallctlbymib(MemoryUtil.memAddress((CustomBuffer)mib), mib.remaining(), MemoryUtil.memAddressSafe((ByteBuffer)oldp), MemoryUtil.memAddressSafe((Pointer)oldlenp), MemoryUtil.memAddressSafe((ByteBuffer)newp), Checks.remainingSafe((Buffer)newp));
    }

    public static void nje_malloc_stats_print(long write_cb, long je_cbopaque, long opts) {
        long __functionAddress = Functions.malloc_stats_print;
        JNI.invokePPPV((long)__functionAddress, (long)write_cb, (long)je_cbopaque, (long)opts);
    }

    public static void je_malloc_stats_print(MallocMessageCallbackI write_cb, ByteBuffer je_cbopaque, ByteBuffer opts) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)opts);
        }
        JEmalloc.nje_malloc_stats_print(MemoryUtil.memAddressSafe((Pointer)write_cb), MemoryUtil.memAddressSafe((ByteBuffer)je_cbopaque), MemoryUtil.memAddressSafe((ByteBuffer)opts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void je_malloc_stats_print(MallocMessageCallbackI write_cb, ByteBuffer je_cbopaque, CharSequence opts) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer optsEncoded = stack.ASCII(opts);
            JEmalloc.nje_malloc_stats_print(MemoryUtil.memAddressSafe((Pointer)write_cb), MemoryUtil.memAddressSafe((ByteBuffer)je_cbopaque), MemoryUtil.memAddressSafe((ByteBuffer)optsEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nje_malloc_usable_size(long ptr) {
        long __functionAddress = Functions.malloc_usable_size;
        return JNI.invokePP((long)__functionAddress, (long)ptr);
    }

    public static long je_malloc_usable_size(ByteBuffer ptr) {
        return JEmalloc.nje_malloc_usable_size(MemoryUtil.memAddress((ByteBuffer)ptr));
    }

    static /* synthetic */ SharedLibrary access$000() {
        return JEMALLOC;
    }

    public static final class Functions {
        public static final long malloc_message = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_malloc_message");
        public static final long malloc = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_malloc");
        public static final long calloc = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_calloc");
        public static final long posix_memalign = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_posix_memalign");
        public static final long aligned_alloc = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_aligned_alloc");
        public static final long realloc = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_realloc");
        public static final long free = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_free");
        public static final long mallocx = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_mallocx");
        public static final long rallocx = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_rallocx");
        public static final long xallocx = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_xallocx");
        public static final long sallocx = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_sallocx");
        public static final long dallocx = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_dallocx");
        public static final long sdallocx = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_sdallocx");
        public static final long nallocx = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_nallocx");
        public static final long mallctl = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_mallctl");
        public static final long mallctlnametomib = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_mallctlnametomib");
        public static final long mallctlbymib = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_mallctlbymib");
        public static final long malloc_stats_print = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_malloc_stats_print");
        public static final long malloc_usable_size = APIUtil.apiGetFunctionAddress((FunctionProvider)JEmalloc.access$000(), (String)"je_malloc_usable_size");

        private Functions() {
        }
    }
}

