/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct JAWT_X11DrawingSurfaceInfo")
public class JAWTX11DrawingSurfaceInfo
extends Struct<JAWTX11DrawingSurfaceInfo> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DRAWABLE;
    public static final int DISPLAY;
    public static final int VISUALID;
    public static final int COLORMAPID;
    public static final int DEPTH;

    protected JAWTX11DrawingSurfaceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected JAWTX11DrawingSurfaceInfo create(long address, @Nullable ByteBuffer container) {
        return new JAWTX11DrawingSurfaceInfo(address, container);
    }

    public JAWTX11DrawingSurfaceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), JAWTX11DrawingSurfaceInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Drawable")
    public long drawable() {
        return JAWTX11DrawingSurfaceInfo.ndrawable(this.address());
    }

    @NativeType(value="Display *")
    public long display() {
        return JAWTX11DrawingSurfaceInfo.ndisplay(this.address());
    }

    @NativeType(value="VisualID")
    public long visualID() {
        return JAWTX11DrawingSurfaceInfo.nvisualID(this.address());
    }

    @NativeType(value="Colormap")
    public long colormapID() {
        return JAWTX11DrawingSurfaceInfo.ncolormapID(this.address());
    }

    public int depth() {
        return JAWTX11DrawingSurfaceInfo.ndepth(this.address());
    }

    public static JAWTX11DrawingSurfaceInfo create(long address) {
        return new JAWTX11DrawingSurfaceInfo(address, null);
    }

    public static @Nullable JAWTX11DrawingSurfaceInfo createSafe(long address) {
        return address == 0L ? null : new JAWTX11DrawingSurfaceInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static long ndrawable(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)DRAWABLE));
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)DISPLAY));
    }

    public static long nvisualID(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)VISUALID));
    }

    public static long ncolormapID(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)COLORMAPID));
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEPTH));
    }

    static {
        Struct.Layout layout = JAWTX11DrawingSurfaceInfo.__struct((Struct.Member[])new Struct.Member[]{JAWTX11DrawingSurfaceInfo.__member((int)CLONG_SIZE), JAWTX11DrawingSurfaceInfo.__member((int)POINTER_SIZE), JAWTX11DrawingSurfaceInfo.__member((int)CLONG_SIZE), JAWTX11DrawingSurfaceInfo.__member((int)CLONG_SIZE), JAWTX11DrawingSurfaceInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DRAWABLE = layout.offsetof(0);
        DISPLAY = layout.offsetof(1);
        VISUALID = layout.offsetof(2);
        COLORMAPID = layout.offsetof(3);
        DEPTH = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<JAWTX11DrawingSurfaceInfo, Buffer> {
        private static final JAWTX11DrawingSurfaceInfo ELEMENT_FACTORY = JAWTX11DrawingSurfaceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected JAWTX11DrawingSurfaceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Drawable")
        public long drawable() {
            return JAWTX11DrawingSurfaceInfo.ndrawable(this.address());
        }

        @NativeType(value="Display *")
        public long display() {
            return JAWTX11DrawingSurfaceInfo.ndisplay(this.address());
        }

        @NativeType(value="VisualID")
        public long visualID() {
            return JAWTX11DrawingSurfaceInfo.nvisualID(this.address());
        }

        @NativeType(value="Colormap")
        public long colormapID() {
            return JAWTX11DrawingSurfaceInfo.ncolormapID(this.address());
        }

        public int depth() {
            return JAWTX11DrawingSurfaceInfo.ndepth(this.address());
        }
    }
}

