/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.hwloc.hwloc_bridge_attr_s;
import org.lwjgl.util.hwloc.hwloc_cache_attr_s;
import org.lwjgl.util.hwloc.hwloc_group_attr_s;
import org.lwjgl.util.hwloc.hwloc_numanode_attr_s;
import org.lwjgl.util.hwloc.hwloc_osdev_attr_s;
import org.lwjgl.util.hwloc.hwloc_pcidev_attr_s;

@NativeType(value="union struct hwloc_obj_attr_u")
public class hwloc_obj_attr_u
extends Struct<hwloc_obj_attr_u>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUMANODE;
    public static final int CACHE;
    public static final int GROUP;
    public static final int PCIDEV;
    public static final int BRIDGE;
    public static final int OSDEV;

    protected hwloc_obj_attr_u(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected hwloc_obj_attr_u create(long address, @Nullable ByteBuffer container) {
        return new hwloc_obj_attr_u(address, container);
    }

    public hwloc_obj_attr_u(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), hwloc_obj_attr_u.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public hwloc_numanode_attr_s numanode() {
        return hwloc_obj_attr_u.nnumanode(this.address());
    }

    public hwloc_cache_attr_s cache() {
        return hwloc_obj_attr_u.ncache(this.address());
    }

    public hwloc_group_attr_s group() {
        return hwloc_obj_attr_u.ngroup(this.address());
    }

    public hwloc_pcidev_attr_s pcidev() {
        return hwloc_obj_attr_u.npcidev(this.address());
    }

    public hwloc_bridge_attr_s bridge() {
        return hwloc_obj_attr_u.nbridge(this.address());
    }

    public hwloc_osdev_attr_s osdev() {
        return hwloc_obj_attr_u.nosdev(this.address());
    }

    public static hwloc_obj_attr_u malloc() {
        return new hwloc_obj_attr_u(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static hwloc_obj_attr_u calloc() {
        return new hwloc_obj_attr_u(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static hwloc_obj_attr_u create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new hwloc_obj_attr_u(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static hwloc_obj_attr_u create(long address) {
        return new hwloc_obj_attr_u(address, null);
    }

    public static @Nullable hwloc_obj_attr_u createSafe(long address) {
        return address == 0L ? null : new hwloc_obj_attr_u(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)hwloc_obj_attr_u.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = hwloc_obj_attr_u.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static hwloc_obj_attr_u malloc(MemoryStack stack) {
        return new hwloc_obj_attr_u(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static hwloc_obj_attr_u calloc(MemoryStack stack) {
        return new hwloc_obj_attr_u(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static hwloc_numanode_attr_s nnumanode(long struct) {
        return hwloc_numanode_attr_s.create(struct + (long)NUMANODE);
    }

    public static hwloc_cache_attr_s ncache(long struct) {
        return hwloc_cache_attr_s.create(struct + (long)CACHE);
    }

    public static hwloc_group_attr_s ngroup(long struct) {
        return hwloc_group_attr_s.create(struct + (long)GROUP);
    }

    public static hwloc_pcidev_attr_s npcidev(long struct) {
        return hwloc_pcidev_attr_s.create(struct + (long)PCIDEV);
    }

    public static hwloc_bridge_attr_s nbridge(long struct) {
        return hwloc_bridge_attr_s.create(struct + (long)BRIDGE);
    }

    public static hwloc_osdev_attr_s nosdev(long struct) {
        return hwloc_osdev_attr_s.create(struct + (long)OSDEV);
    }

    static {
        Struct.Layout layout = hwloc_obj_attr_u.__union((Struct.Member[])new Struct.Member[]{hwloc_obj_attr_u.__member((int)hwloc_numanode_attr_s.SIZEOF, (int)hwloc_numanode_attr_s.ALIGNOF), hwloc_obj_attr_u.__member((int)hwloc_cache_attr_s.SIZEOF, (int)hwloc_cache_attr_s.ALIGNOF), hwloc_obj_attr_u.__member((int)hwloc_group_attr_s.SIZEOF, (int)hwloc_group_attr_s.ALIGNOF), hwloc_obj_attr_u.__member((int)hwloc_pcidev_attr_s.SIZEOF, (int)hwloc_pcidev_attr_s.ALIGNOF), hwloc_obj_attr_u.__member((int)hwloc_bridge_attr_s.SIZEOF, (int)hwloc_bridge_attr_s.ALIGNOF), hwloc_obj_attr_u.__member((int)hwloc_osdev_attr_s.SIZEOF, (int)hwloc_osdev_attr_s.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUMANODE = layout.offsetof(0);
        CACHE = layout.offsetof(1);
        GROUP = layout.offsetof(2);
        PCIDEV = layout.offsetof(3);
        BRIDGE = layout.offsetof(4);
        OSDEV = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<hwloc_obj_attr_u, Buffer>
    implements NativeResource {
        private static final hwloc_obj_attr_u ELEMENT_FACTORY = hwloc_obj_attr_u.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected hwloc_obj_attr_u getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public hwloc_numanode_attr_s numanode() {
            return hwloc_obj_attr_u.nnumanode(this.address());
        }

        public hwloc_cache_attr_s cache() {
            return hwloc_obj_attr_u.ncache(this.address());
        }

        public hwloc_group_attr_s group() {
            return hwloc_obj_attr_u.ngroup(this.address());
        }

        public hwloc_pcidev_attr_s pcidev() {
            return hwloc_obj_attr_u.npcidev(this.address());
        }

        public hwloc_bridge_attr_s bridge() {
            return hwloc_obj_attr_u.nbridge(this.address());
        }

        public hwloc_osdev_attr_s osdev() {
            return hwloc_obj_attr_u.nosdev(this.address());
        }
    }
}

