/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.hwloc.hwloc_infos_s;
import org.lwjgl.util.hwloc.hwloc_obj_attr_u;

@NativeType(value="struct hwloc_obj")
public class hwloc_obj
extends Struct<hwloc_obj>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SUBTYPE;
    public static final int OS_INDEX;
    public static final int NAME;
    public static final int TOTAL_MEMORY;
    public static final int ATTR;
    public static final int DEPTH;
    public static final int LOGICAL_INDEX;
    public static final int NEXT_COUSIN;
    public static final int PREV_COUSIN;
    public static final int PARENT;
    public static final int SIBLING_RANK;
    public static final int NEXT_SIBLING;
    public static final int PREV_SIBLING;
    public static final int ARITY;
    public static final int CHILDREN;
    public static final int FIRST_CHILD;
    public static final int LAST_CHILD;
    public static final int SYMMETRIC_SUBTREE;
    public static final int MEMORY_ARITY;
    public static final int MEMORY_FIRST_CHILD;
    public static final int IO_ARITY;
    public static final int IO_FIRST_CHILD;
    public static final int MISC_ARITY;
    public static final int MISC_FIRST_CHILD;
    public static final int CPUSET;
    public static final int COMPLETE_CPUSET;
    public static final int NODESET;
    public static final int COMPLETE_NODESET;
    public static final int INFOS;
    public static final int USERDATA;
    public static final int GP_INDEX;

    protected hwloc_obj(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected hwloc_obj create(long address, @Nullable ByteBuffer container) {
        return new hwloc_obj(address, container);
    }

    public hwloc_obj(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), hwloc_obj.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="hwloc_obj_type_t")
    public int type() {
        return hwloc_obj.ntype(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer subtype() {
        return hwloc_obj.nsubtype(this.address());
    }

    @NativeType(value="char *")
    public String subtypeString() {
        return hwloc_obj.nsubtypeString(this.address());
    }

    @NativeType(value="unsigned")
    public int os_index() {
        return hwloc_obj.nos_index(this.address());
    }

    @NativeType(value="char *")
    public @Nullable ByteBuffer name() {
        return hwloc_obj.nname(this.address());
    }

    @NativeType(value="char *")
    public @Nullable String nameString() {
        return hwloc_obj.nnameString(this.address());
    }

    @NativeType(value="hwloc_uint64_t")
    public long total_memory() {
        return hwloc_obj.ntotal_memory(this.address());
    }

    @NativeType(value="struct hwloc_obj_attr_u *")
    public hwloc_obj_attr_u attr() {
        return hwloc_obj.nattr(this.address());
    }

    public int depth() {
        return hwloc_obj.ndepth(this.address());
    }

    @NativeType(value="unsigned")
    public int logical_index() {
        return hwloc_obj.nlogical_index(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj next_cousin() {
        return hwloc_obj.nnext_cousin(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj prev_cousin() {
        return hwloc_obj.nprev_cousin(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj parent() {
        return hwloc_obj.nparent(this.address());
    }

    @NativeType(value="unsigned")
    public int sibling_rank() {
        return hwloc_obj.nsibling_rank(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj next_sibling() {
        return hwloc_obj.nnext_sibling(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj prev_sibling() {
        return hwloc_obj.nprev_sibling(this.address());
    }

    @NativeType(value="unsigned")
    public int arity() {
        return hwloc_obj.narity(this.address());
    }

    @NativeType(value="struct hwloc_obj **")
    public @Nullable PointerBuffer children() {
        return hwloc_obj.nchildren(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj first_child() {
        return hwloc_obj.nfirst_child(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj last_child() {
        return hwloc_obj.nlast_child(this.address());
    }

    @NativeType(value="int")
    public boolean symmetric_subtree() {
        return hwloc_obj.nsymmetric_subtree(this.address()) != 0;
    }

    @NativeType(value="unsigned")
    public int memory_arity() {
        return hwloc_obj.nmemory_arity(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj memory_first_child() {
        return hwloc_obj.nmemory_first_child(this.address());
    }

    @NativeType(value="unsigned")
    public int io_arity() {
        return hwloc_obj.nio_arity(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj io_first_child() {
        return hwloc_obj.nio_first_child(this.address());
    }

    @NativeType(value="unsigned")
    public int misc_arity() {
        return hwloc_obj.nmisc_arity(this.address());
    }

    @NativeType(value="struct hwloc_obj *")
    public @Nullable hwloc_obj misc_first_child() {
        return hwloc_obj.nmisc_first_child(this.address());
    }

    @NativeType(value="hwloc_cpuset_t")
    public long cpuset() {
        return hwloc_obj.ncpuset(this.address());
    }

    @NativeType(value="hwloc_cpuset_t")
    public long complete_cpuset() {
        return hwloc_obj.ncomplete_cpuset(this.address());
    }

    @NativeType(value="hwloc_nodeset_t")
    public long nodeset() {
        return hwloc_obj.nnodeset(this.address());
    }

    @NativeType(value="hwloc_nodeset_t")
    public long complete_nodeset() {
        return hwloc_obj.ncomplete_nodeset(this.address());
    }

    @NativeType(value="struct hwloc_infos_s")
    public hwloc_infos_s infos() {
        return hwloc_obj.ninfos(this.address());
    }

    @NativeType(value="void *")
    public long userdata() {
        return hwloc_obj.nuserdata(this.address());
    }

    @NativeType(value="hwloc_uint64_t")
    public long gp_index() {
        return hwloc_obj.ngp_index(this.address());
    }

    public hwloc_obj userdata(@NativeType(value="void *") long value) {
        hwloc_obj.nuserdata(this.address(), value);
        return this;
    }

    public hwloc_obj set(hwloc_obj src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static hwloc_obj malloc() {
        return new hwloc_obj(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static hwloc_obj calloc() {
        return new hwloc_obj(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static hwloc_obj create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new hwloc_obj(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static hwloc_obj create(long address) {
        return new hwloc_obj(address, null);
    }

    public static @Nullable hwloc_obj createSafe(long address) {
        return address == 0L ? null : new hwloc_obj(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)hwloc_obj.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = hwloc_obj.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static hwloc_obj malloc(MemoryStack stack) {
        return new hwloc_obj(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static hwloc_obj calloc(MemoryStack stack) {
        return new hwloc_obj(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static ByteBuffer nsubtype(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)SUBTYPE)));
    }

    public static String nsubtypeString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)SUBTYPE)));
    }

    public static int nos_index(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OS_INDEX));
    }

    public static @Nullable ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static @Nullable String nnameString(long struct) {
        return MemoryUtil.memASCIISafe((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    public static long ntotal_memory(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TOTAL_MEMORY));
    }

    public static hwloc_obj_attr_u nattr(long struct) {
        return hwloc_obj_attr_u.create(MemoryUtil.memGetAddress((long)(struct + (long)ATTR)));
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DEPTH));
    }

    public static int nlogical_index(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOGICAL_INDEX));
    }

    public static @Nullable hwloc_obj nnext_cousin(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT_COUSIN)));
    }

    public static @Nullable hwloc_obj nprev_cousin(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PREV_COUSIN)));
    }

    public static @Nullable hwloc_obj nparent(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PARENT)));
    }

    public static int nsibling_rank(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIBLING_RANK));
    }

    public static @Nullable hwloc_obj nnext_sibling(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT_SIBLING)));
    }

    public static @Nullable hwloc_obj nprev_sibling(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PREV_SIBLING)));
    }

    public static int narity(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ARITY));
    }

    public static @Nullable PointerBuffer nchildren(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)CHILDREN)), (int)hwloc_obj.narity(struct));
    }

    public static @Nullable hwloc_obj nfirst_child(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)FIRST_CHILD)));
    }

    public static @Nullable hwloc_obj nlast_child(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)LAST_CHILD)));
    }

    public static int nsymmetric_subtree(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SYMMETRIC_SUBTREE));
    }

    public static int nmemory_arity(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MEMORY_ARITY));
    }

    public static @Nullable hwloc_obj nmemory_first_child(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MEMORY_FIRST_CHILD)));
    }

    public static int nio_arity(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IO_ARITY));
    }

    public static @Nullable hwloc_obj nio_first_child(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)IO_FIRST_CHILD)));
    }

    public static int nmisc_arity(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MISC_ARITY));
    }

    public static @Nullable hwloc_obj nmisc_first_child(long struct) {
        return hwloc_obj.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MISC_FIRST_CHILD)));
    }

    public static long ncpuset(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CPUSET));
    }

    public static long ncomplete_cpuset(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COMPLETE_CPUSET));
    }

    public static long nnodeset(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NODESET));
    }

    public static long ncomplete_nodeset(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COMPLETE_NODESET));
    }

    public static hwloc_infos_s ninfos(long struct) {
        return hwloc_infos_s.create(struct + (long)INFOS);
    }

    public static long nuserdata(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)USERDATA));
    }

    public static long ngp_index(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)GP_INDEX));
    }

    public static void nuserdata(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)USERDATA), (long)value);
    }

    static {
        Struct.Layout layout = hwloc_obj.__struct((Struct.Member[])new Struct.Member[]{hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)8), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)4), hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)4), hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)4), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)hwloc_infos_s.SIZEOF, (int)hwloc_infos_s.ALIGNOF), hwloc_obj.__member((int)POINTER_SIZE), hwloc_obj.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        SUBTYPE = layout.offsetof(1);
        OS_INDEX = layout.offsetof(2);
        NAME = layout.offsetof(3);
        TOTAL_MEMORY = layout.offsetof(4);
        ATTR = layout.offsetof(5);
        DEPTH = layout.offsetof(6);
        LOGICAL_INDEX = layout.offsetof(7);
        NEXT_COUSIN = layout.offsetof(8);
        PREV_COUSIN = layout.offsetof(9);
        PARENT = layout.offsetof(10);
        SIBLING_RANK = layout.offsetof(11);
        NEXT_SIBLING = layout.offsetof(12);
        PREV_SIBLING = layout.offsetof(13);
        ARITY = layout.offsetof(14);
        CHILDREN = layout.offsetof(15);
        FIRST_CHILD = layout.offsetof(16);
        LAST_CHILD = layout.offsetof(17);
        SYMMETRIC_SUBTREE = layout.offsetof(18);
        MEMORY_ARITY = layout.offsetof(19);
        MEMORY_FIRST_CHILD = layout.offsetof(20);
        IO_ARITY = layout.offsetof(21);
        IO_FIRST_CHILD = layout.offsetof(22);
        MISC_ARITY = layout.offsetof(23);
        MISC_FIRST_CHILD = layout.offsetof(24);
        CPUSET = layout.offsetof(25);
        COMPLETE_CPUSET = layout.offsetof(26);
        NODESET = layout.offsetof(27);
        COMPLETE_NODESET = layout.offsetof(28);
        INFOS = layout.offsetof(29);
        USERDATA = layout.offsetof(30);
        GP_INDEX = layout.offsetof(31);
    }

    public static class Buffer
    extends StructBuffer<hwloc_obj, Buffer>
    implements NativeResource {
        private static final hwloc_obj ELEMENT_FACTORY = hwloc_obj.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected hwloc_obj getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="hwloc_obj_type_t")
        public int type() {
            return hwloc_obj.ntype(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer subtype() {
            return hwloc_obj.nsubtype(this.address());
        }

        @NativeType(value="char *")
        public String subtypeString() {
            return hwloc_obj.nsubtypeString(this.address());
        }

        @NativeType(value="unsigned")
        public int os_index() {
            return hwloc_obj.nos_index(this.address());
        }

        @NativeType(value="char *")
        public @Nullable ByteBuffer name() {
            return hwloc_obj.nname(this.address());
        }

        @NativeType(value="char *")
        public @Nullable String nameString() {
            return hwloc_obj.nnameString(this.address());
        }

        @NativeType(value="hwloc_uint64_t")
        public long total_memory() {
            return hwloc_obj.ntotal_memory(this.address());
        }

        @NativeType(value="struct hwloc_obj_attr_u *")
        public hwloc_obj_attr_u attr() {
            return hwloc_obj.nattr(this.address());
        }

        public int depth() {
            return hwloc_obj.ndepth(this.address());
        }

        @NativeType(value="unsigned")
        public int logical_index() {
            return hwloc_obj.nlogical_index(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj next_cousin() {
            return hwloc_obj.nnext_cousin(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj prev_cousin() {
            return hwloc_obj.nprev_cousin(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj parent() {
            return hwloc_obj.nparent(this.address());
        }

        @NativeType(value="unsigned")
        public int sibling_rank() {
            return hwloc_obj.nsibling_rank(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj next_sibling() {
            return hwloc_obj.nnext_sibling(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj prev_sibling() {
            return hwloc_obj.nprev_sibling(this.address());
        }

        @NativeType(value="unsigned")
        public int arity() {
            return hwloc_obj.narity(this.address());
        }

        @NativeType(value="struct hwloc_obj **")
        public @Nullable PointerBuffer children() {
            return hwloc_obj.nchildren(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj first_child() {
            return hwloc_obj.nfirst_child(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj last_child() {
            return hwloc_obj.nlast_child(this.address());
        }

        @NativeType(value="int")
        public boolean symmetric_subtree() {
            return hwloc_obj.nsymmetric_subtree(this.address()) != 0;
        }

        @NativeType(value="unsigned")
        public int memory_arity() {
            return hwloc_obj.nmemory_arity(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj memory_first_child() {
            return hwloc_obj.nmemory_first_child(this.address());
        }

        @NativeType(value="unsigned")
        public int io_arity() {
            return hwloc_obj.nio_arity(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj io_first_child() {
            return hwloc_obj.nio_first_child(this.address());
        }

        @NativeType(value="unsigned")
        public int misc_arity() {
            return hwloc_obj.nmisc_arity(this.address());
        }

        @NativeType(value="struct hwloc_obj *")
        public @Nullable hwloc_obj misc_first_child() {
            return hwloc_obj.nmisc_first_child(this.address());
        }

        @NativeType(value="hwloc_cpuset_t")
        public long cpuset() {
            return hwloc_obj.ncpuset(this.address());
        }

        @NativeType(value="hwloc_cpuset_t")
        public long complete_cpuset() {
            return hwloc_obj.ncomplete_cpuset(this.address());
        }

        @NativeType(value="hwloc_nodeset_t")
        public long nodeset() {
            return hwloc_obj.nnodeset(this.address());
        }

        @NativeType(value="hwloc_nodeset_t")
        public long complete_nodeset() {
            return hwloc_obj.ncomplete_nodeset(this.address());
        }

        @NativeType(value="struct hwloc_infos_s")
        public hwloc_infos_s infos() {
            return hwloc_obj.ninfos(this.address());
        }

        @NativeType(value="void *")
        public long userdata() {
            return hwloc_obj.nuserdata(this.address());
        }

        @NativeType(value="hwloc_uint64_t")
        public long gp_index() {
            return hwloc_obj.ngp_index(this.address());
        }

        public Buffer userdata(@NativeType(value="void *") long value) {
            hwloc_obj.nuserdata(this.address(), value);
            return this;
        }
    }
}

